/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.junit.Assert;

public class TestData {
    private static final String TEST_DATA_ROOT_FOLDER = "testData";
    private static final String PREFIX_SEPERATOR = "~";

    public static InputStream get(String testDataFolder, String testDataName) throws IOException {
        return new BufferedInputStream(TestActivator.getContext().getBundle().getEntry("testData/" + testDataFolder + "/" + testDataName).openStream());
    }

    public static File getFile(String testDataFolder, String testDataName) throws IOException {
        return new File(FileLocator.toFileURL((URL)TestActivator.getContext().getBundle().getEntry("testData/" + testDataFolder + "/" + testDataName)).getPath());
    }

    public static File getTempFile(String testDataFolder, String testDataName) throws IOException {
        File temp = TestData.createTempFile(testDataName);
        FileOutputStream out = new FileOutputStream(temp);
        FileUtils.copyStream((InputStream)TestData.get(testDataFolder, testDataName), (boolean)true, (OutputStream)out, (boolean)true);
        return temp;
    }

    public static File createTempFile(String testDataName) throws IOException {
        int i = testDataName.lastIndexOf(46);
        File temp = i == -1 ? File.createTempFile(String.valueOf(testDataName) + PREFIX_SEPERATOR, ".tmp") : File.createTempFile(String.valueOf(testDataName.substring(0, i)) + PREFIX_SEPERATOR, testDataName.substring(i));
        temp.deleteOnExit();
        return temp;
    }

    public static void assertEquals(File expected, File actual) throws IOException {
        Assert.assertEquals((String)"Files have different lengths.", (long)expected.length(), (long)actual.length());
        TestData.assertEquals(new BufferedInputStream(new FileInputStream(expected)), new BufferedInputStream(new FileInputStream(actual)));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertEquals(InputStream expected, InputStream actual) throws IOException {
        try {
            block8: {
                int count;
                int readActual;
                int readExpected;
                block7: {
                    readExpected = 0;
                    readActual = 0;
                    count = 0;
                    if (!true) break block7;
                    if (readActual == -1) return;
                    if (readExpected == -1) break block8;
                }
                do {
                    readActual = actual.read();
                    readExpected = expected.read();
                    Assert.assertEquals((String)("Different bytes at " + count), (long)readExpected, (long)readActual);
                    ++count;
                    if (readActual == -1) return;
                } while (readExpected != -1);
            }
            return;
        }
        finally {
            if (expected != null) {
                expected.close();
            }
            if (actual != null) {
                actual.close();
            }
        }
    }

    public static void assertEquals(ZipInputStream expected, ZipInputStream actual) throws IOException {
        Map<String, Object[]> jar1 = TestData.getEntries(expected);
        Map<String, Object[]> jar2 = TestData.getEntries(actual);
        for (String name : jar1.keySet()) {
            Object[] file1 = jar1.get(name);
            Object[] file2 = jar2.remove(name);
            Assert.assertNotNull((Object)file2);
            ZipEntry entry1 = (ZipEntry)file1[0];
            ZipEntry entry2 = (ZipEntry)file2[0];
            Assert.assertTrue((boolean)entry1.getName().equals(entry2.getName()));
            Assert.assertTrue((entry1.getSize() == entry2.getSize() ? 1 : 0) != 0);
            Assert.assertTrue((entry1.isDirectory() == entry2.isDirectory() ? 1 : 0) != 0);
            Assert.assertTrue((entry1.getCrc() == entry2.getCrc() ? 1 : 0) != 0);
            Assert.assertTrue((entry1.getMethod() == entry2.getMethod() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals((byte[])file1[1], (byte[])file2[1]));
        }
        Assert.assertTrue((jar2.size() == 0 ? 1 : 0) != 0);
    }

    public static void assertContains(Map<String, Object[]> fileMap, ZipInputStream input2, boolean compareContent) throws IOException {
        Map<String, Object[]> jar2 = TestData.getEntries(input2);
        for (String name : fileMap.keySet()) {
            Object[] file1 = fileMap.get(name);
            Object[] file2 = jar2.remove(name);
            Assert.assertNotNull((Object)file2);
            File entry1 = (File)file1[0];
            ZipEntry entry2 = (ZipEntry)file2[0];
            Assert.assertTrue((entry1.isDirectory() == entry2.isDirectory() ? 1 : 0) != 0);
            if (!compareContent) continue;
            Assert.assertTrue((boolean)Arrays.equals((byte[])file1[1], (byte[])file2[1]));
        }
    }

    private static Map<String, Object[]> getEntries(ZipInputStream input) throws IOException {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        ZipEntry entry;
        while ((entry = input.getNextEntry()) != null) {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            FileUtils.copyStream((InputStream)input, (boolean)false, (OutputStream)content, (boolean)true);
            input.closeEntry();
            result.put(entry.getName(), new Object[]{entry, content.toByteArray()});
        }
        return result;
    }
}

