/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.junit.Assert;

public class TestMetadataRepository
extends AbstractMetadataRepository {
    private static final String DESCRIPTION = "A Test Metadata Repository";
    private static final String NAME = "ATestMetadataRepository";
    private static final String PROVIDER = "org.eclipse";
    private static final String TYPE = "testmetadatarepo";
    private static final String VERSION = "1";
    private final List<IInstallableUnit> units = new ArrayList<IInstallableUnit>();
    protected HashSet<IRepositoryReference> repositories = new HashSet();

    private static URI createLocation() {
        try {
            return new URI("http://TestMetadataRepository.com/" + Long.toString(System.currentTimeMillis()));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public TestMetadataRepository(IProvisioningAgent agent, IInstallableUnit ... ius) {
        super(agent, NAME, TYPE, VERSION, TestMetadataRepository.createLocation(), DESCRIPTION, PROVIDER, null);
        this.units.addAll(Arrays.asList(ius));
    }

    public void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        this.units.addAll(installableUnits);
    }

    public IInstallableUnit find(String id, String versionString) {
        Iterator result = this.query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)versionString)), null).iterator();
        return result.hasNext() ? (IInstallableUnit)result.next() : null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == TestMetadataRepository.class || adapter == IMetadataRepository.class || adapter == IRepository.class) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    public IQueryResult query(IQuery query, IProgressMonitor monitor) {
        return query.perform(this.units.iterator());
    }

    public void removeAll() {
        this.units.clear();
    }

    public boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        boolean modified = false;
        for (IInstallableUnit iu : installableUnits) {
            modified |= this.units.remove(iu);
        }
        return modified;
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        this.setName(state.Name);
        this.setType(state.Type);
        this.setVersion(state.Version.toString());
        this.setProvider(state.Provider);
        this.setDescription(state.Description);
        this.setLocation(state.Location);
        this.setProperties(state.Properties);
        this.units.addAll(Arrays.asList(state.Units));
        this.repositories.addAll(Arrays.asList(state.Repositories));
    }

    public synchronized void addReferences(Collection<? extends IRepositoryReference> references) {
        this.assertModifiable();
        this.repositories.addAll(references);
    }

    public Collection<IRepositoryReference> getReferences() {
        return this.repositories;
    }

    protected void assertModifiable() {
    }
}

