/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ant;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractAntProvisioningTest;

public class CompositeRepositoryTaskTest
extends AbstractAntProvisioningTest {
    private static final String ADD_ELEMENT = "add";
    private static final String REMOVE_ELEMENT = "remove";
    private URI compositeSite;
    private URI childSite;
    private URI childSite2;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.compositeSite = new File(this.getTempFolder(), CompositeRepositoryTaskTest.getUniqueString()).toURI();
        this.childSite = CompositeRepositoryTaskTest.getTestData("Loading test data", "testData/testRepos/simple.1").toURI();
        this.childSite2 = new URI("memory:/in/memory");
    }

    @Override
    public void tearDown() throws Exception {
        CompositeRepositoryTaskTest.getArtifactRepositoryManager().removeRepository(this.compositeSite);
        CompositeRepositoryTaskTest.getMetadataRepositoryManager().removeRepository(this.compositeSite);
        CompositeRepositoryTaskTest.getArtifactRepositoryManager().removeRepository(this.childSite);
        CompositeRepositoryTaskTest.getMetadataRepositoryManager().removeRepository(this.childSite);
        CompositeRepositoryTaskTest.getArtifactRepositoryManager().removeRepository(this.childSite2);
        CompositeRepositoryTaskTest.getMetadataRepositoryManager().removeRepository(this.childSite2);
        CompositeRepositoryTaskTest.delete(new File(this.compositeSite));
        super.tearDown();
    }

    public void testAddChildToExistingArtifactRepository() throws Exception {
        this.createCompositeRepository("A");
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement("A");
        this.addTask(modify);
        AbstractAntProvisioningTest.AntTaskElement add = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        add.addElement(this.getRepositoryElement(this.childSite, "A"));
        modify.addElement(add);
        this.runAntTask();
        CompositeArtifactRepository repo = (CompositeArtifactRepository)this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertTrue((String)"Repository does not contain child", (boolean)repo.getChildren().contains(this.childSite));
    }

    public void testCreateNoChidlren() {
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement(TYPE_BOTH);
        this.addTask(modify);
        this.runAntTask();
        if (CompositeRepositoryTaskTest.getArtifactRepositoryManager().contains(this.compositeSite)) {
            CompositeRepositoryTaskTest.getArtifactRepositoryManager().removeRepository(this.compositeSite);
        }
        if (CompositeRepositoryTaskTest.getMetadataRepositoryManager().contains(this.compositeSite)) {
            CompositeRepositoryTaskTest.getMetadataRepositoryManager().removeRepository(this.compositeSite);
        }
        ICompositeRepository artifact = null;
        ICompositeRepository metadata = null;
        try {
            artifact = (ICompositeRepository)CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null);
            metadata = (ICompositeRepository)CompositeRepositoryTaskTest.getMetadataRepositoryManager().loadRepository(this.compositeSite, null);
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to load repositories", e);
        }
        CompositeRepositoryTaskTest.assertTrue((String)"Artifact Repository contains children", (boolean)artifact.getChildren().isEmpty());
        CompositeRepositoryTaskTest.assertTrue((String)"Metadata Repository contains children", (boolean)metadata.getChildren().isEmpty());
    }

    public void testAddChildToExistingMetadataRepository() {
        this.createCompositeRepository("M");
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement("M");
        this.addTask(modify);
        AbstractAntProvisioningTest.AntTaskElement add = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        add.addElement(this.getRepositoryElement(this.childSite, "M"));
        modify.addElement(add);
        this.runAntTask();
        CompositeMetadataRepository repo = (CompositeMetadataRepository)this.getCompositeRepository("M");
        CompositeRepositoryTaskTest.assertTrue((String)"Repository does not contain child", (boolean)repo.getChildren().contains(this.childSite));
    }

    public void testAddChild() throws URISyntaxException {
        this.createCompositeRepository("M");
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement("M");
        this.addTask(modify);
        AbstractAntProvisioningTest.AntTaskElement add = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        add.addAttribute("location", "childSite");
        add.addAttribute("kind", "M");
        modify.addElement(add);
        this.runAntTask();
        CompositeMetadataRepository repo = (CompositeMetadataRepository)this.getCompositeRepository("M");
        URI child = URIUtil.fromString((String)"childSite");
        child = URIUtil.makeAbsolute((URI)child, (URI)repo.getLocation());
        CompositeRepositoryTaskTest.assertTrue((String)"Repository does not contain child", (boolean)repo.getChildren().contains(child));
    }

    public void testAddChildToExistingRepositories() {
        this.createCompositeRepository(null);
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement(null);
        this.addTask(modify);
        modify.addElement(this.createAddElement(null, new URI[]{this.childSite}));
        this.runAntTask();
        CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertTrue((String)"Repository does not contain child", (boolean)artifactRepo.getChildren().contains(this.childSite));
        CompositeMetadataRepository metadataRepo = (CompositeMetadataRepository)this.getCompositeRepository("M");
        CompositeRepositoryTaskTest.assertTrue((String)"Repository does not contain child", (boolean)metadataRepo.getChildren().contains(this.childSite));
    }

    public void testRemoveAllChildren() {
        ICompositeRepository parent = this.createCompositeRepository("A");
        parent.addChild(this.childSite);
        AbstractAntProvisioningTest.AntTaskElement modify = new AbstractAntProvisioningTest.AntTaskElement("p2.composite.repository");
        AbstractAntProvisioningTest.AntTaskElement destination = this.getRepositoryElement(this.compositeSite, "A");
        destination.addAttribute("append", String.valueOf(false));
        modify.addElement(destination);
        this.addTask(modify);
        this.runAntTask();
        CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertTrue((String)"Children not removed", (boolean)artifactRepo.getChildren().isEmpty());
    }

    public void testRemoveChild() {
        ICompositeRepository repo = this.createCompositeRepository("A");
        try {
            CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.childSite, null);
            CompositeRepositoryTaskTest.getArtifactRepositoryManager().createRepository(this.childSite2, "Child site", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
            repo.addChild(this.childSite);
            repo.addChild(this.childSite2);
        }
        catch (ProvisionException provisionException) {
            CompositeRepositoryTaskTest.fail((String)"Failed to create child repositories");
        }
        CompositeRepositoryTaskTest.getArtifactRepositoryManager().removeRepository(this.compositeSite);
        AbstractAntProvisioningTest.AntTaskElement modify = this.createCompositeRepositoryTaskElement("A");
        modify.addElement(this.createRemoveElement("A", new URI[]{this.childSite}));
        this.addTask(modify);
        this.runAntTask();
        repo = this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertFalse((boolean)repo.getChildren().contains(this.childSite));
        CompositeRepositoryTaskTest.assertTrue((boolean)repo.getChildren().contains(this.childSite2));
    }

    public void testCreateCompositeArtifactRepository() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("A");
        this.addTask(createCompositeTask);
        this.runAntTask();
        CompositeRepositoryTaskTest.assertTrue((boolean)CompositeRepositoryTaskTest.getArtifactRepositoryManager().contains(this.compositeSite));
        CompositeRepositoryTaskTest.assertTrue((boolean)(CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null) instanceof CompositeArtifactRepository));
        CompositeRepositoryTaskTest.assertFalse((String)"Metadata repository does not exists", (boolean)CompositeRepositoryTaskTest.getMetadataRepositoryManager().contains(this.compositeSite));
    }

    public void testCreateCompositeMetadataRepository() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("M");
        this.addTask(createCompositeTask);
        this.runAntTask();
        CompositeRepositoryTaskTest.assertTrue((String)"Metadata repository does not exists", (boolean)CompositeRepositoryTaskTest.getMetadataRepositoryManager().contains(this.compositeSite));
        CompositeRepositoryTaskTest.assertTrue((String)"Metadata repository is not a CompositeRepository", (boolean)(CompositeRepositoryTaskTest.getMetadataRepositoryManager().loadRepository(this.compositeSite, null) instanceof CompositeMetadataRepository));
        CompositeRepositoryTaskTest.assertFalse((String)"Artifact repository also exists", (boolean)CompositeRepositoryTaskTest.getArtifactRepositoryManager().contains(this.compositeSite));
    }

    public void testCreateCombinedCompositeRepository() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement(null);
        this.addTask(createCompositeTask);
        this.runAntTask();
        CompositeRepositoryTaskTest.assertTrue((String)"Metadata repository does not exists", (boolean)CompositeRepositoryTaskTest.getMetadataRepositoryManager().contains(this.compositeSite));
        CompositeRepositoryTaskTest.assertTrue((String)"Artifact repository does not exists", (boolean)CompositeRepositoryTaskTest.getArtifactRepositoryManager().contains(this.compositeSite));
        CompositeRepositoryTaskTest.assertTrue((String)"Metadata repository is not a CompositeRepository", (boolean)(CompositeRepositoryTaskTest.getMetadataRepositoryManager().loadRepository(this.compositeSite, null) instanceof CompositeMetadataRepository));
        CompositeRepositoryTaskTest.assertTrue((String)"Artifact repository is not a CompositeRepository", (boolean)(CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null) instanceof CompositeArtifactRepository));
    }

    public void testFailOnExists() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("A");
        this.addTask(createCompositeTask);
        this.runAntTask();
        createCompositeTask.addAttributes(new String[]{"failOnExists", String.valueOf(true)});
        Throwable exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            exception = CompositeRepositoryTaskTest.rootCause(e);
        }
        if (!exception.getMessage().contains("exists")) {
            CompositeRepositoryTaskTest.fail("Unexpected exception: ", exception);
        }
    }

    public void testNotCompressed() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("A");
        this.addTask(createCompositeTask);
        createCompositeTask.elements.get(0).addAttributes(new String[]{"compressed", String.valueOf(false)});
        this.runAntTask();
        ICompositeRepository repo = this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertTrue((boolean)(repo instanceof CompositeArtifactRepository));
        CompositeRepositoryTaskTest.assertFalse((String)"The repository is compressed", (boolean)Boolean.valueOf((String)repo.getProperties().get("p2.compressed")));
    }

    public void testAtomicArtifactRepository() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeArtifactRepositoryTask = new AbstractAntProvisioningTest.AntTaskElement("p2.composite.artifact.repository.create");
        createCompositeArtifactRepositoryTask.addAttributes(new String[]{"atomic", String.valueOf(true)});
        createCompositeArtifactRepositoryTask.addAttributes(new String[]{"location", URIUtil.toUnencodedString((URI)this.compositeSite)});
        this.addTask(createCompositeArtifactRepositoryTask);
        this.runAntTask();
        ICompositeRepository repo = this.getCompositeRepository("A");
        CompositeRepositoryTaskTest.assertTrue((boolean)(repo instanceof CompositeArtifactRepository));
        CompositeRepositoryTaskTest.assertTrue((String)"The repository is not atomic", (boolean)Boolean.valueOf((String)repo.getProperties().get("p2.atomic.composite.loading")));
    }

    public void testAtomicMetadataRepository() throws Exception {
        AbstractAntProvisioningTest.AntTaskElement createCompositeMetadataRepositoryTask = new AbstractAntProvisioningTest.AntTaskElement("p2.composite.metadata.repository.create");
        createCompositeMetadataRepositoryTask.addAttributes(new String[]{"atomic", String.valueOf(true)});
        createCompositeMetadataRepositoryTask.addAttributes(new String[]{"location", URIUtil.toUnencodedString((URI)this.compositeSite)});
        this.addTask(createCompositeMetadataRepositoryTask);
        this.runAntTask();
        ICompositeRepository repo = this.getCompositeRepository("M");
        CompositeRepositoryTaskTest.assertTrue((boolean)(repo instanceof CompositeMetadataRepository));
        CompositeRepositoryTaskTest.assertTrue((String)"The repository is not atomic", (boolean)Boolean.valueOf((String)repo.getProperties().get("p2.atomic.composite.loading")));
    }

    public void testName() {
        String repoName = "My Test Repository";
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("A");
        this.addTask(createCompositeTask);
        createCompositeTask.elements.get(0).addAttributes(new String[]{"name", repoName});
        this.runAntTask();
        try {
            IArtifactRepository repo = CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null);
            CompositeRepositoryTaskTest.assertTrue((boolean)(repo instanceof CompositeArtifactRepository));
            CompositeRepositoryTaskTest.assertEquals((String)repoName, (String)repo.getName());
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to load repository", e);
        }
    }

    public void testAddChildToNewArtifactRepository() {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("A");
        this.addTask(createCompositeTask);
        AbstractAntProvisioningTest.AntTaskElement addElement = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        addElement.addElement(this.getRepositoryElement(this.childSite, "A"));
        createCompositeTask.addElement(addElement);
        this.runAntTask();
        try {
            CompositeArtifactRepository repo = (CompositeArtifactRepository)CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null);
            CompositeRepositoryTaskTest.assertTrue((boolean)repo.getChildren().contains(this.childSite));
            CompositeRepositoryTaskTest.assertEquals((String)"More than one child present", (int)1, (int)repo.getChildren().size());
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to load repository", e);
        }
    }

    public void testAddChildToNewMetadataRepository() {
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = this.createCompositeRepositoryTaskElement("M");
        this.addTask(createCompositeTask);
        AbstractAntProvisioningTest.AntTaskElement addElement = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        addElement.addElement(this.getRepositoryElement(this.childSite, "M"));
        createCompositeTask.addElement(addElement);
        this.runAntTask();
        try {
            ICompositeRepository repo = (ICompositeRepository)CompositeRepositoryTaskTest.getMetadataRepositoryManager().loadRepository(this.compositeSite, null);
            CompositeRepositoryTaskTest.assertTrue((boolean)repo.getChildren().contains(this.childSite));
            CompositeRepositoryTaskTest.assertEquals((String)"More than one child present", (int)1, (int)repo.getChildren().size());
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to load repository", e);
        }
    }

    public void testInvalidLocation() throws Exception {
        URI location = URIUtil.fromString((String)"scheme:/location");
        AbstractAntProvisioningTest.AntTaskElement createCompositeTask = new AbstractAntProvisioningTest.AntTaskElement("p2.composite.repository");
        createCompositeTask.addElement(this.getRepositoryElement(location, "A"));
        this.addTask(createCompositeTask);
        CoreException exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            exception = e;
            try {
                CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(location, null);
                CompositeRepositoryTaskTest.fail((String)"Repository with invalid location loaded.");
            }
            catch (ProvisionException provisionException) {}
        }
        if (exception == null) {
            CompositeRepositoryTaskTest.fail((String)"No exception thrown");
        }
    }

    protected ICompositeRepository getCompositeRepository(String type) {
        try {
            if (type == "A") {
                return (ICompositeRepository)CompositeRepositoryTaskTest.getArtifactRepositoryManager().loadRepository(this.compositeSite, null);
            }
            if (type == "M") {
                return (ICompositeRepository)CompositeRepositoryTaskTest.getMetadataRepositoryManager().loadRepository(this.compositeSite, null);
            }
            CompositeRepositoryTaskTest.fail((String)"No type specified");
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to load repository", e);
        }
        catch (ClassCastException e) {
            CompositeRepositoryTaskTest.fail("Repository is not composite", e);
        }
        return null;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createRemoveElement(String type, URI[] addresses) {
        AbstractAntProvisioningTest.AntTaskElement add = new AbstractAntProvisioningTest.AntTaskElement(REMOVE_ELEMENT);
        int i = 0;
        while (i < addresses.length) {
            add.addElement(this.getRepositoryElement(addresses[i], type));
            ++i;
        }
        return add;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createAddElement(String type, URI[] addresses) {
        AbstractAntProvisioningTest.AntTaskElement add = new AbstractAntProvisioningTest.AntTaskElement(ADD_ELEMENT);
        int i = 0;
        while (i < addresses.length) {
            add.addElement(this.getRepositoryElement(addresses[i], type));
            ++i;
        }
        return add;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createCompositeRepositoryTaskElement(String type) {
        AbstractAntProvisioningTest.AntTaskElement compositeTask = new AbstractAntProvisioningTest.AntTaskElement("p2.composite.repository");
        compositeTask.addElement(this.getRepositoryElement(this.compositeSite, type));
        return compositeTask;
    }

    protected ICompositeRepository createCompositeRepository(String type) {
        ICompositeRepository repo = null;
        try {
            if ("A".equals(type) || type == null) {
                repo = (ICompositeRepository)RepositoryHelper.validDestinationRepository((IRepository)CompositeRepositoryTaskTest.getArtifactRepositoryManager().createRepository(this.compositeSite, "Test Composite Repo", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null));
            }
            if ("M".equals(type) || type == null) {
                repo = (ICompositeRepository)RepositoryHelper.validDestinationRepository((IRepository)CompositeRepositoryTaskTest.getMetadataRepositoryManager().createRepository(this.compositeSite, "Test Composite Repo", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null));
            }
        }
        catch (ProvisionException e) {
            CompositeRepositoryTaskTest.fail("Failed to create composite repository", e);
        }
        catch (IllegalStateException e) {
            CompositeRepositoryTaskTest.fail("failed to create writeable composite repository", e);
        }
        return repo;
    }
}

