/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.comparator.MD5ArtifactComparator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractAntProvisioningTest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.NLS;
import org.junit.Assert;

public class MirrorTaskTest
extends AbstractAntProvisioningTest {
    private static final String MIRROR_TASK = "p2.mirror";
    private static final String MIRROR_ARTIFACTS_TASK = "p2.artifact.mirror";
    private URI destinationRepo;
    private URI artifactRepo;
    private URI sliceArtifactRepo;
    private URI sliceRepo;
    private URI sourceRepo2;
    private URI zipRepo;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.destinationRepo = new File(this.getTestFolder(this.getName()), "destinationRepo").toURI();
        this.artifactRepo = MirrorTaskTest.getTestData("error loading data", "testData/mirror/mirrorPackedRepo").toURI();
        this.sourceRepo2 = MirrorTaskTest.getTestData("error loading data", "testData/mirror/mirrorSourceRepo2").toURI();
        this.sliceRepo = MirrorTaskTest.getTestData("error loading data", "testData/permissiveSlicer").toURI();
        this.sliceArtifactRepo = MirrorTaskTest.getTestData("error loading data", "testData/testRepos/updateSite").toURI();
        this.zipRepo = MirrorTaskTest.getTestData("error loading data", "/testData/mirror/zippedRepo.zip").toURI();
    }

    @Override
    public void tearDown() throws Exception {
        MirrorTaskTest.getArtifactRepositoryManager().removeRepository(this.destinationRepo);
        MirrorTaskTest.getMetadataRepositoryManager().removeRepository(this.destinationRepo);
        MirrorTaskTest.getArtifactRepositoryManager().removeRepository(this.sliceRepo);
        MirrorTaskTest.getMetadataRepositoryManager().removeRepository(this.sliceRepo);
        MirrorTaskTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo2);
        MirrorTaskTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo2);
        MirrorTaskTest.getArtifactRepositoryManager().removeRepository(this.zipRepo);
        MirrorTaskTest.getMetadataRepositoryManager().removeRepository(this.zipRepo);
        MirrorTaskTest.delete(new File(this.destinationRepo).getParentFile());
        super.tearDown();
    }

    public void testMirrorArtifactOnly() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("A");
        mirror.addElement(this.createSourceElement(this.artifactRepo, null));
        this.runAntTask();
        MirrorTaskTest.assertEquals((String)"Different number of Artifact Keys", (int)this.getArtifactKeyCount(this.artifactRepo), (int)this.getArtifactKeyCount(this.destinationRepo));
        MirrorTaskTest.assertEquals((String)"Different number of ArtifactDescriptors", (int)this.getArtifactDescriptorCount(this.artifactRepo), (int)this.getArtifactDescriptorCount(this.destinationRepo));
    }

    public void testMirrorMetadataOnly() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sourceRepo2));
        this.runAntTask();
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)this.getIUCount(this.sourceRepo2), (int)this.getIUCount(this.destinationRepo));
    }

    public void testMirrorEmptyBaseline() throws Exception {
        File folder = this.getTestFolder("MirrorEmptyBaseline");
        String baseline = "file:" + new File(folder, "base").getAbsolutePath();
        String dest = "file:" + new File(folder, "destination").getAbsolutePath();
        String logFile = new File(folder, "log.txt").getAbsolutePath();
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement(this, MIRROR_ARTIFACTS_TASK);
        mirror.addAttribute("source", URIUtil.toUnencodedString((URI)this.sourceRepo2));
        mirror.addAttribute("baseline", baseline);
        mirror.addAttribute("comparatorId", "org.eclipse.equinox.p2.repository.tools.jar.comparator");
        mirror.addAttribute("destination", dest);
        mirror.addAttribute("log", logFile);
        this.addTask(mirror);
        this.runAntTask();
        MirrorTaskTest.assertLogContainsLine(new File(folder, "log.txt"), "No repository found at " + URIUtil.toUnencodedString((URI)URIUtil.fromString((String)baseline)));
    }

    public void testMirrorFromZip() {
        URI localAddress = null;
        try {
            localAddress = URIUtil.fromString((String)new File(this.zipRepo).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            MirrorTaskTest.fail((String)"failed to convert zip repo location");
        }
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(localAddress, localAddress));
        this.runAntTask();
        MirrorTaskTest.assertEquals((String)"Wrong number of ArtifactKeys", (int)this.getArtifactKeyCount(URIUtil.toJarURI((URI)this.zipRepo, null)), (int)this.getArtifactKeyCount(this.destinationRepo));
        MirrorTaskTest.assertEquals((String)"Wrong number of ArtifactDescriptors", (int)this.getArtifactDescriptorCount(URIUtil.toJarURI((URI)this.zipRepo, null)), (int)this.getArtifactDescriptorCount(this.destinationRepo));
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)this.getIUCount(this.sourceRepo2), (int)this.getIUCount(this.destinationRepo));
    }

    public void testMirrorAllIUSpecified() throws ProvisionException {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sourceRepo2, this.sourceRepo2));
        this.addAllIUs(mirror, MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2, null));
        this.runAntTask();
        MirrorTaskTest.assertEquals((String)"Different number of Artifact Keys", (int)this.getArtifactKeyCount(this.sourceRepo2), (int)this.getArtifactKeyCount(this.destinationRepo));
        MirrorTaskTest.assertContentEquals("IUs differ", MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2, null), MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)this.getIUCount(this.sourceRepo2), (int)this.getIUCount(this.destinationRepo));
        MirrorTaskTest.assertContentEquals("Artifacts differ", MirrorTaskTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2, null), MirrorTaskTest.getArtifactRepositoryManager().loadRepository(this.destinationRepo, null));
    }

    public void testMirrorSomeIUSpecified() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sourceRepo2, this.sourceRepo2));
        mirror.addElement(this.createIUElement("anotherplugin", "1.0.0"));
        this.runAntTask();
        MirrorTaskTest.assertEquals((String)"Wrong number of ArtifactKeys", (int)1, (int)this.getArtifactKeyCount(this.destinationRepo));
        MirrorTaskTest.assertEquals((String)"Wrong number of IUs", (int)1, (int)this.getIUCount(this.destinationRepo));
    }

    public void testMirrorMissingIU() {
        String id = "My_Missing_IU";
        String version = "1.0.0";
        String iu = "Installable Unit [ id=" + id + " version=" + version + " ]";
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sourceRepo2, this.sourceRepo2));
        mirror.addElement(this.createIUElement(id, version));
        CoreException exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            exception = e;
        }
        if (exception == null) {
            MirrorTaskTest.fail((String)"No Exception was thrown");
        }
        MirrorTaskTest.assertEquals((String)"Unexpected message", (String)NLS.bind((String)Messages.AbstractRepositoryTask_unableToFind, (Object)iu), (String)MirrorTaskTest.rootCause(exception).getMessage());
    }

    public void testMirrorMetadataDestinationWithoutSource() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sourceRepo2, null));
        CoreException exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            exception = e;
        }
        if (exception == null) {
            MirrorTaskTest.fail((String)"No exception thrown");
        }
        if (!(MirrorTaskTest.rootCause(exception) instanceof ProvisionException) || !MirrorTaskTest.rootCause(exception).getMessage().equals(Messages.MirrorApplication_metadataDestinationNoSource)) {
            MirrorTaskTest.fail("Exception is of an unexpected type or message", MirrorTaskTest.rootCause(exception));
        }
    }

    public void testMirrorArtifactDestinationWithoutSource() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(null, this.sourceRepo2));
        CoreException exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (CoreException e) {
            exception = e;
        }
        if (exception == null) {
            MirrorTaskTest.fail((String)"No exception thrown");
        }
        if (!(MirrorTaskTest.rootCause(exception) instanceof ProvisionException) && MirrorTaskTest.rootCause(exception).getMessage().contains(Messages.MirrorApplication_artifactDestinationNoSource)) {
            MirrorTaskTest.fail("Exception is of an unexpected type or message", MirrorTaskTest.rootCause(exception));
        }
    }

    public void testMirrorNoIUSpecified() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sourceRepo2, this.sourceRepo2));
        this.runAntTask();
        try {
            MirrorTaskTest.assertEquals((String)"Different number of Artifact Keys", (int)this.getArtifactKeyCount(this.sourceRepo2), (int)this.getArtifactKeyCount(this.destinationRepo));
            MirrorTaskTest.assertContentEquals("Artifacts differ", MirrorTaskTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2, null), MirrorTaskTest.getArtifactRepositoryManager().loadRepository(this.destinationRepo, null));
            MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)this.getIUCount(this.sourceRepo2), (int)this.getIUCount(this.destinationRepo));
            MirrorTaskTest.assertContentEquals("IUs differ", MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2, null), MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare results", e);
        }
    }

    public void testMirrorWithInvalidDestination() throws URISyntaxException {
        URI location = new URI("invalid:/scheme");
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement(this, MIRROR_TASK);
        mirror.addElement(this.getRepositoryElement(location, TYPE_BOTH));
        mirror.addElement(this.createSourceElement(this.sourceRepo2, this.sourceRepo2));
        this.addTask(mirror);
        Throwable exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception == null) {
            MirrorTaskTest.fail((String)"No Exception thrown");
        }
        while (exception.getCause() != null && !(exception instanceof ProvisionException)) {
            exception = exception.getCause();
        }
        MirrorTaskTest.assertTrue((String)"Unexpected error", (boolean)NLS.bind((String)Messages.exception_invalidDestination, (Object)location).equals(exception.getMessage()));
    }

    public void testMirrorWithNoRepositoryAtSource() {
        URI location = this.getTempFolder().toURI();
        try {
            AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
            mirror.addElement(this.createSourceElement(location, location));
            this.addTask(mirror);
            Throwable exception = null;
            try {
                this.runAntTaskWithExceptions();
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) {
                MirrorTaskTest.fail((String)"No Exception thrown");
            }
            while (exception.getCause() != null && !(exception instanceof ProvisionException)) {
                exception = exception.getCause();
            }
            MirrorTaskTest.assertTrue((String)"Unexpected error", (boolean)NLS.bind((String)"No repository found at {0}.", (Object)location).equals(exception.getMessage()));
        }
        finally {
            MirrorTaskTest.delete(new File(location));
        }
    }

    public void testMirrorWithInvalidSource() throws URISyntaxException {
        URI location = new URI("unknown:/scheme2");
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(location, location));
        this.addTask(mirror);
        Throwable exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception == null) {
            MirrorTaskTest.fail((String)"No Exception thrown");
        }
        while (exception.getCause() != null && !(exception instanceof ProvisionException)) {
            exception = exception.getCause();
        }
        MirrorTaskTest.assertTrue((String)"Expecting a CoreException", (boolean)(exception instanceof CoreException));
        MirrorTaskTest.assertEquals((String)"Unexpected error code.", (int)1000, (int)((CoreException)exception).getStatus().getCode());
    }

    public void testSlicingFollowStrict() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, null, true, null, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        p.put("org.eclipse.update.install.features", String.valueOf(true));
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, true, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingIncludeNonGreedy() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, false, null, null, null, null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, Collections.emptyMap(), true, false, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingIncludeOptionalDependencies() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(false, null, null, null, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        p.put("org.eclipse.update.install.features", String.valueOf(true));
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, false, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingFilter() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, null, "win32,win32,x86", "org.eclipse.update.install.features=false"));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingPlatformFilter() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, null, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        p.put("org.eclipse.update.install.features", String.valueOf(true));
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingIncludeFeaturesFalse() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, false, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        try {
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testSlicingMetadataAndArtifactsMirrored() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceArtifactRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"test.feature.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
        mirror.addElement(this.createSourceElement(this.sliceArtifactRepo, this.sliceArtifactRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, false, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of IUs", (int)MirrorTaskTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getIUCount(this.destinationRepo));
        MirrorTaskTest.assertEquals((String)"Different number of ArtifactKeys", (int)this.getArtifactKeyCount((IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getArtifactKeyCount(this.destinationRepo));
        try {
            this.assertArtifactKeyContentEquals("Different ArtifactKeys", (IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()), this.destinationRepo);
            MirrorTaskTest.assertIUContentEquals("IUs differ", result, (IQueryable)MirrorTaskTest.getMetadataRepositoryManager().loadRepository(this.destinationRepo, null));
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Failed to compare contents", e);
        }
    }

    public void testMirrorSlicedIUtoArtifact() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceArtifactRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"test.feature.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("A");
        mirror.addElement(this.createSourceElement(this.sliceArtifactRepo, this.sliceArtifactRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, false, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of ArtifactKeys", (int)this.getArtifactKeyCount((IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getArtifactKeyCount(this.destinationRepo));
        this.assertArtifactKeyContentEquals("Different ArtifactKeys", (IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()), this.destinationRepo);
    }

    public void testMirrorSlicedMultipleIUsToArtifact() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceArtifactRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"test.feature.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        c = repo.query(QueryUtil.createIUQuery((String)"RCP_Browser_Example.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu2 = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("A");
        mirror.addElement(this.createSourceElement(this.sliceArtifactRepo, this.sliceArtifactRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, false, "win32,win32,x86", null));
        mirror.addElement(this.createIUElement(iu));
        mirror.addElement(this.createIUElement(iu2));
        this.runAntTask();
        Map<String, String> p = this.getSliceProperties();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repo, p, true, true, true, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu, iu2}, (IProgressMonitor)new NullProgressMonitor());
        MirrorTaskTest.assertEquals((String)"Different number of ArtifactKeys", (int)this.getArtifactKeyCount((IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())), (int)this.getArtifactKeyCount(this.destinationRepo));
        this.assertArtifactKeyContentEquals("Different ArtifactKeys", (IQueryResult<IInstallableUnit>)result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()), this.destinationRepo);
    }

    public void testMirrorCompareWithIgnore() throws Exception {
        ZipEntry entry;
        ZipOutputStream stream;
        Object var10_13;
        Throwable throwable;
        File testFolder = this.getTestFolder("mirrorWithIgnore");
        File base = new File(testFolder, "base");
        File source = new File(testFolder, "source");
        File dest = new File(testFolder, "destination");
        Properties props = new Properties();
        props.put("key", "value");
        ArtifactKey key = new ArtifactKey("osgi.bundle", "a", Version.parseVersion((String)"1.0.0"));
        IArtifactRepository[] repos = new IArtifactRepository[]{this.createArtifactRepository(base.toURI(), null), this.createArtifactRepository(source.toURI(), null)};
        int i = 0;
        while (i < 2) {
            throwable = null;
            var10_13 = null;
            try {
                stream = new ZipOutputStream(repos[i].getOutputStream(repos[i].createArtifactDescriptor((IArtifactKey)key)));
                try {
                    entry = new ZipEntry("file.properties");
                    stream.putNextEntry(entry);
                    props.store(stream, String.valueOf(i));
                    stream.closeEntry();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
        key = new ArtifactKey("osgi.bundle", "b", Version.parseVersion((String)"1.0.0"));
        i = 0;
        while (i < 2) {
            throwable = null;
            var10_13 = null;
            try {
                stream = new ZipOutputStream(repos[i].getOutputStream(repos[i].createArtifactDescriptor((IArtifactKey)key)));
                try {
                    entry = new ZipEntry("file.properties");
                    stream.putNextEntry(entry);
                    props.put("boo", String.valueOf(i));
                    props.store(stream, String.valueOf(i));
                    stream.closeEntry();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ++i;
        }
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("A");
        mirror.addElement(new AbstractAntProvisioningTest.AntTaskElement(this, "source", new String[]{"location", URIUtil.toUnencodedString((URI)source.toURI()), "kind", "artifact"}));
        mirror.addElement(new AbstractAntProvisioningTest.AntTaskElement(this, "destination", new String[]{"location", URIUtil.toUnencodedString((URI)dest.toURI()), "kind", "artifact"}));
        AbstractAntProvisioningTest.AntTaskElement comparator = new AbstractAntProvisioningTest.AntTaskElement(this, "comparator");
        comparator.addAttribute("comparator", "org.eclipse.equinox.p2.repository.tools.jar.comparator");
        comparator.addAttribute("comparatorLog", new File(testFolder, "log.txt").getAbsolutePath());
        comparator.addElement(new AbstractAntProvisioningTest.AntTaskElement(this, "repository", new String[]{"location", URIUtil.toUnencodedString((URI)base.toURI())}));
        AbstractAntProvisioningTest.AntTaskElement exclude = new AbstractAntProvisioningTest.AntTaskElement(this, "exclude");
        exclude.addElement(new AbstractAntProvisioningTest.AntTaskElement(this, "artifact", new String[]{"id", "b"}));
        comparator.addElement(exclude);
        mirror.addElement(comparator);
        this.runAntTask();
    }

    public void testMirrorIUtoArtifact() {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.sliceArtifactRepo);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Loading repository failed", e);
        }
        IQueryResult c = repo.query(QueryUtil.createIUQuery((String)"org.eclipse.ui.examples.readmetool"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("A");
        mirror.addElement(this.createSourceElement(this.sliceArtifactRepo, this.sliceArtifactRepo));
        mirror.addElement(this.createIUElement(iu));
        this.runAntTask();
        Collector collector = new Collector();
        collector.accept((Object)iu);
        MirrorTaskTest.assertEquals((String)"Different number of ArtifactKeys", (int)this.getArtifactKeyCount((IQueryResult<IInstallableUnit>)collector), (int)this.getArtifactKeyCount(this.destinationRepo));
        this.assertArtifactKeyContentEquals("Different ArtifactKeys", (IQueryResult<IInstallableUnit>)collector, this.destinationRepo);
    }

    public void testSlicingInvalid() {
        AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask("M");
        mirror.addElement(this.createSourceElement(null, this.sliceRepo));
        mirror.addElement(this.createSlicingOption(null, null, null, null, "win32,win32,x86", null));
        Exception exception = null;
        try {
            this.runAntTaskWithExceptions();
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception == null || !(MirrorTaskTest.rootCause(exception) instanceof ProvisionException)) {
            MirrorTaskTest.fail("Unexpected exception type", exception);
        }
    }

    public void testMirrorPackedRepo() {
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement(this, MIRROR_ARTIFACTS_TASK);
        mirror.addAttribute("destination", URIUtil.toUnencodedString((URI)this.destinationRepo));
        mirror.addAttribute("source", URIUtil.toUnencodedString((URI)this.artifactRepo));
        this.addTask(mirror);
        this.runAntTask();
        File repo = new File(this.destinationRepo);
        MirrorTaskTest.assertTrue((boolean)new File(repo, "plugins/org.eclipse.core.filebuffers_3.4.0.v20080603-2000.jar.pack.gz").exists());
        MirrorTaskTest.assertTrue((boolean)new File(repo, "plugins/org.eclipse.osgi.services.source_3.1.200.v20071203.jar.pack.gz").exists());
    }

    public void testBaselineCompareUsingMD5Comparator() {
        IArtifactRepository baseline;
        IArtifactRepository repo;
        IArtifactDescriptor descriptor2;
        IArtifactDescriptor descriptor1;
        block11: {
            ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
            File artifact1 = MirrorTaskTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/content.xml");
            File artifact2 = MirrorTaskTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/content.xml");
            File repoLocation = this.getTestFolder(MirrorTaskTest.getUniqueString());
            File baselineLocation = this.getTestFolder(MirrorTaskTest.getUniqueString());
            File baselineBinaryDirectory = new File(baselineLocation, "binary");
            baselineBinaryDirectory.mkdir();
            File baselineContentLocation = new File(baselineBinaryDirectory, "testKeyId_1.2.3");
            AbstractProvisioningTest.copy("Copying File to baseline", artifact2, baselineContentLocation);
            descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
            descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)baselineContentLocation);
            MirrorTaskTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
            Assert.assertNotEquals((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
            repo = null;
            baseline = null;
            try {
                repo = this.createRepositoryWithIU(repoLocation.toURI(), descriptor1);
                baseline = this.createRepositoryWithIU(baselineLocation.toURI(), descriptor2);
            }
            catch (ProvisionException e) {
                MirrorTaskTest.fail("Error creating repositories", e);
            }
            PrintStream oldErr = System.err;
            PrintStream newErr = null;
            PrintStream oldOut = System.out;
            PrintStream newOut = null;
            try {
                new File(this.destinationRepo).mkdir();
                newErr = new PrintStream(new FileOutputStream(new File(new File(this.destinationRepo), "sys.err")));
                newOut = new PrintStream(new FileOutputStream(new File(new File(this.destinationRepo), "sys.out")));
            }
            catch (FileNotFoundException e) {
                MirrorTaskTest.fail("Error redirecting outputs", e);
            }
            try {
                try {
                    System.setErr(newErr);
                    System.setOut(newOut);
                    AbstractAntProvisioningTest.AntTaskElement mirror = this.createMirrorTask(TYPE_BOTH);
                    mirror.addElement(this.createSourceElement(repoLocation.toURI(), repoLocation.toURI()));
                    mirror.addAttribute("verbose", String.valueOf(true));
                    AbstractAntProvisioningTest.AntTaskElement comparator = new AbstractAntProvisioningTest.AntTaskElement(this, "comparator");
                    comparator.addAttribute("comparator", MD5ArtifactComparator.MD5_COMPARATOR_ID);
                    comparator.addElement(this.getRepositoryElement(baselineLocation.toURI(), null));
                    mirror.addElement(comparator);
                    this.runAntTaskWithExceptions();
                }
                catch (Exception e) {
                    MirrorTaskTest.fail("Running mirror application with baseline compare", MirrorTaskTest.rootCause(e));
                    System.setErr(oldErr);
                    newErr.close();
                    System.setOut(oldOut);
                    newOut.close();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                System.setErr(oldErr);
                newErr.close();
                System.setOut(oldOut);
                newOut.close();
                throw throwable;
            }
            System.setErr(oldErr);
            newErr.close();
            System.setOut(oldOut);
            newOut.close();
        }
        IArtifactRepository destination = null;
        try {
            destination = MirrorTaskTest.getArtifactRepositoryManager().loadRepository(this.destinationRepo, null);
        }
        catch (ProvisionException e) {
            MirrorTaskTest.fail("Error loading destination", e);
        }
        IArtifactDescriptor[] destDescriptors = destination.getArtifactDescriptors(descriptor2.getArtifactKey());
        MirrorTaskTest.assertEquals((String)"Ensuring destination has correct number of descriptors", (int)1, (int)destDescriptors.length);
        MirrorTaskTest.assertEquals((String)"Ensuring destination contains the descriptor from the baseline", (String)descriptor2.getProperty("download.md5"), (String)destDescriptors[0].getProperty("download.md5"));
        String msg = NLS.bind((String)Messages.warning_differentMD5, (Object[])new Object[]{URIUtil.toUnencodedString((URI)baseline.getLocation()), URIUtil.toUnencodedString((URI)repo.getLocation()), descriptor1});
        this.assertLogContains(msg);
    }

    private Map<String, String> getSliceProperties() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("osgi.os", "win32");
        p.put("osgi.ws", "win32");
        p.put("osgi.arch", "x86");
        return p;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createSlicingOption(Boolean includeOptional, Boolean includeNonGreedy, Boolean followStrict, Boolean includeFeatures, String platformFilter, String filter) {
        AbstractAntProvisioningTest.AntTaskElement slicing = new AbstractAntProvisioningTest.AntTaskElement(this, "slicingoptions");
        if (followStrict != null) {
            slicing.addAttribute("followstrict", followStrict.toString());
        }
        if (includeFeatures != null) {
            slicing.addAttribute("includefeatures", includeFeatures.toString());
        }
        if (includeNonGreedy != null) {
            slicing.addAttribute("includenongreedy", includeNonGreedy.toString());
        }
        if (includeOptional != null) {
            slicing.addAttribute("includeoptional", includeOptional.toString());
        }
        if (platformFilter != null) {
            slicing.addAttribute("platformfilter", platformFilter);
        }
        if (filter != null) {
            slicing.addAttribute("filter", filter);
        }
        return slicing;
    }

    protected IArtifactRepository createRepositoryWithIU(URI repoLocation, IArtifactDescriptor descriptor) throws ProvisionException {
        IArtifactRepository artifactRepository = MirrorTaskTest.getArtifactRepositoryManager().createRepository(repoLocation, "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        artifactRepository.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        IMetadataRepository metaRepo = MirrorTaskTest.getMetadataRepositoryManager().createRepository(repoLocation, "Repo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        InstallableUnit iu = new InstallableUnit();
        iu.setId(String.valueOf(descriptor.getArtifactKey().getId()) + "IU");
        iu.setVersion(descriptor.getArtifactKey().getVersion());
        iu.setArtifacts(new IArtifactKey[]{descriptor.getArtifactKey()});
        metaRepo.addInstallableUnits(Arrays.asList(iu));
        return artifactRepository;
    }

    protected int getArtifactKeyCount(IQueryResult<IInstallableUnit> ius) {
        int count = 0;
        Iterator iter = ius.iterator();
        while (iter.hasNext()) {
            count += ((IInstallableUnit)iter.next()).getArtifacts().size();
        }
        return count;
    }

    protected int getIUCount(URI location) {
        try {
            return MirrorTaskTest.queryResultSize(MirrorTaskTest.getMetadataRepositoryManager().loadRepository(location, null).query(QueryUtil.createIUAnyQuery(), null));
        }
        catch (ProvisionException provisionException) {
            MirrorTaskTest.fail((String)("Failed to load repository " + URIUtil.toUnencodedString((URI)location) + " for ArtifactDescriptor count"));
            return -1;
        }
    }

    protected void addAllIUs(AbstractAntProvisioningTest.AntTaskElement parent, IMetadataRepository repo) {
        IQueryResult queryResult = repo.query(QueryUtil.createIUAnyQuery(), null);
        for (IInstallableUnit iu : queryResult) {
            parent.addElement(this.createIUElement(iu));
        }
    }

    protected AbstractAntProvisioningTest.AntTaskElement createMirrorTask(String type) {
        AbstractAntProvisioningTest.AntTaskElement mirror = new AbstractAntProvisioningTest.AntTaskElement(this, MIRROR_TASK);
        mirror.addElement(this.getRepositoryElement(this.destinationRepo, type));
        this.addTask(mirror);
        return mirror;
    }

    protected AbstractAntProvisioningTest.AntTaskElement createSourceElement(URI artifact, URI metadata) {
        AbstractAntProvisioningTest.AntTaskElement source = new AbstractAntProvisioningTest.AntTaskElement(this, "source");
        if (artifact != null) {
            source.addElement(this.getRepositoryElement(artifact, "A"));
        }
        if (metadata != null) {
            source.addElement(this.getRepositoryElement(metadata, "M"));
        }
        return source;
    }
}

