/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.processors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChecksumVerifierTest {
    @Parameterized.Parameter(value=0)
    public String digestAlgorithm;
    @Parameterized.Parameter(value=1)
    public String algorithmId;
    @Parameterized.Parameter(value=2)
    public String downloadProperty;
    @Parameterized.Parameter(value=3)
    public String artifactProperty;
    @Parameterized.Parameter(value=4)
    public String checksum;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({"MD5", "md5", "download.checksum".concat(".md5"), "artifact.checksum".concat(".md5"), "123456789_123456789_123456789_12"}, {"SHA-256", "sha-256", "download.checksum".concat(".sha-256"), "artifact.checksum".concat(".sha-256"), "123456789_123456789_123456789_123456789_123456789_123456789_1234"});
    }

    @Test
    public void testInitialize() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)EasyMock.createMock(IProcessingStepDescriptor.class);
        EasyMock.expect((Object)processingStepDescriptor.getData()).andReturn((Object)this.checksum);
        EasyMock.expect((Object)processingStepDescriptor.isRequired()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{processingStepDescriptor});
        ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.algorithmId, this.checksum);
        verifier.initialize(null, processingStepDescriptor, null);
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        verifier.close();
        EasyMock.verify((Object[])new Object[]{processingStepDescriptor});
    }

    @Test
    public void testInitialize_DownloadChecksum() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)EasyMock.createMock(IProcessingStepDescriptor.class);
        EasyMock.expect((Object)processingStepDescriptor.getData()).andReturn((Object)this.downloadProperty);
        EasyMock.expect((Object)processingStepDescriptor.isRequired()).andReturn((Object)true);
        IArtifactDescriptor artifactDescriptor = (IArtifactDescriptor)EasyMock.createMock(IArtifactDescriptor.class);
        EasyMock.replay((Object[])new Object[]{processingStepDescriptor});
        EasyMock.expect((Object)artifactDescriptor.getProperty((String)EasyMock.eq((Object)this.downloadProperty))).andReturn((Object)this.checksum);
        EasyMock.expect((Object)artifactDescriptor.getProperty((String)EasyMock.not((Object)((String)EasyMock.eq((Object)this.downloadProperty))))).andReturn(null).times(1, 2);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.downloadProperty, this.checksum);
        EasyMock.expect((Object)artifactDescriptor.getProperties()).andReturn(properties);
        EasyMock.replay((Object[])new Object[]{artifactDescriptor});
        ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.algorithmId, this.checksum);
        verifier.initialize(null, processingStepDescriptor, artifactDescriptor);
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        verifier.close();
        EasyMock.verify((Object[])new Object[]{processingStepDescriptor});
    }

    @Test
    public void testInitialize_ArtifactChecksum() throws IOException, IllegalArgumentException, SecurityException {
        IProcessingStepDescriptor processingStepDescriptor = (IProcessingStepDescriptor)EasyMock.createMock(IProcessingStepDescriptor.class);
        EasyMock.expect((Object)processingStepDescriptor.getData()).andReturn((Object)this.artifactProperty);
        EasyMock.expect((Object)processingStepDescriptor.isRequired()).andReturn((Object)true);
        IArtifactDescriptor artifactDescriptor = (IArtifactDescriptor)EasyMock.createMock(IArtifactDescriptor.class);
        EasyMock.replay((Object[])new Object[]{processingStepDescriptor});
        EasyMock.expect((Object)artifactDescriptor.getProperty((String)EasyMock.eq((Object)this.artifactProperty))).andReturn((Object)this.checksum);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(this.artifactProperty, this.checksum);
        EasyMock.expect((Object)artifactDescriptor.getProperties()).andReturn(properties);
        EasyMock.expect((Object)artifactDescriptor.getProperty((String)EasyMock.not((Object)((String)EasyMock.eq((Object)this.artifactProperty))))).andReturn(null).times(1, 2);
        EasyMock.replay((Object[])new Object[]{artifactDescriptor});
        ChecksumVerifier verifier = new ChecksumVerifier(this.digestAlgorithm, this.algorithmId, this.checksum);
        verifier.initialize(null, processingStepDescriptor, artifactDescriptor);
        Assert.assertEquals((Object)Status.OK_STATUS, (Object)verifier.getStatus());
        verifier.close();
        EasyMock.verify((Object[])new Object[]{processingStepDescriptor});
    }
}

