/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug351944
extends AbstractProvisioningTest {
    File artifactRepoFile = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File testData = Bug351944.getTestData("artifact repository", "testData/bug351944");
        this.artifactRepoFile = this.getTempFolder();
        Bug351944.copy("Copy to temporary folder", testData, this.artifactRepoFile);
        this.changeWritePermission(this.artifactRepoFile, false);
    }

    private void changeWritePermission(File target, boolean canWrite) {
        if (target.exists()) {
            target.setWritable(canWrite);
            if (target.isDirectory()) {
                File[] fileArray = target.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    child.setWritable(canWrite);
                    ++n2;
                }
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.changeWritePermission(this.artifactRepoFile, true);
        Bug351944.delete(this.artifactRepoFile);
    }

    public void testSimpleRepositoryPerformanceOnLoadReadonlyLocalRepository() throws ProvisionException {
        if (!"win32".equals(Platform.getOS())) {
            URI testRepo = this.artifactRepoFile.toURI();
            IArtifactRepositoryManager artifactRepositoryManager = Bug351944.getArtifactRepositoryManager();
            IArtifactRepository repo = artifactRepositoryManager.loadRepository(testRepo, (IProgressMonitor)new NullProgressMonitor());
            IQueryResult allArtifactKeys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, (IProgressMonitor)new NullProgressMonitor());
            Set keySet = allArtifactKeys.toUnmodifiableSet();
            ArrayList<IArtifactRequest> requests = new ArrayList<IArtifactRequest>();
            for (IArtifactKey key : keySet) {
                requests.add(artifactRepositoryManager.createMirrorRequest(key, repo, null, null));
            }
            long start = System.currentTimeMillis();
            IArtifactRequest[] toBeRequests = this.getRequestsForRepository(repo, requests.toArray(new IArtifactRequest[requests.size()]));
            long end = System.currentTimeMillis();
            long queryArtifactOneByOne = end - start;
            start = System.currentTimeMillis();
            IArtifactRequest[] toBeRequests2 = this.getRequestsForRepository2(repo, requests.toArray(new IArtifactRequest[requests.size()]));
            end = System.currentTimeMillis();
            long queryAllArtifacts = end - start;
            Bug351944.assertEquals((String)"Test case has problem, not find same requests.", (int)toBeRequests.length, (int)toBeRequests2.length);
            Bug351944.assertEquals((String)"Querying artifact key from simple repository has performance issue.", (float)queryAllArtifacts, (float)queryArtifactOneByOne, (float)10.0f);
        }
    }

    private IArtifactRequest[] getRequestsForRepository(IArtifactRepository repository, IArtifactRequest[] requestsToProcess) {
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        IArtifactRequest[] iArtifactRequestArray = requestsToProcess;
        int n = requestsToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRequest request = iArtifactRequestArray[n2];
            if (repository.contains(request.getArtifactKey())) {
                applicable.add(request);
            }
            ++n2;
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }

    private IArtifactRequest[] getRequestsForRepository2(IArtifactRepository repository, IArtifactRequest[] requestsToProcess) {
        Set keys = repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, (IProgressMonitor)new NullProgressMonitor()).toSet();
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        IArtifactRequest[] iArtifactRequestArray = requestsToProcess;
        int n = requestsToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactRequest request = iArtifactRequestArray[n2];
            if (keys.contains(request.getArtifactKey())) {
                applicable.add(request);
            }
            ++n2;
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }
}

