/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.BundleContext;

public class JarURLArtifactRepositoryTest
extends TestCase {
    private IArtifactRepositoryManager manager;

    public JarURLArtifactRepositoryTest(String name) {
        super(name);
    }

    public JarURLArtifactRepositoryTest() {
        super("");
    }

    protected void setUp() throws Exception {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgent.class);
        this.manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    protected void tearDown() throws Exception {
        this.manager = null;
    }

    public void testJarURLRepository() throws ProvisionException {
        URL engineJar = TestActivator.getContext().getBundle().getEntry("/testData/enginerepo.jar");
        URI jarRepoLocation = null;
        try {
            jarRepoLocation = URIUtil.toURI((URL)new URL("jar:" + engineJar.toString() + "!/testData/enginerepo/"));
        }
        catch (URISyntaxException e) {
            JarURLArtifactRepositoryTest.fail((String)e.getMessage());
        }
        catch (MalformedURLException e) {
            JarURLArtifactRepositoryTest.fail((String)e.getMessage());
        }
        IArtifactRepository repo = this.manager.loadRepository(jarRepoLocation, null);
        JarURLArtifactRepositoryTest.assertTrue((boolean)repo.contains((IArtifactKey)new ArtifactKey("osgi.bundle", "testdata", Version.create((String)"1.0.0.1"))));
    }
}

