/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MD5Tests
extends AbstractProvisioningTest {
    File testRepo = null;
    IArtifactRepository repo = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testRepo = MD5Tests.getTestData("Repository with MD5", "testData/artifactRepo/simpleWithMD5");
        this.repo = MD5Tests.getArtifactRepositoryManager().loadRepository(this.testRepo.toURI(), (IProgressMonitor)new NullProgressMonitor());
        MD5Tests.assertNotNull((String)"1.0", (Object)this.repo);
    }

    public void DISABLE_testCheckMD5() {
        IQueryResult descriptors = this.repo.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
        for (IArtifactDescriptor desc : descriptors) {
            IStatus status = this.repo.getArtifact(desc, (OutputStream)new ByteArrayOutputStream(500), (IProgressMonitor)new NullProgressMonitor());
            if (desc.getArtifactKey().getId().startsWith("bogus")) {
                MD5Tests.assertNotOK(status);
                continue;
            }
            MD5Tests.assertOK("2.1 " + desc, status);
        }
    }

    public void testBug249035_ArtifactIdentity() {
        ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "aaPlugin", Version.create((String)"1.0.0")));
        descriptor.setProperty("download.md5", "42");
        try {
            this.repo.getOutputStream((IArtifactDescriptor)descriptor);
            MD5Tests.fail((String)"3.1 - Expected Artifact exists exception did not occur.");
        }
        catch (ProvisionException e) {
            MD5Tests.assertTrue((String)"3.2", (boolean)e.getMessage().contains("The artifact is already available in the repository"));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        MD5Tests.getArtifactRepositoryManager().removeRepository(this.testRepo.toURI());
        super.tearDown();
    }
}

