/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class SimpleArtifactRepositoryTest
extends AbstractProvisioningTest {
    private File repositoryFile = null;
    private URI repositoryURI = null;

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.repositoryURI != null) {
            SimpleArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(this.repositoryURI);
            this.repositoryURI = null;
        }
        if (this.repositoryFile != null) {
            SimpleArtifactRepositoryTest.delete(this.repositoryFile);
            this.repositoryFile = null;
        }
    }

    public void testGetActualLocation1() throws Exception {
        URI base = new URI("http://localhost/artifactRepository");
        SimpleArtifactRepositoryTest.assertEquals((Object)new URI(base + "/artifacts.xml"), (Object)SimpleArtifactRepository.getActualLocation((URI)base, (boolean)false));
    }

    public void testGetActualLocation2() throws Exception {
        URI base = new URI("http://localhost/artifactRepository/");
        SimpleArtifactRepositoryTest.assertEquals((Object)new URI(base + "artifacts.xml"), (Object)SimpleArtifactRepository.getActualLocation((URI)base, (boolean)false));
    }

    public void testGetActualLocationCompressed1() throws Exception {
        URI base = new URI("http://localhost/artifactRepository");
        SimpleArtifactRepositoryTest.assertEquals((Object)new URI(base + "/artifacts.jar"), (Object)SimpleArtifactRepository.getActualLocation((URI)base, (boolean)true));
    }

    public void testGetActualLocationCompressed2() throws Exception {
        URI base = new URI("http://localhost/artifactRepository/");
        SimpleArtifactRepositoryTest.assertEquals((Object)new URI(base + "artifacts.jar"), (Object)SimpleArtifactRepository.getActualLocation((URI)base, (boolean)true));
    }

    public void testCompressedRepository() throws ProvisionException {
        IArtifactRepositoryManager artifactRepositoryManager = SimpleArtifactRepositoryTest.getArtifactRepositoryManager();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repositoryFile = new File(tempDir, "SimpleArtifactRepositoryTest");
        SimpleArtifactRepositoryTest.delete(this.repositoryFile);
        this.repositoryURI = this.repositoryFile.toURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IArtifactRepository repo = artifactRepositoryManager.createRepository(this.repositoryURI, "artifact name", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        repo.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        File[] files = this.repositoryFile.listFiles();
        boolean jarFilePresent = false;
        boolean artifactFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("artifacts.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            if ("artifacts.xml".equalsIgnoreCase(files[i].getName())) {
                artifactFilePresent = false;
            }
            ++i;
        }
        SimpleArtifactRepositoryTest.delete(this.repositoryFile);
        if (!jarFilePresent) {
            SimpleArtifactRepositoryTest.fail((String)"Repository should create JAR for artifact.xml");
        }
        if (artifactFilePresent) {
            SimpleArtifactRepositoryTest.fail((String)"Repository should not create artifact.xml");
        }
    }

    public void testUncompressedRepository() throws ProvisionException {
        IArtifactRepositoryManager artifactRepositoryManager = SimpleArtifactRepositoryTest.getArtifactRepositoryManager();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repositoryFile = new File(tempDir, "SimpleArtifactRepositoryTest");
        SimpleArtifactRepositoryTest.delete(this.repositoryFile);
        this.repositoryURI = this.repositoryFile.toURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "false");
        IArtifactRepository repo = artifactRepositoryManager.createRepository(this.repositoryURI, "artifact name", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        repo.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        File[] files = this.repositoryFile.listFiles();
        boolean jarFilePresent = false;
        boolean artifactFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("artifacts.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            if ("artifacts.xml".equalsIgnoreCase(files[i].getName())) {
                artifactFilePresent = true;
            }
            ++i;
        }
        SimpleArtifactRepositoryTest.delete(this.repositoryFile);
        if (jarFilePresent) {
            SimpleArtifactRepositoryTest.fail((String)"Repository should not create JAR for artifact.xml");
        }
        if (!artifactFilePresent) {
            SimpleArtifactRepositoryTest.fail((String)"Repository should create artifact.xml");
        }
    }

    public void testLoadInvalidLocation() {
        try {
            SimpleArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(new URI("file:d:/foo"), this.getMonitor());
        }
        catch (ProvisionException provisionException) {
        }
        catch (URISyntaxException e) {
            SimpleArtifactRepositoryTest.fail("4.99", e);
        }
    }

    public void test_248772() {
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        factory.setAgent(SimpleArtifactRepositoryTest.getAgent());
        URI location = null;
        location = new File(this.getTempFolder(), SimpleArtifactRepositoryTest.getUniqueString()).toURI();
        factory.create(location, "test type", null, null);
        try {
            IArtifactRepository repo = factory.load(location, 1, (IProgressMonitor)new NullProgressMonitor());
            SimpleArtifactRepositoryTest.assertNotNull((Object)repo);
            SimpleArtifactRepositoryTest.assertTrue((boolean)repo.isModifiable());
        }
        catch (ProvisionException e) {
            SimpleArtifactRepositoryTest.fail("2.0", e);
        }
    }

    public void testErrorStatus() {
        block16: {
            this.repositoryURI = SimpleArtifactRepositoryTest.getTestData("Loading test data", "testData/artifactRepo/simple").toURI();
            this.repositoryFile = new File(this.getTempFolder(), SimpleArtifactRepositoryTest.getUniqueString());
            IArtifactRepository repo = null;
            try {
                repo = SimpleArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(this.repositoryURI, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProvisionException e) {
                SimpleArtifactRepositoryTest.fail("Failed to create repository", e);
            }
            ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "aaPlugin", Version.create((String)"1.0.0")));
            OutputStream out = null;
            try {
                try {
                    class TestStep
                    extends ProcessingStep {
                        IStatus myStatus;

                        public TestStep(IStatus status) {
                            this.myStatus = status;
                        }

                        public void close() throws IOException {
                            this.setStatus(this.myStatus);
                            super.close();
                        }
                    }
                    TestStep errStep = new TestStep((IStatus)new Status(4, "plugin", "Error Step Message"));
                    TestStep warnStep = new TestStep((IStatus)new Status(2, "plugin", "Warning Step Message"));
                    TestStep okStep = new TestStep(Status.OK_STATUS);
                    out = new FileOutputStream(this.repositoryFile);
                    new ProcessingStepHandler().link(new ProcessingStep[]{okStep, errStep, warnStep}, out, (IProgressMonitor)new NullProgressMonitor());
                    IStatus status = repo.getRawArtifact((IArtifactDescriptor)descriptor, (OutputStream)((Object)okStep), (IProgressMonitor)new NullProgressMonitor());
                    out.close();
                    SimpleArtifactRepositoryTest.assertFalse((boolean)status.isOK());
                    SimpleArtifactRepositoryTest.assertTrue((String)"Unexpected Severity", (boolean)status.matches(4));
                    SimpleArtifactRepositoryTest.assertEquals((int)1, (int)status.getChildren().length);
                    errStep = new TestStep((IStatus)new Status(4, "plugin", "Error Step Message"));
                    warnStep = new TestStep((IStatus)new Status(2, "plugin", "Warning Step Message"));
                    TestStep warnStep2 = new TestStep((IStatus)new Status(2, "plugin", "2 - Warning Step Message"));
                    okStep = new TestStep(Status.OK_STATUS);
                    out = new FileOutputStream(this.repositoryFile);
                    new ProcessingStepHandler().link(new ProcessingStep[]{okStep, warnStep, errStep, warnStep2}, out, (IProgressMonitor)new NullProgressMonitor());
                    status = repo.getRawArtifact((IArtifactDescriptor)descriptor, (OutputStream)((Object)okStep), (IProgressMonitor)new NullProgressMonitor());
                    out.close();
                    SimpleArtifactRepositoryTest.assertFalse((boolean)status.isOK());
                    SimpleArtifactRepositoryTest.assertTrue((String)"Unexpected Severity", (boolean)status.matches(4));
                    SimpleArtifactRepositoryTest.assertEquals((int)2, (int)status.getChildren().length);
                }
                catch (IOException e) {
                    SimpleArtifactRepositoryTest.fail("Failed to create ouptut stream", e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void testProperPackedFeatureLocation() {
        try {
            this.repositoryFile = this.getTempFolder();
            this.repositoryURI = this.repositoryFile.toURI();
            ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("org.eclipse.update.feature", "test", Version.parseVersion((String)"1.0.0")));
            descriptor.setProperty("format", "packed");
            descriptor.setProcessingSteps(new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)});
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("publishPackFilesAsSiblings", Boolean.TRUE.toString());
            SimpleArtifactRepository repo = (SimpleArtifactRepository)SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
            URI location = repo.getLocation((IArtifactDescriptor)descriptor);
            SimpleArtifactRepositoryTest.assertNotNull((String)"Null location returned", (Object)location);
            SimpleArtifactRepositoryTest.assertTrue((String)"Unexpected location", (boolean)location.toString().endsWith(".pack.gz"));
        }
        catch (Exception e) {
            SimpleArtifactRepositoryTest.fail("Test failed", e);
        }
    }

    public void testRelativeRepositoryLocation() throws ProvisionException {
        ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "helloworld", Version.createOSGi((int)1, (int)0, (int)0)));
        URI repo = SimpleArtifactRepositoryTest.getTestData("CorruptedJar repo", "testData/artifactRepo/jarfiles").toURI();
        SimpleArtifactRepository absRepo = (SimpleArtifactRepository)SimpleArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(repo, (IProgressMonitor)new NullProgressMonitor());
        URI absLocation = absRepo.getLocation((IArtifactDescriptor)descriptor);
        SimpleArtifactRepositoryTest.getArtifactRepositoryManager().removeRepository(repo);
        repo = new File(System.getProperty("user.dir")).toURI().relativize(repo);
        if (!"file".equals(repo.getScheme())) {
            repo = URI.create("file:" + repo.toString());
        }
        SimpleArtifactRepository repository = (SimpleArtifactRepository)SimpleArtifactRepositoryTest.getArtifactRepositoryManager().loadRepository(repo, (IProgressMonitor)new NullProgressMonitor());
        URI location = repository.getLocation((IArtifactDescriptor)descriptor);
        SimpleArtifactRepositoryTest.assertNotNull((String)"NULL Scheme", (Object)location.getScheme());
        SimpleArtifactRepositoryTest.assertTrue((String)"File location is relative", (boolean)location.isAbsolute());
        SimpleArtifactRepositoryTest.assertEquals((String)"Path from relative & absolute repos differ", (Object)absLocation, (Object)location);
    }

    public void testAddContains() throws Exception {
        File folder = this.getTestFolder("simple_AddContains");
        this.repositoryURI = folder.toURI();
        HashMap properties = new HashMap();
        SimpleArtifactRepository repo = (SimpleArtifactRepository)SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "My Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        TestDescriptor descriptor = new TestDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "aaPlugin", Version.create((String)"1.0.0")));
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream stream = repo.getOutputStream((IArtifactDescriptor)descriptor);){
            stream.write("I am an artifact\n".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SimpleArtifactRepositoryTest.assertTrue((boolean)repo.contains((IArtifactDescriptor)descriptor));
        SimpleArtifactRepositoryTest.assertTrue((boolean)repo.contains((IArtifactDescriptor)new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "aaPlugin", Version.create((String)"1.0.0")))));
    }

    public void _testAddDescriptorPerformance() throws Exception {
        File folder = this.getTestFolder("ArtifactRepository_testAddDescriptorPerformance");
        this.repositoryURI = folder.toURI();
        IArtifactRepository repo = SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "test", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", new HashMap());
        long start = System.currentTimeMillis();
        NullProgressMonitor monitor = new NullProgressMonitor();
        int i = 0;
        while (i < 10000) {
            ArtifactDescriptor d = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "a" + i, Version.create((String)"1.0.0")));
            repo.addDescriptor((IArtifactDescriptor)d, (IProgressMonitor)monitor);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("Total time: " + (end - start));
    }

    public void _testAddDescriptorPerformanceExecuteBatch() throws Exception {
        File folder = this.getTestFolder("ArtifactRepository_testAddDescriptorPerformanceExectuteBatch");
        this.repositoryURI = folder.toURI();
        IArtifactRepository repo = SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "test", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", new HashMap());
        long start = System.currentTimeMillis();
        repo.executeBatch(monitor -> {
            int i = 0;
            while (i < 10000) {
                ArtifactDescriptor d = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "a" + i, Version.create((String)"1.0.0")));
                repo.addDescriptor((IArtifactDescriptor)d, monitor);
                ++i;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        long end = System.currentTimeMillis();
        System.out.println("Total time: " + (end - start));
    }

    public void testQuery() throws Exception {
        File folder = this.getTestFolder("ArtifactRepository_testQuery");
        this.repositoryURI = folder.toURI();
        IArtifactRepository repo = SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "test", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", new HashMap());
        ArtifactDescriptor d1 = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "a", Version.create((String)"1.0.0")));
        ArtifactDescriptor d2 = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "a", Version.create((String)"2.0.0")));
        ArtifactDescriptor d3 = new ArtifactDescriptor((IArtifactKey)new ArtifactKey("osgi.bundle", "a", Version.create((String)"2.0.0")));
        d3.setProperty("format", "packed");
        NullProgressMonitor monitor = new NullProgressMonitor();
        repo.addDescriptor((IArtifactDescriptor)d1, (IProgressMonitor)monitor);
        repo.addDescriptor((IArtifactDescriptor)d2, (IProgressMonitor)monitor);
        repo.addDescriptor((IArtifactDescriptor)d3, (IProgressMonitor)monitor);
        IQueryable descQueryable = repo.descriptorQueryable();
        IQueryResult result = descQueryable.query((IQuery)new ArtifactDescriptorQuery("a", null, null), null);
        SimpleArtifactRepositoryTest.assertEquals((int)3, (int)SimpleArtifactRepositoryTest.queryResultSize(result));
        result = descQueryable.query((IQuery)new ArtifactDescriptorQuery("a", new VersionRange("[2.0.0, 3.0.0)"), null), null);
        SimpleArtifactRepositoryTest.assertEquals((int)2, (int)SimpleArtifactRepositoryTest.queryResultSize(result));
        SimpleArtifactRepositoryTest.assertNotContains(result, d1);
        result = descQueryable.query((IQuery)new ArtifactDescriptorQuery("a", null, "packed"), null);
        SimpleArtifactRepositoryTest.assertEquals((int)1, (int)SimpleArtifactRepositoryTest.queryResultSize(result));
        IArtifactDescriptor resultDescriptor = (IArtifactDescriptor)result.iterator().next();
        SimpleArtifactRepositoryTest.assertEquals((Object)d3.getArtifactKey(), (Object)resultDescriptor.getArtifactKey());
    }

    public void testMaximumThreads() throws Exception {
        File folder = this.getTestFolder("ArtifactRepository_testQuery");
        this.repositoryURI = folder.toURI();
        IArtifactRepository repo = SimpleArtifactRepositoryTest.getArtifactRepositoryManager().createRepository(this.repositoryURI, "test", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", new HashMap());
        Method getMaximumThreads = SimpleArtifactRepository.class.getDeclaredMethod("getMaximumThreads", new Class[0]);
        getMaximumThreads.setAccessible(true);
        Field defaultMaxThreadsField = SimpleArtifactRepository.class.getDeclaredField("DEFAULT_MAX_THREADS");
        defaultMaxThreadsField.setAccessible(true);
        int defaultMaxThreads = defaultMaxThreadsField.getInt(repo);
        SimpleArtifactRepositoryTest.assertEquals((String)"Default setting", (int)defaultMaxThreads, (int)this.getIntVal(getMaximumThreads, repo));
        System.setProperty("eclipse.p2.max.threads", "2");
        SimpleArtifactRepositoryTest.assertEquals((String)"Valid User setting", (int)2, (int)this.getIntVal(getMaximumThreads, repo));
        System.setProperty("eclipse.p2.max.threads", "22");
        SimpleArtifactRepositoryTest.assertEquals((String)"Invalid User setting", (int)defaultMaxThreads, (int)this.getIntVal(getMaximumThreads, repo));
        System.clearProperty("eclipse.p2.max.threads");
        repo.setProperty("eclipse.p2.max.threads", "4");
        SimpleArtifactRepositoryTest.assertEquals((String)"Valid repository specified setting", (int)4, (int)this.getIntVal(getMaximumThreads, repo));
        repo.setProperty("eclipse.p2.max.threads", "3");
        System.setProperty("eclipse.p2.max.threads", "2");
        SimpleArtifactRepositoryTest.assertEquals((String)"User setting should take precedence", (int)2, (int)this.getIntVal(getMaximumThreads, repo));
        repo.setProperty("eclipse.p2.max.threads", "2");
        System.setProperty("eclipse.p2.max.threads", "3");
        SimpleArtifactRepositoryTest.assertEquals((String)"User setting should take precedence", (int)2, (int)this.getIntVal(getMaximumThreads, repo));
    }

    private int getIntVal(Method m, Object repo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return (Integer)m.invoke(repo, new Object[0]);
    }

    private static class TestDescriptor
    implements IArtifactDescriptor {
        private static final IProcessingStepDescriptor[] steps = new IProcessingStepDescriptor[0];
        private IArtifactKey artifactKey;
        private Map<String, String> properties = new HashMap<String, String>();

        public TestDescriptor(IArtifactKey key) {
            this.artifactKey = key;
        }

        public IArtifactKey getArtifactKey() {
            return this.artifactKey;
        }

        public IProcessingStepDescriptor[] getProcessingSteps() {
            return steps;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public IArtifactRepository getRepository() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IArtifactDescriptor)) {
                return false;
            }
            IArtifactDescriptor other = (IArtifactDescriptor)obj;
            if (!this.artifactKey.equals(other.getArtifactKey())) {
                return false;
            }
            if (!Arrays.equals(steps, other.getProcessingSteps())) {
                return false;
            }
            String format = this.getProperty("format");
            String otherFormat = other.getProperty("format");
            return !(format != null ? !format.equals(otherFormat) : otherFormat != null);
        }

        public int hashCode() {
            String format = this.getProperty("format");
            int result = 1;
            result = 31 * result + (this.artifactKey == null ? 0 : this.artifactKey.hashCode());
            result = 31 * result + Arrays.asList(steps).hashCode();
            result = 31 * result + (format != null ? format.hashCode() : 0);
            return result;
        }
    }
}

