/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class StatsTest
extends AbstractTestServerClientCase {
    private File repositoryFile;
    private URI repositoryURI;
    private SimpleArtifactRepository sourceRepo;
    private File targetLocation;
    private SimpleArtifactRepository targetRepository;
    private URI statsURL;
    private IMetadataRepository metaRepo;
    private File testInstall;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)StatsTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repositoryFile = new File(tempDir, "SimpleArtifactRepositoryTest");
        AbstractProvisioningTest.delete(this.repositoryFile);
        this.repositoryURI = this.repositoryFile.toURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        this.statsURL = URI.create(String.valueOf(this.getBaseURL()) + "/stats");
        properties.put("p2.statsURI", this.statsURL.toString());
        this.sourceRepo = (SimpleArtifactRepository)artifactRepositoryManager.createRepository(this.repositoryURI, "artifact name", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        IArtifactDescriptor[] descriptors = new IArtifactDescriptor[2];
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        descriptors[0] = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        ((ArtifactDescriptor)descriptors[0]).setProperty("download.stats", "testKeyId");
        key = PublisherHelper.createBinaryArtifactKey((String)"testKeyId2", (Version)Version.create((String)"1.2.3"));
        descriptors[1] = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        ((ArtifactDescriptor)descriptors[1]).setProperty("download.stats", "testKeyId2");
        this.sourceRepo.addDescriptors(descriptors, null);
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)StatsTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        properties = new HashMap();
        properties.put("p2.compressed", "true");
        this.metaRepo = manager.createRepository(this.repositoryURI, "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"1.0.0"));
        descriptor.setArtifacts(new IArtifactKey[]{key});
        ArrayList<IProvidedCapability> providedCaps = new ArrayList<IProvidedCapability>();
        providedCaps.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)descriptor.getId(), (Version)descriptor.getVersion()));
        descriptor.addProvidedCapabilities(providedCaps);
        descriptor.setMetaRequirements(new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)descriptor.getId(), (VersionRange)new VersionRange(descriptor.getVersion(), true, Version.MAX_VERSION, false), null, (boolean)false, (boolean)false)});
        descriptor.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        this.metaRepo.addInstallableUnits(Arrays.asList(iu));
        int i = 0;
        while (i < descriptors.length) {
            File artifactFile = new File(this.sourceRepo.getLocation(descriptors[i]));
            artifactFile.getParentFile().mkdirs();
            StatsTest.assertTrue((String)"Failed to create binary artifact file.", (boolean)artifactFile.createNewFile());
            ++i;
        }
        this.targetLocation = File.createTempFile("target", ".repo");
        AbstractProvisioningTest.delete(this.targetLocation);
        this.targetLocation.mkdirs();
        this.targetRepository = new SimpleArtifactRepository(StatsTest.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.repositoryURI != null) {
            ((IArtifactRepositoryManager)StatsTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME)).removeRepository(this.repositoryURI);
            ((IMetadataRepositoryManager)StatsTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME)).removeRepository(this.repositoryURI);
            this.repositoryURI = null;
        }
        if (this.repositoryFile != null) {
            AbstractProvisioningTest.delete(this.repositoryFile);
            this.repositoryFile = null;
        }
        if (this.targetLocation != null) {
            ((IArtifactRepositoryManager)StatsTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME)).removeRepository(this.targetLocation.toURI());
            AbstractProvisioningTest.delete(this.targetLocation);
            this.targetLocation = null;
        }
        if (this.testInstall != null) {
            AbstractProvisioningTest.delete(this.testInstall);
            this.testInstall = null;
        }
    }

    public void testCustomizedDownloadStats() throws CoreException, IOException {
        ArtifactKey key = new ArtifactKey("binary", "testKeyId", Version.parseVersion((String)"1.2.3"));
        MirrorRequest request = new MirrorRequest((IArtifactKey)key, (IArtifactRepository)this.targetRepository, null, null, (Transport)StatsTest.getAgent().getService(Transport.SERVICE_NAME), "package=test");
        request.perform((IArtifactRepository)this.sourceRepo, (IProgressMonitor)new NullProgressMonitor());
        StatsTest.assertTrue((String)"Failed on mirroring artifact.", (boolean)request.getResult().isOK());
        this.checkStatsResult("test download number: 1");
    }

    protected void checkStatsResult(String checkpoint) throws FileNotFoundException, CoreException, AuthenticationFailedException, IOException {
        Transport transport = (Transport)StatsTest.getAgent().getService(Transport.SERVICE_NAME);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader statsResult = new BufferedReader(new InputStreamReader(transport.stream(this.statsURL, null)));){
            String line = statsResult.readLine();
            if (line != null) {
            }
            StatsTest.fail((String)"Didn't get expected stats result.");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testDownloadStatsWhileInstall() throws AuthenticationFailedException, FileNotFoundException, CoreException, IOException {
        IProfileRegistry registry = (IProfileRegistry)StatsTest.getAgent().getService(IProfileRegistry.SERVICE_NAME);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.stats.parameters", "os=linux&ws=gtk&package=jee");
        String tempDir = System.getProperty("java.io.tmpdir");
        this.testInstall = new File(tempDir, "statsTestInstall");
        this.testInstall.mkdirs();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testInstall.toString());
        Profile profile = (Profile)registry.addProfile("downloadStats", properties);
        ProfileChangeRequest req = new ProfileChangeRequest((IProfile)profile);
        req.addInstallableUnits((IInstallableUnit[])this.metaRepo.query(QueryUtil.ALL_UNITS, null).toArray(IInstallableUnit.class));
        IPlanner planner = (IPlanner)StatsTest.getAgent().getService(IPlanner.SERVICE_NAME);
        ProvisioningContext context = new ProvisioningContext(StatsTest.getAgent());
        context.setArtifactRepositories(new URI[]{this.repositoryURI});
        context.setMetadataRepositories(new URI[]{this.repositoryURI});
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)req, context, null);
        IEngine engine = (IEngine)StatsTest.getAgent().getService(IEngine.SERVICE_NAME);
        StatsTest.assertTrue((String)"Failed on install test iu.", (boolean)engine.perform(plan, null).isOK());
        profile = (Profile)registry.getProfile("downloadStats");
        StatsTest.assertEquals((String)"Didn't install iu.", (int)1, (int)profile.query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet().size());
        registry.removeProfile("downloadStats");
        this.checkStatsResult("jee download number: 1");
    }
}

