/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.osgi.framework.BundleException;

public class TransferExceptionsTest
extends AbstractProvisioningTest {
    public void testErrorMessages() {
        FileOutputStream fos = null;
        File f = null;
        try {
            f = File.createTempFile("TransferTest", "dummy.txt");
            fos = new FileOutputStream(f);
            Platform.getBundle((String)"org.eclipse.ecf.provider.filetransfer").start();
        }
        catch (IOException e) {
            TransferExceptionsTest.fail("1.0", e);
        }
        catch (BundleException e) {
            TransferExceptionsTest.fail("1.5", e);
        }
        try {
            IStatus s = this.getTransport().download(new URI("bogus!bogus"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("1", s);
            s = this.getTransport().download(new URI("bogus://somewhere.else"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("2", s);
            s = this.getTransport().download(new URI("http:bogusURL"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("3", s);
            s = this.getTransport().download(new URI("http://bogusURL:80/"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("4", s);
            s = this.getTransport().download(new URI("http:/bogusURL:999999999999/"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("5", s);
            s = this.getTransport().download(new URI("http://bogus.nowhere"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("6", s);
            s = this.getTransport().download(new URI("http://www.eclipse.org/AFileThatDoesNotExist.foo"), (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            TransferExceptionsTest.assertNotOK(s);
            TransferExceptionsTest.printStatus("7", s);
        }
        catch (URISyntaxException e) {
            TransferExceptionsTest.fail((String)("URI syntax exception where none was expected: " + e.getMessage()));
        }
    }

    private static void printStatus(String msg, IStatus s) {
        System.err.print("TEST OUTPUT: " + msg + "\n");
        System.err.print("     ");
        System.err.print("Message [" + s.getMessage() + "] Exception Class[" + s.getException().getClass().getName() + "] ExceptionMessage[ ");
        System.err.print(String.valueOf(s.getException().getMessage()) + "]\n");
    }
}

