/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository.processing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pack200.Pack200ProcessorStep;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.jarprocessor.PackStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.Adder;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.ByteShifter;
import org.eclipse.equinox.p2.tests.artifact.repository.processing.Multiplier;

public class ProcessingStepHandlerTest
extends AbstractProvisioningTest {
    ProcessingStepHandler handler = new ProcessingStepHandler();
    IProgressMonitor monitor = new NullProgressMonitor();

    public void testExecuteNoPSs() throws IOException {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.createAndLink(ProcessingStepHandlerTest.getAgent(), descriptors, null, (OutputStream)result, this.monitor);){
            testStream.write("Test".getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertEquals((String)"Test", (String)((Object)result).toString());
    }

    public void testExecuteOneByteShifterPS() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new ByteShifter(1)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{2}, result.toByteArray()));
    }

    public void testExecuteTwoByteShifterPSs() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new ByteShifter(1), new ByteShifter(2)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{8}, result.toByteArray()));
    }

    public void testAssureOrderingOfPSs1() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new Adder(1), new Multiplier(2)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{4, 6, 8, 10, 12}, result.toByteArray()));
    }

    public void testAssureOrderingOfPSs2() throws IOException {
        ProcessingStep[] steps = new ProcessingStep[]{new Multiplier(2), new Adder(1)};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{3, 5, 7, 9, 11}, result.toByteArray()));
    }

    public void testExecuteOnePack200UnpackerPS() throws IOException {
        if (!PackStep.canPack()) {
            return;
        }
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ByteArrayOutputStream result = new ByteArrayOutputStream(100000);
        OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);
        IStatus status = ProcessingStepHandler.checkStatus((OutputStream)testStream);
        ProcessingStepHandlerTest.assertTrue((String)"Step is not ready.", (boolean)status.isOK());
        InputStream inputStream = TestActivator.getContext().getBundle().getEntry("testData/jarprocessor.jar.pack.gz").openStream();
        FileUtils.copyStream((InputStream)inputStream, (boolean)true, (OutputStream)testStream, (boolean)true);
        ProcessingStepHandlerTest.assertEquals((int)35062, (int)result.size());
    }

    public void testCreateByteShifterPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.ByteShifter", "1", true)};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ProcessingStepHandlerTest.assertNotNull((Object)steps);
        ProcessingStepHandlerTest.assertEquals((int)1, (int)steps.length);
        ProcessingStepHandlerTest.assertEquals(ByteShifter.class, steps[0].getClass());
    }

    public void testCreateAdderPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true)};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ProcessingStepHandlerTest.assertNotNull((Object)steps);
        ProcessingStepHandlerTest.assertEquals((int)1, (int)steps.length);
        ProcessingStepHandlerTest.assertEquals(Adder.class, steps[0].getClass());
    }

    public void testCreateMultiplierPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true)};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ProcessingStepHandlerTest.assertNotNull((Object)steps);
        ProcessingStepHandlerTest.assertEquals((int)1, (int)steps.length);
        ProcessingStepHandlerTest.assertEquals(Multiplier.class, steps[0].getClass());
    }

    public void testCreatePack200UnpackerPS() {
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ProcessingStepHandlerTest.assertNotNull((Object)steps);
        ProcessingStepHandlerTest.assertEquals((int)1, (int)steps.length);
        ProcessingStepHandlerTest.assertEquals(Pack200ProcessorStep.class, steps[0].getClass());
    }

    public void testCreatePSsAndAssureOrderingOfPSs1() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{adder, multiplier};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{4, 6, 8, 10, 12}, result.toByteArray()));
    }

    public void testCreatePSsAndAssureOrderingOfPSs2() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{multiplier, adder};
        ProcessingStep[] steps = this.handler.create(ProcessingStepHandlerTest.getAgent(), descriptors, null);
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var7_8 = null;
        try (OutputStream testStream = this.handler.link(steps, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{3, 5, 7, 9, 11}, result.toByteArray()));
    }

    public void testLinkPSs() throws IOException {
        ProcessingStepDescriptor adder = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Adder", "1", true);
        ProcessingStepDescriptor multiplier = new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Multiplier", "2", true);
        IProcessingStepDescriptor[] descriptors = new IProcessingStepDescriptor[]{adder, multiplier};
        ByteArrayOutputStream result = new ByteArrayOutputStream(10);
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream testStream = this.handler.createAndLink(ProcessingStepHandlerTest.getAgent(), descriptors, null, (OutputStream)result, this.monitor);){
            testStream.write(new byte[]{1, 2, 3, 4, 5});
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ProcessingStepHandlerTest.assertTrue((boolean)Arrays.equals(new byte[]{4, 6, 8, 10, 12}, result.toByteArray()));
    }

    public void testPSHgetStatusOK() {
        ProcessingStep ok1 = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        ProcessingStep ok2 = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        OutputStream testStream = this.handler.link(new ProcessingStep[]{ok1, ok2}, null, this.monitor);
        IStatus status = ProcessingStepHandler.getStatus((OutputStream)testStream);
        IStatus errStatus = ProcessingStepHandler.getStatus((OutputStream)testStream);
        ProcessingStepHandlerTest.assertTrue((status.isOK() && errStatus.isOK() ? 1 : 0) != 0);
        ProcessingStepHandlerTest.assertTrue((!status.isMultiStatus() ? 1 : 0) != 0);
        ProcessingStepHandlerTest.assertTrue((!errStatus.isMultiStatus() ? 1 : 0) != 0);
    }

    public void testPSHgetStatus() {
        ProcessingStep ok = new ProcessingStep(){

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
        ProcessingStep info = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(1, "ID", "INFO");
            }
        };
        ProcessingStep warning = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(2, "ID", "WARNING");
            }
        };
        ProcessingStep error = new ProcessingStep(){

            public IStatus getStatus() {
                return new Status(4, "ID", "ERROR");
            }
        };
        OutputStream testStream = this.handler.link(new ProcessingStep[]{info, ok, error, warning}, null, this.monitor);
        ProcessingStepHandlerTest.assertTrue((ProcessingStepHandler.getErrorStatus((OutputStream)testStream).getChildren().length == 2 ? 1 : 0) != 0);
        ProcessingStepHandlerTest.assertTrue((ProcessingStepHandler.getStatus((OutputStream)testStream, (boolean)true).getChildren().length == 4 ? 1 : 0) != 0);
    }
}

