/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.core;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.harness.TestProgressMonitor;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.core.ContextQuery;

public class CompoundQueryableTest
extends TestCase {
    IQueryable<Integer> queryable1 = new IQueryable<Integer>(){
        Integer[] elements = new Integer[]{1, 2, 3, 4, 5};

        public IQueryResult<Integer> query(IQuery<Integer> query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQueryable<Integer> queryable2 = new IQueryable<Integer>(){
        Integer[] elements = new Integer[]{4, 6, 8, 10, 12};

        public IQueryResult<Integer> query(IQuery<Integer> query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQueryable<Integer> queryable3 = new IQueryable<Integer>(){
        Integer[] elements = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};

        public IQueryResult<Integer> query(IQuery<Integer> query, IProgressMonitor monitor) {
            IQueryResult collector;
            try {
                monitor.beginTask("", 10);
                collector = query.perform(CompoundQueryableTest.createIterator(this.elements));
                monitor.worked(10);
            }
            finally {
                monitor.done();
            }
            return collector;
        }
    };
    IQuery<Integer> matchQuery = new MatchQuery<Integer>(){

        public boolean isMatch(Integer candidate) {
            int x = candidate;
            return x % 2 == 0;
        }
    };
    IQuery<Integer> matchMod4query = new MatchQuery<Integer>(){

        public boolean isMatch(Integer candidate) {
            int x = candidate;
            return x % 4 == 0;
        }
    };
    IQuery<Integer> contextQuery = new ContextQuery<Integer>(){

        @Override
        public Collector<Integer> perform(Iterator<Integer> iterator) {
            Collector result = new Collector();
            while (iterator.hasNext()) {
                Integer o = iterator.next();
                if (o % 2 != 0) continue;
                result.accept((Object)o);
            }
            return result;
        }
    };
    IQuery<Integer> greatestNumberQuery = new ContextQuery<Integer>(){

        @Override
        public Collector<Integer> perform(Iterator<Integer> iterator) {
            Collector result = new Collector();
            int greatest = Integer.MIN_VALUE;
            while (iterator.hasNext()) {
                int item = iterator.next();
                if (item <= greatest) continue;
                greatest = item;
            }
            if (greatest == Integer.MIN_VALUE) {
                return result;
            }
            result.accept((Object)greatest);
            return result;
        }
    };

    static Iterator<Integer> createIterator(Integer[] array) {
        return Arrays.asList(array).iterator();
    }

    public void testMatchQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)6, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.3", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.5", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testSingleQueryable() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)2, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
    }

    public void testSingleContextQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 5);
    }

    public void testMultipleContextQueries() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.1", queryResult, 12);
    }

    public void testCompoundMatchAndQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery(this.matchQuery, this.matchMod4query, (boolean)true), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)3, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testCompoundMatchOrQuery() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery(this.matchQuery, this.matchMod4query, (boolean)false), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)6, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
    }

    public void testMatchQueryProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testSingleQueryableProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.matchQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testSingleContextQueryProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(Arrays.asList(this.queryable1));
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testMultipleContextQueriesProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        cQueryable.query(this.greatestNumberQuery, (IProgressMonitor)monitor);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testNullProgressMonitor() {
        IQueryable cQueryable = QueryUtil.compoundQueryable(this.queryable1, this.queryable2);
        cQueryable.query(this.greatestNumberQuery, null);
    }

    public void testDoubleCompoundContextOrQuery() {
        IQueryable cQueryable1 = QueryUtil.compoundQueryable(this.queryable3, this.queryable2);
        IQueryable cQueryable = QueryUtil.compoundQueryable((IQueryable)cQueryable1, this.queryable1);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createCompoundQuery(this.contextQuery, this.greatestNumberQuery, (boolean)false), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)7, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 2);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 4);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 6);
        AbstractProvisioningTest.assertContains("1.4", queryResult, 8);
        AbstractProvisioningTest.assertContains("1.2", queryResult, 10);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 12);
        AbstractProvisioningTest.assertContains("1.6", queryResult, 13);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public void testDoubleCompositeQuery() {
        IQueryable cQueryable1 = QueryUtil.compoundQueryable(this.queryable3, this.queryable2);
        IQueryable cQueryable = QueryUtil.compoundQueryable((IQueryable)cQueryable1, this.queryable1);
        CompoundQueryTestProgressMonitor monitor = new CompoundQueryTestProgressMonitor();
        IQueryResult queryResult = cQueryable.query(QueryUtil.createPipeQuery(this.contextQuery, this.greatestNumberQuery), (IProgressMonitor)monitor);
        CompoundQueryableTest.assertEquals((String)"1.0", (int)1, (int)AbstractProvisioningTest.queryResultSize(queryResult));
        AbstractProvisioningTest.assertContains("1.2", queryResult, 12);
        CompoundQueryableTest.assertTrue((String)"1.0", (boolean)monitor.isDone());
        CompoundQueryableTest.assertTrue((String)"1.1", (boolean)monitor.isWorkDone());
    }

    public static class CompoundQueryTestProgressMonitor
    extends TestProgressMonitor {
        private boolean isDone;
        private int assignedWork = 0;
        private int amountWorked = 0;

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.assignedWork += totalWork;
        }

        public void worked(int work) {
            this.amountWorked += work;
        }

        public boolean isWorkDone() {
            return this.amountWorked > 0 && (this.assignedWork == -1 || this.amountWorked == this.assignedWork);
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void done() {
            super.done();
            this.isDone = true;
        }
    }
}

