/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AutomatedDirectorTest
extends AbstractProvisioningTest {
    public void testInstallFilteredCapability() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IMatchExpression<IInstallableUnit> requirementFilter = AutomatedDirectorTest.createFilter("filterKey", "true");
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), (VersionRange)ANY_VERSION, requirementFilter, (boolean)false, (boolean)false)};
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "filterKey=true");
        IProfile satisfied = this.createProfile("Satisfied." + this.getName(), properties);
        ProfileChangeRequest request = new ProfileChangeRequest(satisfied);
        request.add(toInstallIU);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", satisfied, allUnits);
    }

    public void testInstallOptionalAvailable() {
        String capabilityName = "test." + this.getName();
        Version capabilityVersion = DEFAULT_VERSION;
        IProvidedCapability[] provides = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"test.capability", (String)capabilityName, (Version)capabilityVersion)};
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), provides);
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"test.capability", (String)capabilityName, (VersionRange)ANY_VERSION, null, (boolean)true, (boolean)false, (boolean)false)};
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU, requiredIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, toInstallArray);
    }

    public void testInstallOptionalUnavailable() {
        String capabilityName = "test." + this.getName();
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"test.capability", (String)capabilityName, (VersionRange)ANY_VERSION, null, (boolean)true, (boolean)false)};
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(allUnits);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testInstallPlatformFilter() {
        String capabilityName = "test." + this.getName();
        Version capabilityVersion = DEFAULT_VERSION;
        IProvidedCapability[] provides = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"test.capability", (String)capabilityName, (Version)capabilityVersion)};
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), AutomatedDirectorTest.createFilter("osgi.os", "blort"), provides);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), AutomatedDirectorTest.createRequiredCapabilities("test.capability", capabilityName, ANY_VERSION, null));
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IDirector director = AutomatedDirectorTest.createDirector();
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "osgi.os=blort");
        profile = this.createProfile("TestProfile2." + this.getName(), properties);
        request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"2.0", (boolean)result.isOK());
    }

    public void testInstallPlatformFilterUnsatisfied() {
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), AutomatedDirectorTest.createFilter("osgi.os", "blort"), NO_PROVIDES);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((!result.isOK() ? 1 : 0) != 0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "osgi.os=blort");
        profile = this.createProfile("TestProfile2." + this.getName(), properties);
        request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((boolean)result.isOK());
    }

    public void testSimpleInstallRequired() {
        String capabilityNamespace = "test.capability";
        String capabilityName = "test." + this.getName();
        IProvidedCapability[] provides = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)capabilityNamespace, (String)capabilityName, (Version)DEFAULT_VERSION)};
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), provides);
        IRequirement[] requires = AutomatedDirectorTest.createRequiredCapabilities(capabilityNamespace, capabilityName, ANY_VERSION, null);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testInstallRequiredNoVersion() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), null, null, (boolean)false, (boolean)false)};
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testSimpleInstallRequiredIU() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false)};
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), requires);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        request.addInstallableUnits(toInstallArray);
        IDirector director = AutomatedDirectorTest.createDirector();
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }
}

