/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RollbackTest
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit c1;
    IInstallableUnit d1;
    private IProfile profile;
    private IDirector director;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = RollbackTest.createIU("A", DEFAULT_VERSION, true);
        this.b1 = RollbackTest.createIU("B", DEFAULT_VERSION, true);
        this.c1 = RollbackTest.createIU("C", DEFAULT_VERSION, true);
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.d1 = RollbackTest.createIU("D", Version.create((String)"1.0.0"), req);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.c1, this.d1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.director = RollbackTest.createDirector();
        try {
            IMetadataRepository rollbackRepo = this.getRollbackRepository();
            if (rollbackRepo != null) {
                rollbackRepo.removeAll();
            }
        }
        catch (ProvisionException provisionException) {
            return;
        }
    }

    private IMetadataRepository getRollbackRepository() throws ProvisionException {
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)RollbackTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI location = ((IAgentLocation)RollbackTest.getAgent().getService(IAgentLocation.SERVICE_NAME)).getDataArea("org.eclipse.equinox.p2.director");
        return repoMan.loadRepository(URIUtil.append((URI)location, (String)"rollback"), null);
    }

    public void testRollbackProfileProperties() {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        RollbackTest.assertEquals((int)1, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request1 = new ProfileChangeRequest(this.profile);
        request1.setProfileProperty("test1", "test");
        request1.setProfileProperty("test2", "test");
        IStatus status = this.director.provision((IProfileChangeRequest)request1, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"1.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"2.0", (String)"test", (String)this.profile.getProperty("test1"));
        RollbackTest.assertEquals((String)"3.0", (String)"test", (String)this.profile.getProperty("test2"));
        RollbackTest.assertEquals((int)2, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.profile);
        request2.removeProfileProperty("test1");
        request2.setProfileProperty("test2", "bad");
        request2.setProfileProperty("test3", "test");
        status = this.director.provision((IProfileChangeRequest)request2, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"5.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"6.0", null, (String)this.profile.getProperty("test1"));
        RollbackTest.assertEquals((String)"7.0", (String)"bad", (String)this.profile.getProperty("test2"));
        RollbackTest.assertEquals((String)"8.0", (String)"test", (String)this.profile.getProperty("test3"));
        RollbackTest.assertEquals((int)3, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        IProfile revertProfile = profileRegistry.getProfile(this.profile.getProfileId(), profileRegistry.listProfileTimestamps(this.profile.getProfileId())[1]);
        status = this.director.revert(this.profile, revertProfile, new ProvisioningContext(RollbackTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"10.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"11.0", (String)"test", (String)this.profile.getProperty("test1"));
        RollbackTest.assertEquals((String)"12.0", (String)"test", (String)this.profile.getProperty("test2"));
        RollbackTest.assertEquals((String)"13.0", null, (String)this.profile.getProperty("test3"));
    }

    public void testRollbackIUs() {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        RollbackTest.assertEquals((int)1, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request1 = new ProfileChangeRequest(this.profile);
        request1.addInstallableUnits(new IInstallableUnit[]{this.a1});
        request1.addInstallableUnits(new IInstallableUnit[]{this.b1});
        IStatus status = this.director.provision((IProfileChangeRequest)request1, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"1.0", (int)0, (int)status.getCode());
        IQueryResult profileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        RollbackTest.assertContains("2.0", profileIUs, this.a1);
        RollbackTest.assertContains("3.0", profileIUs, this.b1);
        RollbackTest.assertEquals((int)2, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.profile);
        request2.removeInstallableUnits(new IInstallableUnit[]{this.a1});
        request2.addInstallableUnits(new IInstallableUnit[]{this.c1});
        status = this.director.provision((IProfileChangeRequest)request2, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"5.0", (int)0, (int)status.getCode());
        profileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        RollbackTest.assertNotContains("6.0", profileIUs, this.a1);
        RollbackTest.assertContains("7.0", profileIUs, this.b1);
        RollbackTest.assertContains("8.0", profileIUs, this.c1);
        RollbackTest.assertEquals((int)3, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        IProfile revertProfile = profileRegistry.getProfile(this.profile.getProfileId(), profileRegistry.listProfileTimestamps(this.profile.getProfileId())[1]);
        status = this.director.revert(this.profile, revertProfile, new ProvisioningContext(RollbackTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"10.0", (int)0, (int)status.getCode());
        profileIUs = this.profile.query(QueryUtil.createIUAnyQuery(), null);
        RollbackTest.assertContains("11.0", profileIUs, this.a1);
        RollbackTest.assertContains("12.0", profileIUs, this.b1);
        RollbackTest.assertNotContains("13.0", profileIUs, this.c1);
    }

    public void testRollbackIUProfileProperties() {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        RollbackTest.assertEquals((int)1, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request1 = new ProfileChangeRequest(this.profile);
        request1.addInstallableUnits(new IInstallableUnit[]{this.a1});
        request1.setInstallableUnitProfileProperty(this.a1, "test1", "test");
        request1.setInstallableUnitProfileProperty(this.a1, "test2", "test");
        IStatus status = this.director.provision((IProfileChangeRequest)request1, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"1.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"2.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test1"));
        RollbackTest.assertEquals((String)"3.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((int)2, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.profile);
        request2.removeInstallableUnitProfileProperty(this.a1, "test1");
        request2.setInstallableUnitProfileProperty(this.a1, "test2", "bad");
        request2.setInstallableUnitProfileProperty(this.a1, "test3", "test");
        status = this.director.provision((IProfileChangeRequest)request2, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"5.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"6.0", null, (String)this.profile.getInstallableUnitProperty(this.a1, "test1"));
        RollbackTest.assertEquals((String)"7.0", (String)"bad", (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((String)"8.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test3"));
        RollbackTest.assertEquals((int)3, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        IProfile revertProfile = profileRegistry.getProfile(this.profile.getProfileId(), profileRegistry.listProfileTimestamps(this.profile.getProfileId())[1]);
        status = this.director.revert(this.profile, revertProfile, new ProvisioningContext(RollbackTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"10.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"11.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test1"));
        RollbackTest.assertEquals((String)"12.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((String)"13.0", null, (String)this.profile.getInstallableUnitProperty(this.a1, "test3"));
    }

    public void testRollbackDependentIUProfileProperties() {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        RollbackTest.assertEquals((int)1, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request1 = new ProfileChangeRequest(this.profile);
        request1.addInstallableUnits(new IInstallableUnit[]{this.d1});
        request1.setInstallableUnitProfileProperty(this.d1, "test1", "test");
        request1.setInstallableUnitProfileProperty(this.a1, "test2", "test");
        IStatus status = this.director.provision((IProfileChangeRequest)request1, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"1.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"2.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.d1, "test1"));
        RollbackTest.assertEquals((String)"3.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((int)2, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        ProfileChangeRequest request2 = new ProfileChangeRequest(this.profile);
        request2.removeInstallableUnits(new IInstallableUnit[]{this.d1});
        request2.addInstallableUnits(new IInstallableUnit[]{this.b1});
        request2.setInstallableUnitProfileProperty(this.b1, "test3", "test");
        status = this.director.provision((IProfileChangeRequest)request2, null, (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"5.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"6.0", null, (String)this.profile.getInstallableUnitProperty(this.d1, "test1"));
        RollbackTest.assertEquals((String)"7.0", null, (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((String)"8.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.b1, "test3"));
        RollbackTest.assertEquals((int)3, (int)profileRegistry.listProfileTimestamps(this.profile.getProfileId()).length);
        IProfile revertProfile = profileRegistry.getProfile(this.profile.getProfileId(), profileRegistry.listProfileTimestamps(this.profile.getProfileId())[1]);
        status = this.director.revert(this.profile, revertProfile, new ProvisioningContext(RollbackTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        RollbackTest.assertEquals((String)"10.0", (int)0, (int)status.getCode());
        RollbackTest.assertEquals((String)"11.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.d1, "test1"));
        RollbackTest.assertEquals((String)"12.0", (String)"test", (String)this.profile.getInstallableUnitProperty(this.a1, "test2"));
        RollbackTest.assertEquals((String)"13.0", null, (String)this.profile.getInstallableUnitProperty(this.b1, "test3"));
    }
}

