/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SingletonTest
extends AbstractProvisioningTest {
    IInstallableUnit f1;
    IInstallableUnit f1_1;
    IInstallableUnit f2;
    IInstallableUnit f2_1;
    IInstallableUnit junit38;
    IInstallableUnit junit40;
    IDirector director;
    IProfile profile;

    @Override
    protected void setUp() throws Exception {
        this.f1 = SingletonTest.createIU("f1", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.f1_1 = SingletonTest.createIU("f1", Version.createOSGi((int)1, (int)1, (int)0), true);
        this.f2 = SingletonTest.createIU("f2", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.f2_1 = SingletonTest.createIU("f2", Version.createOSGi((int)1, (int)0, (int)1));
        this.junit38 = SingletonTest.createIU("junit", Version.createOSGi((int)3, (int)8, (int)1));
        this.junit40 = SingletonTest.createIU("junit", Version.createOSGi((int)4, (int)0, (int)1));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1, this.f1_1, this.junit38, this.junit40, this.f2, this.f2_1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.director = SingletonTest.createDirector();
    }

    public void testMultipleVersionNonSingleton() {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.junit38, this.junit40});
        SingletonTest.assertEquals((int)0, (int)this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
    }

    public void testMultipleVersionSingleton() {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.f1, this.f1_1});
        SingletonTest.assertEquals((int)4, (int)this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
    }

    public void testMultipleVersionSingleton2() {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.f2, this.f2_1});
        SingletonTest.assertEquals((int)4, (int)this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
    }
}

