/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.directorywatcher;

import java.io.File;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.directorywatcher.AbstractDirectoryWatcherTest;
import org.eclipse.equinox.p2.tests.directorywatcher.TestRepositoryWatcher;

public class RepositoryListenerTest
extends AbstractDirectoryWatcherTest {
    public RepositoryListenerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(RepositoryListenerTest.class);
    }

    public static boolean isZipped(Collection<ITouchpointData> data) {
        if (data == null || data.size() == 0) {
            return false;
        }
        for (ITouchpointData td : data) {
            if (td.getInstruction("zipped") == null) continue;
            return true;
        }
        return false;
    }

    private void removeContents(File source, File target) {
        if (source.exists() && source.isDirectory() && target.exists() && target.isDirectory()) {
            File[] files = source.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    RepositoryListenerTest.delete(new File(target, files[i].getName()));
                }
                ++i;
            }
        }
    }

    public void testDirectoryWatcherListener() {
        File baseFolder = RepositoryListenerTest.getTestData("0.99", "/testData/directorywatcher1");
        File baseFolder2 = RepositoryListenerTest.getTestData("0.100", "/testData/directorywatcher2");
        File folder = this.getTempFolder();
        this.toRemove.add(folder);
        TestRepositoryWatcher watcher = TestRepositoryWatcher.createWatcher(folder);
        watcher.poll();
        RepositoryListenerTest.assertEquals((String)"1.0", (int)0, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"1.1", (int)0, (int)watcher.getArtifactKeys().length);
        RepositoryListenerTest.copy("2.0", baseFolder, folder);
        watcher.poll();
        IArtifactKey[] keys = watcher.getArtifactKeys();
        int i = 0;
        while (i < keys.length) {
            String file = watcher.getArtifactFile(keys[i]).getAbsolutePath();
            RepositoryListenerTest.assertTrue((String)("2.1." + file), (boolean)file.startsWith(folder.getAbsolutePath()));
            ++i;
        }
        RepositoryListenerTest.assertEquals((String)"3.0", (int)2, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"3.1", (int)2, (int)watcher.getArtifactKeys().length);
        RepositoryListenerTest.copy("4.99", baseFolder2, folder);
        watcher.poll();
        RepositoryListenerTest.assertEquals((String)"5.0", (int)3, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"5.1", (int)3, (int)watcher.getArtifactKeys().length);
        this.removeContents(baseFolder, folder);
        watcher.poll();
        RepositoryListenerTest.assertEquals((String)"6.0", (int)1, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"6.1", (int)1, (int)watcher.getArtifactKeys().length);
    }

    public void testBundleShape() {
        File folder = this.getTempFolder();
        this.toRemove.add(folder);
        TestRepositoryWatcher watcher = TestRepositoryWatcher.createWatcher(folder);
        File baseFolder = RepositoryListenerTest.getTestData("0.99", "/testData/directorywatcher1");
        RepositoryListenerTest.copy("2.0", baseFolder, folder);
        watcher.poll();
        IInstallableUnit jaredIU = null;
        IInstallableUnit directoryIU = null;
        IInstallableUnit[] ius = watcher.getInstallableUnits();
        RepositoryListenerTest.assertEquals((String)"3.0", (int)2, (int)ius.length);
        int i = 0;
        while (i < ius.length) {
            IInstallableUnit iu = ius[i];
            if (RepositoryListenerTest.isZipped(iu.getTouchpointData())) {
                RepositoryListenerTest.assertNull((String)"4.0", jaredIU);
                jaredIU = iu;
            } else {
                RepositoryListenerTest.assertNull((String)"5.0", directoryIU);
                directoryIU = iu;
            }
            ++i;
        }
        RepositoryListenerTest.assertTrue((String)"6.0", (directoryIU != null && jaredIU != null ? 1 : 0) != 0);
        IArtifactDescriptor jaredDescriptor = null;
        IArtifactDescriptor directoryDescriptor = null;
        IArtifactKey[] keys = watcher.getArtifactKeys();
        RepositoryListenerTest.assertEquals((String)"7.0", (int)2, (int)keys.length);
        int i2 = 0;
        while (i2 < keys.length) {
            IArtifactKey key = keys[i2];
            IArtifactDescriptor[] descriptors = watcher.getArtifactDescriptors(key);
            RepositoryListenerTest.assertEquals((String)"8.0", (int)1, (int)descriptors.length);
            SimpleArtifactDescriptor descriptor = (SimpleArtifactDescriptor)descriptors[0];
            String isFolder = descriptor.getRepositoryProperty("artifact.folder");
            if (Boolean.parseBoolean(isFolder)) {
                RepositoryListenerTest.assertNull((String)"9.0", directoryDescriptor);
                directoryDescriptor = descriptors[0];
            } else {
                RepositoryListenerTest.assertNull((String)"10.0", jaredDescriptor);
                jaredDescriptor = descriptors[0];
            }
            ++i2;
        }
        RepositoryListenerTest.assertTrue((String)"11.0", (jaredDescriptor != null && directoryDescriptor != null ? 1 : 0) != 0);
    }

    public void _testPluginXMLConversion() {
        File oldBundleJAR = RepositoryListenerTest.getTestData("0.1", "/testData/repositoryListener/oldBundleJAR.jar");
        File oldBundleDirectory = RepositoryListenerTest.getTestData("0.2", "/testData/repositoryListener/oldBundleDirectory");
        File oldBundleJARTwo = RepositoryListenerTest.getTestData("0.3", "/testData/repositoryListener/oldBundleJARTwo.jar");
        File oldBundleDirectoryTwo = RepositoryListenerTest.getTestData("0.4", "/testData/repositoryListener/oldBundleDirectoryTwo");
        File folder = this.getTempFolder();
        this.toRemove.add(folder);
        RepositoryListenerTest.copy("1.0", oldBundleJAR, new File(folder, oldBundleJAR.getName()));
        RepositoryListenerTest.copy("1.1", oldBundleJARTwo, new File(folder, oldBundleJARTwo.getName()));
        RepositoryListenerTest.copy("1.2", oldBundleDirectory, new File(folder, oldBundleDirectory.getName()));
        RepositoryListenerTest.copy("1.3", oldBundleDirectoryTwo, new File(folder, oldBundleDirectoryTwo.getName()));
        TestRepositoryWatcher watcher = TestRepositoryWatcher.createWatcher(folder);
        RepositoryListenerTest.assertEquals((String)"2.0", (int)0, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"2.1", (int)0, (int)watcher.getArtifactKeys().length);
        watcher.poll();
        RepositoryListenerTest.assertEquals((String)"3.0", (int)4, (int)watcher.getInstallableUnits().length);
        RepositoryListenerTest.assertEquals((String)"3.1", (int)4, (int)watcher.getArtifactKeys().length);
    }
}

