/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.ActionManager;
import org.eclipse.equinox.internal.p2.engine.InstructionParser;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class InstructionParserTest
extends AbstractProvisioningTest {
    public static final ITouchpointType TOUCHPOINT_TYPE = MetadataFactory.createTouchpointType((String)"InstructionParserTestTouchpoint", (Version)Version.create((String)"1.0"));

    public static Test suite() {
        return new TestSuite(InstructionParserTest.class);
    }

    public void testNullIUPhase() {
        try {
            new InstructionParser(null);
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testGoodAction() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction()", null), TOUCHPOINT_TYPE);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testGoodActionFullyQualified() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"instructionparsertest.goodAction()", null), null);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testBadActionFullyQualified() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"instructionparsertest.badAction()", null), null);
            ((ProvisioningAction)actions.get(0)).execute(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testGoodActionFromImport() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction()", (String)"instructionparsertest.goodAction"), null);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testGoodActionFromImportWithVersionRange() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction()", (String)"instructionparsertest.goodAction;version=[1.0,2.0)"), null);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testBadActionFromImport() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"badAction()", (String)"instructionparsertest.badAction"), null);
            ((ProvisioningAction)actions.get(0)).execute(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testGoodActions() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(); goodAction()", null), TOUCHPOINT_TYPE);
        InstructionParserTest.assertEquals((int)2, (int)actions.size());
    }

    public void testGoodParameter() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(a:1)", null), TOUCHPOINT_TYPE);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testGoodParameters() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(a:1, b:2)", null), TOUCHPOINT_TYPE);
        InstructionParserTest.assertEquals((int)1, (int)actions.size());
    }

    public void testBadParameter() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(badParameter)", null), TOUCHPOINT_TYPE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testGoodParamterBadParameter() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(a:1, badParameter)", null), TOUCHPOINT_TYPE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testBadAction() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"badAction", null), TOUCHPOINT_TYPE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testGoodActionBadAction() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"goodAction(); badAction()", null), TOUCHPOINT_TYPE);
            ((ProvisioningAction)actions.get(1)).execute(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public void testNoActionFound() {
        InstructionParser parser = new InstructionParser(new ActionManager());
        try {
            List actions = parser.parseActions(MetadataFactory.createTouchpointInstruction((String)"notfoundaction()", null), TOUCHPOINT_TYPE);
            ((ProvisioningAction)actions.get(0)).execute(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        InstructionParserTest.fail();
    }

    public static class InstructionParserTestTouchpoint
    extends Touchpoint {
        public ITouchpointType getTouchpointType() {
            return TOUCHPOINT_TYPE;
        }

        public String qualifyAction(String actionId) {
            return "instructionparsertest." + actionId;
        }
    }

    public static class TestAction
    extends ProvisioningAction {
        public IStatus execute(Map<String, Object> parameters) {
            return null;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return null;
        }
    }
}

