/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Configure;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Sizing;
import org.eclipse.equinox.internal.p2.engine.phases.Unconfigure;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PhaseApplicabilityTest
extends AbstractProvisioningTest {
    public PhaseApplicabilityTest(String name) {
        super(name);
    }

    public PhaseApplicabilityTest() {
        super("");
    }

    public void testCollectPhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Collect collectPhase = new Collect(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertFalse((boolean)collectPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertFalse((boolean)collectPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)collectPhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)collectPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }

    public void testSizingPhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Sizing sizingPhase = new Sizing(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertFalse((boolean)sizingPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertFalse((boolean)sizingPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)sizingPhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)sizingPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }

    public void testUnconfigurePhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Unconfigure unconfigurePhase = new Unconfigure(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertTrue((boolean)unconfigurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertTrue((boolean)unconfigurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertFalse((boolean)unconfigurePhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)unconfigurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }

    public void testUninstallPhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Uninstall uninstallPhase = new Uninstall(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertTrue((boolean)uninstallPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertFalse((boolean)uninstallPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertFalse((boolean)uninstallPhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)uninstallPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }

    public void testInstallPhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Install installPhase = new Install(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertFalse((boolean)installPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertFalse((boolean)installPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)installPhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)installPhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }

    public void testConfigurePhase() {
        IInstallableUnit iuXv1 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"1.0.0"));
        IInstallableUnit iuXv2 = PhaseApplicabilityTest.createIU("iuX", Version.create((String)"2.0.0"));
        Configure configurePhase = new Configure(1){

            protected boolean isApplicable(InstallableUnitOperand op) {
                return super.isApplicable(op);
            }
        };
        PhaseApplicabilityTest.assertFalse((boolean)configurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, null)));
        PhaseApplicabilityTest.assertTrue((boolean)configurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)configurePhase.isApplicable((Operand)new InstallableUnitOperand(null, iuXv1)));
        PhaseApplicabilityTest.assertTrue((boolean)configurePhase.isApplicable((Operand)new InstallableUnitOperand(iuXv1, iuXv2)));
    }
}

