/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.BeginOperationEvent;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.EngineSession;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseEvent;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.p2.repository.DownloadProgressEvent;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Test;

public class PhaseSetTest
extends AbstractProvisioningTest {
    PauseJob pause = null;

    public PhaseSetTest(String name) {
        super(name);
    }

    public PhaseSetTest() {
        super("");
    }

    public void testNullPhases() {
        try {
            new PhaseSet(null){};
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        PhaseSetTest.fail();
    }

    public void testNoTrustCheck() {
        IPhaseSet set1 = PhaseSetFactory.createDefaultPhaseSet();
        IPhaseSet set2 = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST});
        PhaseSetTest.assertTrue((String)"1.0", (!set1.equals(set2) ? 1 : 0) != 0);
    }

    public void testEmptyPhases() {
        IProfile profile = this.createProfile("PhaseSetTest");
        PhaseSet phaseSet = new PhaseSet(new Phase[0]){};
        InstallableUnitOperand op = new InstallableUnitOperand(this.createResolvedIU(PhaseSetTest.createIU("iu")), null);
        InstallableUnitOperand[] operands = new InstallableUnitOperand[]{op};
        ProvisioningContext context = new ProvisioningContext(PhaseSetTest.getAgent());
        MultiStatus result = phaseSet.perform(new EngineSession(null, profile, context), (Operand[])operands, (IProgressMonitor)new NullProgressMonitor());
        PhaseSetTest.assertTrue((boolean)result.isOK());
    }

    @Test
    public void testPauseNotRunningPhaseSet() {
        PhaseSet set = (PhaseSet)PhaseSetFactory.createDefaultPhaseSet();
        PhaseSetTest.assertFalse((String)"Can pause not running phaseset.", (boolean)set.pause());
    }

    @Test
    public void testResumeNotPausedPhaseSet() {
        PhaseSet set = (PhaseSet)PhaseSetFactory.createDefaultPhaseSet();
        PhaseSetTest.assertFalse((String)"Can resume not phaused phaseset.", (boolean)set.resume());
    }

    @Test
    public void testPauseAndResume() throws ProvisionException, OperationCanceledException, InterruptedException {
        URI repoLoc = PhaseSetTest.getTestData("Load test data.", "/testData/pausefeature").toURI();
        final PhaseSet phaseSet = (PhaseSet)PhaseSetFactory.createDefaultPhaseSet();
        this.pause = new PauseJob(this, "pause"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!phaseSet.pause()) {
                    return new Status(4, "org.eclipse.equinox.p2.test", "pause() failed.");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setPause(true);
                this.resume = new Job("resume"){

                    protected IStatus run(IProgressMonitor monitor1) {
                        pause.setPause(false);
                        if (!phaseSet.resume()) {
                            return new Status(4, "org.eclipse.equinox.p2.test", "resume() failed.");
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.resume.schedule(10000L);
                return Status.OK_STATUS;
            }
        };
        this.basicTest(repoLoc, phaseSet, this.pause, (IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)"org.eclipse.equinox.launcher"), 0, null);
        PhaseSetTest.assertTrue((String)"Pause job is failed.", (boolean)this.pause.getResult().isOK());
        this.pause.resume.join();
        PhaseSetTest.assertTrue((String)"Resume job is failed.", (boolean)this.pause.resume.getResult().isOK());
    }

    private void basicTest(URI repoURI, PhaseSet phaseSet, PauseJob pauseJob, IQuery<IInstallableUnit> query, int expectedCode, IProgressMonitor monitor) throws ProvisionException, InterruptedException {
        class ProvTestListener
        implements ProvisioningListener {
            boolean hasProvisioningEventAfterPaused = false;
            CountDownLatch latch = new CountDownLatch(1);
            boolean canStart = false;
            private final /* synthetic */ PauseJob val$pauseJob;

            ProvTestListener(PauseJob pauseJob) {
                this.val$pauseJob = pauseJob;
            }

            public void notify(EventObject o) {
                if (o instanceof BeginOperationEvent) {
                    this.canStart = true;
                }
                if (o instanceof RepositoryEvent || o instanceof ProfileEvent) {
                    return;
                }
                if (this.canStart && o instanceof DownloadProgressEvent) {
                    this.val$pauseJob.schedule();
                    this.canStart = false;
                    return;
                }
                if (o instanceof CommitOperationEvent || o instanceof RollbackOperationEvent) {
                    this.latch.countDown();
                    this.val$pauseJob.cancel();
                    return;
                }
                if (this.val$pauseJob.isPaused() && !(o instanceof PhaseEvent)) {
                    this.hasProvisioningEventAfterPaused = true;
                }
            }
        }
        ProvTestListener listener = new ProvTestListener(pauseJob);
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            PhaseSetTest.getMetadataRepositoryManager().loadRepository(repoURI, null);
            PhaseSetTest.getArtifactRepositoryManager().loadRepository(repoURI, null);
            this.doProvisioning(repoURI, phaseSet, query, expectedCode, monitor);
            listener.latch.await(15L, TimeUnit.SECONDS);
            PhaseSetTest.assertFalse((String)"Engine still do provisioning after pausing.", (boolean)listener.hasProvisioningEventAfterPaused);
            pauseJob.join();
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    private void doProvisioning(URI repoLoc, PhaseSet phaseSet, IQuery<IInstallableUnit> query, int expectedResult, IProgressMonitor monitor) throws ProvisionException {
        File testFolder = new File(System.getProperty("java.io.tmpdir"), "testProvisioning");
        PhaseSetTest.delete(testFolder);
        testFolder.mkdir();
        try {
            ProvisioningContext context = new ProvisioningContext(PhaseSetTest.getAgent());
            context.setArtifactRepositories(new URI[]{repoLoc});
            context.setMetadataRepositories(new URI[]{repoLoc});
            IEngine engine = this.getEngine();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("org.eclipse.equinox.p2.environments", "osgi.ws=gtk,osgi.arch=x86,osgi.os=linux");
            props.put("org.eclipse.equinox.p2.installFolder", testFolder.getAbsolutePath());
            IProfile profile = this.createProfile("test", props);
            IFileArtifactRepository artifactRepo = org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util.getBundlePoolRepository((IProvisioningAgent)PhaseSetTest.getAgent(), (IProfile)profile);
            artifactRepo.removeAll((IProgressMonitor)new NullProgressMonitor());
            ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)PhaseSetTest.getAgent(), (String)profile.getProfileId());
            IQueryResult toBeInstalledIUs = PhaseSetTest.getMetadataRepositoryManager().loadRepository(repoLoc, null).query(query, null);
            PhaseSetTest.assertFalse((String)"Test case has problem to find IU to be installed.", (boolean)toBeInstalledIUs.isEmpty());
            request.addAll((Collection)toBeInstalledIUs.toSet());
            IProvisioningPlan plan = this.getPlanner(PhaseSetTest.getAgent()).getProvisioningPlan((IProfileChangeRequest)request, context, null);
            PhaseSetTest.assertTrue((String)"Provisioning plan can't be resolved.", (boolean)plan.getStatus().isOK());
            IStatus status = engine.perform(plan, (IPhaseSet)phaseSet, monitor);
            PhaseSetTest.assertEquals((String)"The reture code of provisioning is not expected.", (int)expectedResult, (int)status.getSeverity());
        }
        finally {
            PhaseSetTest.delete(testFolder);
            this.getProfileRegistry().removeProfile("test");
            Util.getDownloadCacheRepo((IProvisioningAgent)PhaseSetTest.getAgent()).removeAll((IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Test
    public void testPauseAndResumeMoreThanOnce() throws ProvisionException, InterruptedException {
        URI repoLoc = PhaseSetTest.getTestData("Load test data.", "/testData/pausefeature").toURI();
        final PhaseSet phaseSet = (PhaseSet)PhaseSetFactory.createDefaultPhaseSet();
        this.pause = new PauseJob(this, "pause"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!phaseSet.pause()) {
                    return new Status(1, "org.eclipse.equinox.p2.test", "pause() failed.");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.setPause(true);
                if (this.resume == null) {
                    class ResumeJob
                    extends Job {
                        private PauseJob pauseJob;
                        private int count;
                        private final /* synthetic */ PhaseSet val$phaseSet;

                        public ResumeJob(String name, PauseJob pauseJob, PhaseSet phaseSet) {
                            this.val$phaseSet = phaseSet;
                            super(name);
                            this.count = 0;
                            this.pauseJob = pauseJob;
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            this.pauseJob.setPause(false);
                            if (!this.val$phaseSet.resume()) {
                                return new Status(1, "org.eclipse.equinox.p2.test", "resume() failed.");
                            }
                            if (this.count++ < 3) {
                                this.pauseJob.schedule(10000L);
                            }
                            return Status.OK_STATUS;
                        }
                    }
                    this.resume = new ResumeJob("resume", this, phaseSet);
                }
                this.resume.schedule(10000L);
                return Status.OK_STATUS;
            }
        };
        this.basicTest(repoLoc, phaseSet, this.pause, (IQuery<IInstallableUnit>)QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)"org.eclipse.equinox.executable.feature.group")), 0, null);
    }

    @Test
    public void testCancelPausedProvisioing() throws ProvisionException, InterruptedException {
        URI repoLoc = PhaseSetTest.getTestData("Load test data.", "/testData/pausefeature").toURI();
        final PhaseSet phaseSet = (PhaseSet)PhaseSetFactory.createDefaultPhaseSet();
        class ProvListener
        implements ProvisioningListener {
            boolean hasDownloadEvent = false;

            ProvListener() {
            }

            public void notify(EventObject o) {
                if (o instanceof DownloadProgressEvent) {
                    this.hasDownloadEvent = true;
                }
            }
        }
        final ProvListener listener = new ProvListener();
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            this.pause = new PauseJob(this, "pause"){
                {
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    while (!listener.hasDownloadEvent) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (!phaseSet.pause()) {
                        return new Status(4, "org.eclipse.equinox.p2.test", "pause() failed.");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    this.setPause(true);
                    return Status.OK_STATUS;
                }
            };
            this.basicTest(repoLoc, phaseSet, this.pause, (IQuery<IInstallableUnit>)QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)"org.eclipse.equinox.executable.feature.group")), 8, (IProgressMonitor)new NullProgressMonitor(){

                public boolean isCanceled() {
                    return PhaseSetTest.this.pause.isPaused();
                }
            });
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }

    abstract class PauseJob
    extends Job {
        private boolean isPaused;
        Job resume;

        public PauseJob(String name) {
            super(name);
            this.isPaused = false;
            this.resume = null;
        }

        public boolean isPaused() {
            return this.isPaused;
        }

        public void setPause(boolean paused) {
            this.isPaused = paused;
        }
    }
}

