/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class SimpleFileLockerApp {
    File lockFile;
    RandomAccessFile raf;
    FileLock lock;

    SimpleFileLockerApp(File lock) {
        this.lockFile = lock;
    }

    void create() {
        try {
            this.raf = new RandomAccessFile(this.lockFile, "rw");
            String lockMode = System.getProperty("osgi.locking");
            String string = lockMode = lockMode == null || lockMode.length() == 0 ? "java.nio" : lockMode;
            if ("java.io".equalsIgnoreCase(lockMode)) {
                this.raf.writeByte(0);
            } else {
                this.lock = this.raf.getChannel().tryLock(0L, 1L, false);
            }
        }
        catch (FileNotFoundException e) {
            this.remove();
            e.printStackTrace();
        }
        catch (IOException e) {
            this.remove();
            e.printStackTrace();
        }
    }

    void remove() {
        if (this.raf != null) {
            try {
                if (this.lock != null) {
                    this.lock.release();
                }
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.raf = null;
            this.lockFile.delete();
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Should have at least one arg - path.");
        }
        File lockDir = new File(args[0]);
        lockDir.mkdir();
        SimpleFileLockerApp extLock = new SimpleFileLockerApp(new File(lockDir, ".lock"));
        File waitUntil = new File(lockDir, ".done");
        waitUntil.delete();
        extLock.create();
        int MAX_RETRIES = args.length > 1 ? SimpleFileLockerApp.getMax(args[1]) : 20;
        int attempts = 0;
        while (attempts++ < MAX_RETRIES && !waitUntil.exists()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        extLock.remove();
        extLock = null;
        waitUntil.delete();
    }

    private static int getMax(String str) {
        int num = 20;
        try {
            num = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return num;
    }
}

