/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.lang.reflect.Field;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.engine.SurrogateProfileHandler;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.SharedInstallTests;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;

public class SurrogateProfileHandlerTest
extends AbstractProvisioningTest {
    private static final String PROFILE_NAME = "profile.SurrogateProfileHandlerTest";
    private IProfileRegistry registry;
    private SurrogateProfileHandler handler;

    public static Test suite() {
        return new TestSuite(SurrogateProfileHandlerTest.class);
    }

    private static void saveProfile(IProfileRegistry iRegistry, Profile profile) {
        SimpleProfileRegistry registry = (SimpleProfileRegistry)iRegistry;
        profile.setChanged(false);
        registry.lockProfile(profile);
        try {
            profile.setChanged(true);
            registry.updateProfile(profile);
        }
        finally {
            registry.unlockProfile((IProfile)profile);
            profile.setChanged(false);
        }
    }

    protected void getServices() {
        this.registry = this.getProfileRegistry();
    }

    private void ungetServices() {
        this.registry = null;
    }

    @Override
    protected void setUp() throws Exception {
        this.getServices();
        this.registry.removeProfile(PROFILE_NAME);
        this.handler = new SurrogateProfileHandler(SurrogateProfileHandlerTest.getAgent());
        Field registryField = SurrogateProfileHandler.class.getDeclaredField("profileRegistry");
        registryField.setAccessible(true);
        registryField.set(this.handler, this.registry);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.ungetServices();
    }

    public void testIsSurrogate() throws ProvisionException {
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        SurrogateProfileHandlerTest.assertFalse((boolean)this.handler.isSurrogate((IProfile)profile));
        IProfile surrogateProfile = this.handler.createProfile(PROFILE_NAME);
        SurrogateProfileHandlerTest.assertTrue((boolean)this.handler.isSurrogate(surrogateProfile));
    }

    public void testCreateProfile() throws ProvisionException {
        SurrogateProfileHandlerTest.assertNull((Object)this.handler.createProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        profile.addInstallableUnit(SurrogateProfileHandlerTest.createIU("test"));
        SurrogateProfileHandlerTest.saveProfile(this.registry, profile);
        IProfile surrogateProfile = this.handler.createProfile(PROFILE_NAME);
        SurrogateProfileHandlerTest.assertTrue((boolean)this.handler.isSurrogate(surrogateProfile));
        SurrogateProfileHandlerTest.assertEquals((int)1, (int)SurrogateProfileHandlerTest.queryResultSize(surrogateProfile.query(QueryUtil.createIUAnyQuery(), null)));
        SurrogateProfileHandlerTest.assertEquals((int)2, (int)SurrogateProfileHandlerTest.queryResultSize(surrogateProfile.available(QueryUtil.createIUAnyQuery(), null)));
    }

    public void testDropletsCanDetectFeatureGroup() throws ProvisionException {
        File fragTestData = SurrogateProfileHandlerTest.getTestData("0.1", "/testData/testRepos/foo-droplet");
        File fragDir = this.getTempFolder();
        SurrogateProfileHandlerTest.copy("Copying ..", fragTestData, fragDir);
        SharedInstallTests.setReadOnly(fragDir, true);
        AbstractSharedInstallTest.reallyReadOnly(fragDir, true);
        EngineActivator.EXTENDED = true;
        EngineActivator.EXTENSIONS = fragDir.getAbsolutePath();
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        SurrogateProfileHandlerTest.saveProfile(this.registry, profile);
        IProfile surrogateProfile = this.handler.createProfile(PROFILE_NAME);
        IQueryResult qRes = surrogateProfile.available(QueryUtil.createIUPropertyQuery((String)"org.eclipse.equinox.p2.type.group", (String)"true"), null);
        SurrogateProfileHandlerTest.assertFalse((boolean)qRes.isEmpty());
        AbstractSharedInstallTest.removeReallyReadOnly(fragDir, true);
        SharedInstallTests.setReadOnly(fragDir, false);
    }
}

