/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.equinox.internal.p2.engine.TouchpointManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.engine.InstructionParserTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class TouchpointManagerTest
extends AbstractProvisioningTest {
    public TouchpointManagerTest(String name) {
        super(name);
    }

    public TouchpointManagerTest() {
        super("");
    }

    public void testGetTouchpointByType() {
        TouchpointManager manager = new TouchpointManager();
        TouchpointManagerTest.assertNotNull((Object)manager.getTouchpoint(InstructionParserTest.TOUCHPOINT_TYPE));
    }

    public void testGetTouchpointByIdWithVersion() {
        TouchpointManager manager = new TouchpointManager();
        TouchpointManagerTest.assertNotNull((Object)manager.getTouchpoint("phaseTest", "1.0.0"));
    }

    public void testGetTouchpointByIdWithNullVersion() {
        TouchpointManager manager = new TouchpointManager();
        TouchpointManagerTest.assertNotNull((Object)manager.getTouchpoint("phaseTest", null));
    }

    public void DISABLED_testDynamicTouchpoint() throws MalformedURLException, BundleException, InterruptedException {
        TouchpointManager manager = new TouchpointManager();
        TouchpointManagerTest.assertNull((Object)manager.getTouchpoint("dummy", "1.0.0"));
        File dummy = TouchpointManagerTest.getTestData("0.1", "/testData/engineTest/dummy.touchpointAndAction_1.0.0.jar");
        Bundle bundle = TestActivator.getContext().installBundle(dummy.toURL().toString());
        bundle.start();
        int maxTries = 20;
        int current = 0;
        while (manager.getTouchpoint("dummy", "1.0.0") == null) {
            if (++current == maxTries) {
                TouchpointManagerTest.fail((String)"dummy touchpoint not added");
            }
            Thread.sleep(100L);
        }
        bundle.uninstall();
        current = 0;
        while (manager.getTouchpoint("dummy", "1.0.0") != null) {
            if (++current == maxTries) {
                TouchpointManagerTest.fail((String)"dummy touchpoint not removed");
            }
            Thread.sleep(100L);
        }
    }
}

