/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.util.HashMap;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DirectorTest
extends AbstractProvisioningTest {
    public void testInstallIU() {
        ServiceReference sr = TestActivator.context.getServiceReference(IDirector.class);
        if (sr == null) {
            throw new RuntimeException("Director service not available");
        }
        IDirector director = (IDirector)TestActivator.context.getService(sr);
        if (director == null) {
            throw new RuntimeException("Director could not be loaded");
        }
        IMetadataRepositoryManager mgr = (IMetadataRepositoryManager)DirectorTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (mgr == null) {
            throw new RuntimeException("Repository manager could not be loaded");
        }
        String autoInstall = System.getProperty("eclipse.p2.autoInstall");
        IQueryResult allJobs = mgr.query(QueryUtil.createIUQuery((String)autoInstall, (VersionRange)VersionRange.emptyRange), null);
        String installFolder = System.getProperty("org.eclipse.equinox.p2.installFolder");
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        if (profileRegistry == null) {
            throw new RuntimeException("Profile registry service not available");
        }
        boolean doUninstall = Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("eclipse.p2.doUninstall")));
        IProfile p = null;
        if (doUninstall) {
            p = profileRegistry.getProfile(installFolder);
            if (p == null) {
                throw new RuntimeException("Uninstalling from a nonexistent profile");
            }
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("org.eclipse.equinox.p2.installFolder", installFolder);
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)TestActivator.getContext(), EnvironmentInfo.class);
            if (info != null) {
                properties.put("org.eclipse.equinox.p2.environments", "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch());
            }
            p = this.createProfile(installFolder, properties);
        }
        IInstallableUnit[] allRoots = new IInstallableUnit[1];
        Status operationStatus = null;
        if (!allJobs.isEmpty()) {
            allRoots[0] = (IInstallableUnit)allJobs.iterator().next();
            ProfileChangeRequest request = new ProfileChangeRequest(p);
            if (!doUninstall) {
                request.addInstallableUnits(allRoots);
            } else {
                request.removeInstallableUnits(allRoots);
            }
            operationStatus = director.provision((IProfileChangeRequest)request, null, null);
        } else {
            operationStatus = new Status(1, "org.eclipse.equinox.internal.provisional.p2.director.test", "The installable unit '" + System.getProperty("eclipse.p2.autoInstall") + "' has not been found");
        }
        if (!operationStatus.isOK()) {
            DirectorTest.fail((String)"The installation has failed");
        }
        IInstallableUnit[] result = (IInstallableUnit[])p.query(QueryUtil.createIUQuery((String)allRoots[0].getId(), (VersionRange)VersionRange.emptyRange), null).toArray(IInstallableUnit.class);
        DirectorTest.assertEquals((int)result.length, (int)(!doUninstall ? 1 : 0));
        result = (IInstallableUnit[])p.query(QueryUtil.createIUQuery((String)"toolingdefault", (VersionRange)VersionRange.emptyRange), null).toArray(IInstallableUnit.class);
    }
}

