/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.installer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.installer.InstallDescriptionParser;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;

public class InstallDescriptionParserTest
extends AbstractProvisioningTest {
    protected void assertEquals(String message, InstallDescription expected, InstallDescription actual) {
        InstallDescriptionParserTest.assertEquals((String)message, (String)expected.getLauncherName(), (String)actual.getLauncherName());
        InstallDescriptionParserTest.assertEquals((String)message, (String)expected.getProductName(), (String)actual.getProductName());
        InstallDescriptionParserTest.assertEquals((String)message, (Object)expected.getAgentLocation(), (Object)actual.getAgentLocation());
        InstallDescriptionParserTest.assertEquals(message, expected.getArtifactRepositories(), actual.getArtifactRepositories());
        InstallDescriptionParserTest.assertEquals((String)message, (Object)expected.getBundleLocation(), (Object)actual.getBundleLocation());
        InstallDescriptionParserTest.assertEquals((String)message, (Object)expected.getInstallLocation(), (Object)actual.getInstallLocation());
        InstallDescriptionParserTest.assertEquals(message, expected.getMetadataRepositories(), actual.getMetadataRepositories());
        InstallDescriptionParserTest.assertEquals((String)message, (Object)expected.getProfileProperties(), (Object)actual.getProfileProperties());
        InstallDescriptionParserTest.assertEquals(message, expected.getRoots(), actual.getRoots());
        InstallDescriptionParserTest.assertEquals((String)message, (boolean)expected.isAutoStart(), (boolean)actual.isAutoStart());
    }

    private InstallDescription loadDescription(String filename) {
        URL location = null;
        try {
            location = TestData.getFile("installer", filename).toURL();
        }
        catch (IOException e) {
            InstallDescriptionParserTest.fail("0.99", e);
        }
        InstallDescription description = null;
        try {
            description = InstallDescriptionParser.createDescription((String)location.toExternalForm(), (SubMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
        catch (Exception e) {
            InstallDescriptionParserTest.fail("1.99", e);
        }
        return description;
    }

    public void testGetArrayFromString() {
        String[] elements = InstallDescriptionParser.getArrayFromString(null, (String)".");
        InstallDescriptionParserTest.assertEquals((String)"1.0", (int)0, (int)elements.length);
    }

    public void testLoadEmpty() {
        InstallDescription description = this.loadDescription("empty.properties");
        this.assertEquals("1.0", new InstallDescription(), description);
    }

    public void testLoadRelativeDescription() throws IOException, URISyntaxException {
        boolean existed = true;
        String installerInstallArea = System.getProperty("osgi.install.area");
        if (installerInstallArea == null) {
            throw new IllegalStateException("Install area is not specified.");
        }
        URI installerDescriptionURI = URIUtil.append((URI)URIUtil.fromString((String)installerInstallArea), (String)"installer.properties");
        File installerDescription = URIUtil.toFile((URI)installerDescriptionURI);
        if (!installerDescription.exists()) {
            existed = false;
            installerDescription.createNewFile();
        }
        try {
            try {
                InstallDescription description = InstallDescriptionParser.createDescription(null, (SubMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
                this.assertEquals("1.0", new InstallDescription(), description);
            }
            catch (Exception e) {
                InstallDescriptionParserTest.fail("0.99", e);
                if (!existed) {
                    installerDescription.delete();
                }
            }
        }
        finally {
            if (!existed) {
                installerDescription.delete();
            }
        }
    }

    public void testLoadGoodDescription() {
        InstallDescription description = this.loadDescription("good.properties");
        URI[] artifactRepositories = description.getArtifactRepositories();
        InstallDescriptionParserTest.assertEquals((String)"1.0", (int)2, (int)artifactRepositories.length);
        InstallDescriptionParserTest.assertEquals((String)"1.1", (String)"http://update.eclipse.org/eclipse/someUpdateSite/", (String)artifactRepositories[0].toString());
        InstallDescriptionParserTest.assertEquals((String)"1.1", (String)"http://update.eclipse.org/eclipse/someArtifacts/", (String)artifactRepositories[1].toString());
        URI[] metadataRepositories = description.getMetadataRepositories();
        InstallDescriptionParserTest.assertEquals((String)"1.2", (int)2, (int)metadataRepositories.length);
        InstallDescriptionParserTest.assertEquals((String)"1.3", (String)"http://update.eclipse.org/eclipse/someUpdateSite/", (String)metadataRepositories[0].toString());
        InstallDescriptionParserTest.assertEquals((String)"1.3", (String)"http://update.eclipse.org/eclipse/someMetadata/", (String)metadataRepositories[1].toString());
        InstallDescriptionParserTest.assertEquals((String)"1.4", (String)"testFlavor", (String)((String)description.getProfileProperties().get("eclipse.p2.flavor")));
        InstallDescriptionParserTest.assertEquals((String)"1.5", (String)"Test Profile Name", (String)description.getProductName());
        InstallDescriptionParserTest.assertEquals((String)"1.5", (String)"testLauncherName", (String)description.getLauncherName());
        IVersionedId[] roots = description.getRoots();
        InstallDescriptionParserTest.assertEquals((String)"1.7", (int)2, (int)roots.length);
        InstallDescriptionParserTest.assertEquals((String)"1.8", (String)"testRoot", (String)roots[0].getId());
        InstallDescriptionParserTest.assertEquals((String)"1.9", (Object)Version.create((String)"2.0"), (Object)roots[0].getVersion());
        InstallDescriptionParserTest.assertEquals((String)"1.8", (String)"anotherRoot", (String)roots[1].getId());
        InstallDescriptionParserTest.assertEquals((String)"1.9", (Object)Version.create((String)"1.0.1"), (Object)roots[1].getVersion());
        InstallDescriptionParserTest.assertTrue((String)"1.10", (!description.isAutoStart() ? 1 : 0) != 0);
        InstallDescriptionParserTest.assertEquals((String)"1.11", (Object)new Path("/tmp/agent/"), (Object)description.getAgentLocation());
        InstallDescriptionParserTest.assertEquals((String)"1.12", (Object)new Path("/tmp/bundles/"), (Object)description.getBundleLocation());
        InstallDescriptionParserTest.assertEquals((String)"1.13", (Object)new Path("/tmp/install/"), (Object)description.getInstallLocation());
    }

    public void testLoadBadDescription() {
        InstallDescription description = this.loadDescription("bad.properties");
        this.assertEquals("1.0", new InstallDescription(), description);
    }

    public void testLoadMissing() {
        try {
            InstallDescriptionParser.createDescription((String)new File("/does/not/exist/InstallDescriptionParserTest").toURL().toExternalForm(), (SubMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
            InstallDescriptionParserTest.fail((String)"1.0");
        }
        catch (MalformedURLException e) {
            InstallDescriptionParserTest.fail("0.99", e);
        }
        catch (URISyntaxException e) {
            InstallDescriptionParserTest.fail("0.98", e);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            InstallDescriptionParserTest.fail("0.97", e);
        }
    }

    public void testLoadMissingRelative() {
        try {
            InstallDescriptionParser.createDescription(null, (SubMonitor)SubMonitor.convert((IProgressMonitor)this.getMonitor()));
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        catch (Exception exception) {
            InstallDescriptionParserTest.fail((String)"0.9");
        }
        InstallDescriptionParserTest.fail((String)"1.0");
    }

    public void testLoadSDKDescription() {
        InstallDescription description = this.loadDescription("sdk-installer.properties");
        URI[] artifactRepositories = description.getArtifactRepositories();
        InstallDescriptionParserTest.assertEquals((String)"1.0", (int)1, (int)artifactRepositories.length);
        InstallDescriptionParserTest.assertEquals((String)"1.1", (String)"http://update.eclipse.org/eclipse/testUpdates/", (String)artifactRepositories[0].toString());
        URI[] metadataRepositories = description.getMetadataRepositories();
        InstallDescriptionParserTest.assertEquals((String)"1.2", (int)1, (int)metadataRepositories.length);
        InstallDescriptionParserTest.assertEquals((String)"1.3", (String)"http://update.eclipse.org/eclipse/testUpdates/", (String)metadataRepositories[0].toString());
        InstallDescriptionParserTest.assertEquals((String)"1.4", (String)"tooling", (String)((String)description.getProfileProperties().get("eclipse.p2.flavor")));
        InstallDescriptionParserTest.assertEquals((String)"1.5", (String)"Eclipse SDK", (String)description.getProductName());
        InstallDescriptionParserTest.assertEquals((String)"1.5", (String)"eclipse", (String)description.getLauncherName());
        IVersionedId[] roots = description.getRoots();
        InstallDescriptionParserTest.assertEquals((String)"1.7", (int)1, (int)roots.length);
        InstallDescriptionParserTest.assertEquals((String)"1.8", (String)"sdk", (String)roots[0].getId());
        InstallDescriptionParserTest.assertTrue((String)"1.9", (boolean)description.isAutoStart());
    }
}

