/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.jarprocessor;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.jarprocessor.PackStep;
import org.eclipse.equinox.internal.p2.jarprocessor.verifier.Verifier;
import org.eclipse.equinox.internal.p2.jarprocessor.verifier.VerifyStep;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessor;
import org.eclipse.internal.provisional.equinox.p2.jarprocessor.JarProcessorExecutor;

public class JarProcessorTests
extends AbstractProvisioningTest {
    public void testVerifyStep() throws Exception {
        if (!VerifyStep.canVerify()) {
            return;
        }
        File workingDir = this.getTestFolder("testVerifyStep");
        Verifier verifier = new Verifier(){

            public void verify(File workingDirectory, String[] input) {
                this.options = new JarProcessorExecutor.Options();
                this.options.verbose = false;
                this.options.pack = true;
                this.options.outputDir = workingDirectory.toString();
                this.options.input = workingDirectory;
                JarProcessor processor = new JarProcessor();
                processor.setWorkingDirectory(workingDirectory.getAbsolutePath());
                FileFilter filter = pathname -> {
                    String name = pathname.getName();
                    return pathname.isFile() && name.endsWith(".jar") && name.indexOf("source") == -1 && name.startsWith("org.eclipse.equinox.p2");
                };
                int i = 0;
                while (i < input.length) {
                    File inputFile = new File(input[i]);
                    if (inputFile.exists()) {
                        try {
                            this.process(inputFile, filter, true, processor, null);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        };
        String install = Platform.getInstallLocation().getURL().getPath();
        File plugins = new File(install, "plugins");
        PrintStream oldOut = System.out;
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (PrintStream newOut = new PrintStream(new FileOutputStream(workingDir + "/out.out"));){
                System.setOut(newOut);
                verifier.verify(workingDir, new String[]{plugins.getAbsolutePath()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }

    public void testPackUnpackVerify() throws Exception {
        if (!PackStep.canPack() || !VerifyStep.canVerify()) {
            return;
        }
        File workingDir = this.getTestFolder("testPackUnpackVerify");
        File input = new File(workingDir, "in");
        File packed = new File(workingDir, "packed");
        String install = Platform.getInstallLocation().getURL().getPath();
        File plugins = new File(install, "plugins");
        File[] files = plugins.listFiles(pathname -> {
            String name = pathname.getName();
            return pathname.isFile() && name.endsWith(".jar") && name.indexOf(".source") == -1 && (name.startsWith("org.eclipse.core.c") || name.startsWith("org.eclipse.core.r"));
        });
        input.mkdirs();
        int i = 0;
        while (i < files.length) {
            JarProcessorTests.copy("Setup input", files[i], new File(input, files[i].getName()));
            ++i;
        }
        JarProcessorExecutor.Options options = new JarProcessorExecutor.Options();
        options.pack = true;
        options.outputDir = packed.getAbsolutePath();
        options.input = input;
        PrintStream oldOut = System.out;
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (PrintStream newOut = new PrintStream(new FileOutputStream(workingDir + "/out.out"));){
                System.setOut(newOut);
                JarProcessorExecutor executor = new JarProcessorExecutor();
                executor.runJarProcessor(options);
                Verifier.main((String[])new String[]{"-dir", packed.getAbsolutePath(), packed.getAbsolutePath()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

