/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.util.Iterator;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MultipleIUAndFragmentTest
extends AbstractProvisioningTest {
    private static final String ID1 = "iu.1";
    private static final String ID2 = "iu.2";
    private static final String IDF1 = "iu.fragment.1";
    IInstallableUnit iu1;
    IInstallableUnit iu2;
    IInstallableUnit iu3;

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.iu1 = null;
        this.iu2 = null;
        this.iu3 = null;
    }

    public void testAttachment() {
        this.iu1 = MultipleIUAndFragmentTest.createEclipseIU(ID1);
        this.iu2 = MultipleIUAndFragmentTest.createIUWithDependencyOn(ID2, ID1);
        this.iu3 = MultipleIUAndFragmentTest.createBundleFragment(IDF1);
        ProfileChangeRequest req = new ProfileChangeRequest(this.createProfile(this.getName()));
        req.addInstallableUnits(new IInstallableUnit[]{this.iu1, this.iu2, this.iu3});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.iu1, this.iu2, this.iu3});
        IQueryable additions = MultipleIUAndFragmentTest.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null).getAdditions();
        Iterator iterator = additions.query(QueryUtil.createIUQuery((String)ID1), null).iterator();
        MultipleIUAndFragmentTest.assertTrue((String)"Solution contains IU iu.1", (boolean)iterator.hasNext());
        IInstallableUnit iu = (IInstallableUnit)iterator.next();
        MultipleIUAndFragmentTest.assertEquals((String)"Number of attached fragments to IU iu.1", (int)1, (int)iu.getFragments().size());
        MultipleIUAndFragmentTest.assertEquals((String)"Attached fragment to IU iu.1", (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        iterator = additions.query(QueryUtil.createIUQuery((String)ID2), null).iterator();
        MultipleIUAndFragmentTest.assertTrue((String)"Solution contains IU iu.2", (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        MultipleIUAndFragmentTest.assertEquals((String)"Number of attached fragments to IU iu.2", (int)1, (int)iu.getFragments().size());
        MultipleIUAndFragmentTest.assertEquals((String)"Attached fragment to IU iu.2", (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        iterator = additions.query(QueryUtil.createIUQuery((String)IDF1), null).iterator();
        MultipleIUAndFragmentTest.assertTrue((String)"Solution contains IU iu.fragment.1", (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        MultipleIUAndFragmentTest.assertEquals((String)"Number of attached fragments to IU iu.fragment.1", (int)0, (int)iu.getFragments().size());
    }

    private static IInstallableUnit createIUWithDependencyOn(String iuName, String dependencyOn) {
        IRequirement[] requires = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)dependencyOn, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true)};
        return MultipleIUAndFragmentTest.createEclipseIU(iuName, DEFAULT_VERSION, requires, NO_TP_DATA);
    }
}

