/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PersistFragment
extends AbstractProvisioningTest {
    public void testPersistFragmentIn35Repo() throws ProvisionException {
        IInstallableUnitFragment fragment = PersistFragment.createIUFragment(PersistFragment.createEclipseIU("A"), "MyHost", Version.createOSGi((int)1, (int)0, (int)0));
        File repoFolder = this.getTempFolder();
        IMetadataRepository repo = this.createMetadataRepository(repoFolder.toURI(), null);
        ArrayList<IInstallableUnitFragment> ius = new ArrayList<IInstallableUnitFragment>();
        ius.add(fragment);
        repo.addInstallableUnits(ius);
        PersistFragment.getMetadataRepositoryManager().removeRepository(repoFolder.toURI());
        IInstallableUnit iu = ((IInstallableUnit[])PersistFragment.getMetadataRepositoryManager().loadRepository(repoFolder.toURI(), null).query(QueryUtil.createIUQuery((String)"MyHost"), null).toArray(IInstallableUnit.class))[0];
        PersistFragment.assertEquals((int)1, (int)iu.getRequirements().size());
        PersistFragment.assertEquals(fragment.getHost().iterator().next(), iu.getRequirements().iterator().next());
        this.assertNoContents(new File(repoFolder, "content.xml"), new String[]{"generation='2'"});
    }

    public void testPersistFragmentIn36Repo() throws ProvisionException {
        String orExpression = "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && (pc.name == 'org.eclipse.mylyn34' || pc.name == 'org.eclipse.mylyn35'))";
        IExpression expr = ExpressionUtil.parse((String)orExpression);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        IRequirement orRequirement = MetadataFactory.createRequirement((IMatchExpression)matchExpression, null, (int)0, (int)1, (boolean)true);
        IInstallableUnitFragment fragment = PersistFragment.createIUFragment(PersistFragment.createEclipseIU("A"), "MyHost", Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{orRequirement}, null, null);
        File repoFolder = this.getTempFolder();
        IMetadataRepository repo = this.createMetadataRepository(repoFolder.toURI(), null);
        ArrayList<IInstallableUnitFragment> ius = new ArrayList<IInstallableUnitFragment>();
        ius.add(fragment);
        repo.addInstallableUnits(ius);
        PersistFragment.getMetadataRepositoryManager().removeRepository(repoFolder.toURI());
        IInstallableUnit iu = ((IInstallableUnit[])PersistFragment.getMetadataRepositoryManager().loadRepository(repoFolder.toURI(), null).query(QueryUtil.createIUQuery((String)"MyHost"), null).toArray(IInstallableUnit.class))[0];
        PersistFragment.assertEquals((int)1, (int)iu.getRequirements().size());
        PersistFragment.assertFalse((boolean)((IRequirement)fragment.getHost().iterator().next()).equals(iu.getRequirements().iterator().next()));
        this.assertContents(new File(repoFolder, "content.xml"), new String[]{"generation='2'"});
    }
}

