/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.junit.Assert;
import org.junit.Test;

public class RequirementParsingTest {
    @Test
    public void testIRequirementType() {
        String namespace = "osgi.ee";
        String ldap = "(&(osgi.ee=JavaSE)(version=1.7))";
        String match = "providedCapabilities.exists(pc | pc.namespace == '" + namespace + "' && pc.attributes ~= filter('" + ldap + "'))";
        IExpression expr = ExpressionUtil.parse((String)match);
        IMatchExpression matchExpr = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        IRequirement req = MetadataFactory.createRequirement((IMatchExpression)matchExpr, null, (int)0, (int)1, (boolean)false);
        Assert.assertFalse((boolean)(req instanceof IRequiredCapability));
    }

    @Test
    public void testIRquiredCapabilityType() {
        String namespace = "java.package";
        String name = "org.example";
        VersionRange range = VersionRange.create((String)"[1, 2)");
        IRequirement req = null;
        req = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, null, (int)0, (int)1, (boolean)false);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
        req = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, null, (int)0, (int)1, (boolean)false, null);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
        req = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, null, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
        req = MetadataFactory.createRequirement((String)namespace, (String)name, (VersionRange)range, null, (boolean)false, (boolean)false, (boolean)false);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
    }

    @Test
    public void testIRquiredCapabilityDetection() {
        String namespace = "java.package";
        String name = "org.example";
        VersionRange range = VersionRange.create((String)"[1, 2)");
        IMatchExpression matchExpr = RequiredCapability.createMatchExpressionFromRange((String)namespace, (String)name, (VersionRange)range);
        IRequirement req = null;
        req = MetadataFactory.createRequirement((IMatchExpression)matchExpr, null, (int)0, (int)1, (boolean)false);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
        req = MetadataFactory.createRequirement((IMatchExpression)matchExpr, null, (int)0, (int)1, (boolean)false, null);
        Assert.assertTrue((boolean)(req instanceof IRequiredCapability));
    }
}

