/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;

public class RequirementToString
extends TestCase {
    public void testRequirementWithEmptyRange() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"expectedName", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false);
        RequirementToString.assertEquals((String)"expectedNameSpace; expectedName 0.0.0", (String)req.toString());
    }

    public void testStandardRequirement() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"expectedName", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        RequirementToString.assertEquals((String)"expectedNameSpace; expectedName [1.0.0,2.0.0)", (String)req.toString());
    }

    public void testPropertiesRequirement() {
        IRequirement req = MetadataFactory.createRequirement((String)"expectedNameSpace", (String)"(key=val)", null, (int)1, (int)1, (boolean)true);
        RequirementToString.assertEquals((String)"expectedNameSpace; (key=val)", (String)req.toString());
    }

    public void testFancyRequirement() {
        Object[] expressionParameters = new Object[]{"expectedId1", "expectedVersion1", "expectedId2", "expectedVersion2"};
        IMatchExpression iuMatcher = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)"(id == $0 && version == $1) || (id == $2 && version == $3)"), expressionParameters);
        IRequirement req = MetadataFactory.createRequirement((IMatchExpression)iuMatcher, null, (int)1, (int)1, (boolean)true);
        RequirementToString.assertEquals((String)"id == $0 && version == $1 || id == $2 && version == $3 (expectedId1, expectedVersion1, expectedId2, expectedVersion2)", (String)req.toString().trim());
    }
}

