/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.expression;

import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ExpressionTest
extends AbstractProvisioningTest {
    private static final IExpressionFactory factory = ExpressionUtil.getFactory();

    protected void testExpression(String exprStr, Object expectedOutcome) throws Exception {
        IExpression expr = ExpressionUtil.parse((String)exprStr);
        ExpressionTest.assertEquals((Object)expr.evaluate(factory.createContext(new Object[0])), (Object)expectedOutcome);
    }

    protected void testMatch(String expr, boolean expectedOutcome) throws Exception {
        this.testExpression(expr, expectedOutcome);
    }

    public void testCompare() throws Exception {
        this.testMatch("'foo' == 'foo'", true);
        this.testMatch("'foo' == 'fooo'", false);
        this.testMatch("'foo' != 'foo'", false);
        this.testMatch("'foo' != 'fooo'", true);
        this.testMatch("2 < 1", false);
        this.testMatch("2 <= 1", false);
        this.testMatch("2 < 2", false);
        this.testMatch("2 <= 2", true);
        this.testMatch("2 < 3", true);
        this.testMatch("2 <= 3", true);
        this.testMatch("1 > 2", false);
        this.testMatch("1 >= 2", false);
        this.testMatch("2 > 2", false);
        this.testMatch("2 >= 2", true);
        this.testMatch("3 > 2", true);
        this.testMatch("3 >= 2", true);
    }

    public void testAutoCoerce() throws Exception {
        this.testMatch("'12' == 12", true);
        this.testMatch("'012' == 12", true);
        this.testMatch("'2' > '10'", true);
        this.testMatch("'2' > 10", false);
        this.testMatch("true == 'true'", true);
        this.testMatch("true == 'True'", true);
        this.testMatch("false == 'false'", true);
        this.testMatch("false == 'False'", true);
    }

    public void testLeftToRigthAssociativity() throws Exception {
        this.testMatch("2 < 10 == true", true);
        try {
            this.testMatch("true == 2 < 10", false);
            ExpressionTest.fail((String)"Auto coercion from boolean to integer succeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

