/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.net.URI;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.metadata.repository.AllServerTests;
import org.eclipse.equinox.p2.tests.metadata.repository.ServerBasedTestCase;

public class AuthTest
extends ServerBasedTestCase {
    private String PRIVATE_REPO;
    private String NEVER_REPO;
    private IMetadataRepositoryManager mgr;
    private URI repoLoc;
    protected String authTestFailMessage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.PRIVATE_REPO = String.valueOf(super.getBaseURL()) + "/private/mdr/composite/one";
        this.NEVER_REPO = String.valueOf(super.getBaseURL()) + "/proxy/never";
        this.mgr = (IMetadataRepositoryManager)AuthTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.mgr == null) {
            throw new RuntimeException("Repository manager could not be loaded");
        }
    }

    private void setUpRepo(String repo) throws Exception {
        this.repoLoc = new URI(repo);
        this.mgr.removeRepository(this.repoLoc);
        if (this.mgr.contains(this.repoLoc)) {
            throw new RuntimeException("Error - An earlier test did not leave a clean state - could not remove repo");
        }
    }

    @Override
    public void tearDown() throws Exception {
        AllServerTests.setServiceUI(null);
        super.tearDown();
        if (this.repoLoc != null) {
            this.mgr.removeRepository(this.repoLoc);
        }
    }

    public void testPrivateLoad() throws ProvisionException, Exception {
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        this.setUpRepo(this.PRIVATE_REPO);
        try {
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            AuthTest.fail((String)"The repository load was canceled - the UI auth service is probably not running");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuthTest.assertTrue((String)"Repository should have been added", (boolean)this.mgr.contains(this.repoLoc));
    }

    public void testNeverLoad() throws ProvisionException, Exception {
        AladdinNotSavedService service = new AladdinNotSavedService();
        AllServerTests.setServiceUI(service);
        this.setUpRepo(this.NEVER_REPO);
        try {
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            AuthTest.fail((String)"The repository load was canceled - the UI auth service is probably not running");
        }
        catch (ProvisionException e) {
            AuthTest.assertEquals((String)"Repository is expected to report failed authentication", (int)1007, (int)e.getStatus().getCode());
        }
        AuthTest.assertEquals((String)"There should have been N attempts", (int)(RepositoryPreferences.getLoginRetryCount() - 1), (int)service.counter);
        AuthTest.assertFalse((String)"Repository should not have been added", (boolean)this.mgr.contains(this.repoLoc));
    }

    public class AladdinNotSavedService
    extends UIServices {
        public int counter = 0;

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            ++this.counter;
            return new UIServices.AuthenticationInfo("Aladdin", "open sesame", false);
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            ++this.counter;
            AuthTest.assertEquals((String)"Aladdin", (String)previousInfo.getUserName());
            AuthTest.assertEquals((String)"open sesame", (String)previousInfo.getPassword());
            AuthTest.assertEquals((boolean)false, (boolean)previousInfo.saveResult());
            return previousInfo;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }
}

