/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MetadataRepositoryManagerExceptionsTest
extends AbstractProvisioningTest {
    protected IMetadataRepositoryManager manager;
    private final List<File> toDelete = new ArrayList<File>();

    public static Test suite() {
        return new TestSuite(MetadataRepositoryManagerExceptionsTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = (IMetadataRepositoryManager)MetadataRepositoryManagerExceptionsTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Iterator<File> it = this.toDelete.iterator();
        while (it.hasNext()) {
            MetadataRepositoryManagerExceptionsTest.delete(it.next());
        }
        this.toDelete.clear();
    }

    public void testFailedConnection() throws URISyntaxException {
        URI location = new URI("http://bogus.nowhere");
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        factory.setAgent(MetadataRepositoryManagerExceptionsTest.getAgent());
        try {
            factory.load(location, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerExceptionsTest.assertEquals((int)1000, (int)e.getStatus().getCode());
        }
        factory = new UpdateSiteMetadataRepositoryFactory();
        try {
            factory.load(location, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerExceptionsTest.assertEquals((int)1000, (int)e.getStatus().getCode());
        }
    }
}

