/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.repository.helpers.AbstractRepositoryManager;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.FailingMetadataRepositoryFactory;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestRepositoryListener;
import org.osgi.framework.BundleContext;

public class MetadataRepositoryManagerTest
extends AbstractProvisioningTest {
    protected IMetadataRepositoryManager manager;
    private final List<File> toDelete = new ArrayList<File>();

    public static Test suite() {
        return new TestSuite(MetadataRepositoryManagerTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = (IMetadataRepositoryManager)MetadataRepositoryManagerTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        FailingMetadataRepositoryFactory.FAIL = true;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Iterator<File> it = this.toDelete.iterator();
        while (it.hasNext()) {
            MetadataRepositoryManagerTest.delete(it.next());
        }
        this.toDelete.clear();
        FailingMetadataRepositoryFactory.FAIL = false;
    }

    public void testBasicAddRemove() {
        File tempFile = new File(System.getProperty("java.io.tmpdir"));
        URI location = tempFile.toURI();
        MetadataRepositoryManagerTest.assertTrue((!this.managerContains(location) ? 1 : 0) != 0);
        this.manager.addRepository(location);
        MetadataRepositoryManagerTest.assertTrue((boolean)this.managerContains(location));
        this.manager.removeRepository(location);
        MetadataRepositoryManagerTest.assertTrue((!this.managerContains(location) ? 1 : 0) != 0);
    }

    public void testContains() {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.removeRepository(location);
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (boolean)false, (boolean)this.manager.contains(location));
        this.manager.addRepository(location);
        MetadataRepositoryManagerTest.assertEquals((String)"1.1", (boolean)true, (boolean)this.manager.contains(location));
        this.manager.removeRepository(location);
        MetadataRepositoryManagerTest.assertEquals((String)"1.2", (boolean)false, (boolean)this.manager.contains(location));
    }

    public void testEnablement() {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (boolean)true, (boolean)this.manager.isEnabled(location));
        TestRepositoryListener listener = new TestRepositoryListener(location);
        this.getEventBus().addListener((ProvisioningListener)listener);
        this.manager.setEnabled(location, false);
        listener.waitForEvent();
        MetadataRepositoryManagerTest.assertEquals((String)"2.0", (boolean)false, (boolean)listener.lastEnablement);
        MetadataRepositoryManagerTest.assertEquals((String)"2.1", (boolean)false, (boolean)this.manager.isEnabled(location));
        listener.reset();
        this.manager.setEnabled(location, true);
        listener.waitForEvent();
        MetadataRepositoryManagerTest.assertEquals((String)"3.0", (boolean)true, (boolean)listener.lastEnablement);
        MetadataRepositoryManagerTest.assertEquals((String)"3.1", (boolean)true, (boolean)this.manager.isEnabled(location));
        listener.reset();
    }

    public void testFailedConnection() throws URISyntaxException {
        URI location = new URI("invalid://example");
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        factory.setAgent(MetadataRepositoryManagerTest.getAgent());
        try {
            factory.load(location, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.assertEquals((int)1000, (int)e.getStatus().getCode());
        }
        factory = new UpdateSiteMetadataRepositoryFactory();
        factory.setAgent(MetadataRepositoryManagerTest.getAgent());
        try {
            factory.load(location, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.assertEquals((int)1000, (int)e.getStatus().getCode());
        }
    }

    public void testEnablementOnAdd() {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        this.manager.setEnabled(location, false);
        TestRepositoryListener listener = new TestRepositoryListener(location);
        this.getEventBus().addListener((ProvisioningListener)listener);
        this.manager.addRepository(location);
        listener.waitForEvent();
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (boolean)true, (boolean)listener.lastEnablement);
        MetadataRepositoryManagerTest.assertEquals((String)"1.1", (boolean)true, (boolean)this.manager.isEnabled(location));
    }

    public void testGetKnownRepositories() throws ProvisionException {
        int nonSystemCount = this.manager.getKnownRepositories(2).length;
        int systemCount = this.manager.getKnownRepositories(1).length;
        int allCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)allCount, (int)(nonSystemCount + systemCount));
        File repoLocation = this.getTempLocation();
        IMetadataRepository testRepo = this.manager.createRepository(repoLocation.toURI(), "MetadataRepositoryManagerTest", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        int newNonSystemCount = this.manager.getKnownRepositories(2).length;
        int newSystemCount = this.manager.getKnownRepositories(1).length;
        int newAllCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"2.0", (int)(nonSystemCount + 1), (int)newNonSystemCount);
        MetadataRepositoryManagerTest.assertEquals((String)"2.1", (int)systemCount, (int)newSystemCount);
        MetadataRepositoryManagerTest.assertEquals((String)"2.2", (int)(allCount + 1), (int)newAllCount);
        testRepo.setProperty("p2.system", Boolean.TRUE.toString());
        newNonSystemCount = this.manager.getKnownRepositories(2).length;
        newSystemCount = this.manager.getKnownRepositories(1).length;
        newAllCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"3.0", (int)nonSystemCount, (int)newNonSystemCount);
        MetadataRepositoryManagerTest.assertEquals((String)"3.1", (int)(systemCount + 1), (int)newSystemCount);
        MetadataRepositoryManagerTest.assertEquals((String)"3.2", (int)(allCount + 1), (int)newAllCount);
        int disabledCount = this.manager.getKnownRepositories(8).length;
        allCount = newAllCount;
        this.manager.setEnabled(testRepo.getLocation(), false);
        int newDisabledCount = this.manager.getKnownRepositories(8).length;
        newAllCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"4.0", (int)(disabledCount + 1), (int)newDisabledCount);
        MetadataRepositoryManagerTest.assertEquals((String)"4.1", (int)(allCount - 1), (int)newAllCount);
        this.manager.loadRepository(testRepo.getLocation(), null);
        newDisabledCount = this.manager.getKnownRepositories(8).length;
        newAllCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"5.0", (int)(disabledCount + 1), (int)newDisabledCount);
        MetadataRepositoryManagerTest.assertEquals((String)"5.1", (int)(allCount - 1), (int)newAllCount);
        this.manager.setEnabled(testRepo.getLocation(), true);
        newDisabledCount = this.manager.getKnownRepositories(8).length;
        newAllCount = this.manager.getKnownRepositories(0).length;
        MetadataRepositoryManagerTest.assertEquals((String)"6.0", (int)disabledCount, (int)newDisabledCount);
        MetadataRepositoryManagerTest.assertEquals((String)"6.1", (int)allCount, (int)newAllCount);
    }

    public void testLoadContention() {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        ArrayList failures = new ArrayList();
        IMetadataRepositoryManager repoManager = MetadataRepositoryManagerTest.getMetadataRepositoryManager();
        class LoadJob
        extends Job {
            private final /* synthetic */ IMetadataRepositoryManager val$repoManager;
            private final /* synthetic */ URI val$location;
            private final /* synthetic */ List val$failures;

            LoadJob(IMetadataRepositoryManager iMetadataRepositoryManager, URI uRI, List list) {
                this.val$repoManager = iMetadataRepositoryManager;
                this.val$location = uRI;
                this.val$failures = list;
                super("");
            }

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < 100) {
                    try {
                        this.val$repoManager.loadRepository(this.val$location, null);
                    }
                    catch (Exception e) {
                        this.val$failures.add(e);
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }
        LoadJob job1 = new LoadJob(repoManager, location, failures);
        LoadJob job2 = new LoadJob(repoManager, location, failures);
        job1.schedule();
        job2.schedule();
        try {
            job1.join();
            job2.join();
        }
        catch (InterruptedException e) {
            MetadataRepositoryManagerTest.fail("4.99", e);
        }
        if (!failures.isEmpty()) {
            MetadataRepositoryManagerTest.fail("1.0", (Throwable)failures.iterator().next());
        }
    }

    public void testLoadMissingRepository() throws IOException {
        File tempFile = File.createTempFile("testLoadMissingArtifactRepository", null);
        tempFile.delete();
        URI location = tempFile.toURI();
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                this.manager.loadRepository(location, null);
                MetadataRepositoryManagerTest.fail((String)"1.0");
            }
            catch (ProvisionException e) {
                MetadataRepositoryManagerTest.assertEquals((String)"1.1", (int)4, (int)e.getStatus().getSeverity());
                MetadataRepositoryManagerTest.assertEquals((String)"1.2", (int)1000, (int)e.getStatus().getCode());
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    public void testLoadDisabledSystemRepository() throws ProvisionException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/goodNonSystem/");
        URI location = site.toURI();
        this.manager.removeRepository(location);
        this.manager.addRepository(location);
        this.manager.setEnabled(location, false);
        this.manager.setRepositoryProperty(location, "p2.system", String.valueOf(true));
        this.manager.loadRepository(location, this.getMonitor());
        Field field = AbstractRepositoryManager.class.getDeclaredField("repositories");
        field.setAccessible(true);
        field.set(this.manager, null);
        String system = this.manager.getRepositoryProperty(location, "p2.system");
        MetadataRepositoryManagerTest.assertEquals((String)"true", (String)system);
        MetadataRepositoryManagerTest.assertFalse((boolean)this.manager.isEnabled(location));
    }

    public void testLoadBrokenRepository() {
        File site = MetadataRepositoryManagerTest.getTestData("Repository", "/testData/metadataRepo/bad/");
        URI location = site.toURI();
        PrintStream err = System.err;
        try {
            try {
                System.setErr(new PrintStream(new StringBufferStream()));
                this.manager.loadRepository(location, null);
                MetadataRepositoryManagerTest.fail((String)"1.0");
            }
            catch (ProvisionException e) {
                MetadataRepositoryManagerTest.assertEquals((String)"1.1", (int)4, (int)e.getStatus().getSeverity());
                MetadataRepositoryManagerTest.assertEquals((String)"1.2", (int)1002, (int)e.getStatus().getCode());
                System.setErr(err);
            }
        }
        finally {
            System.setErr(err);
        }
    }

    public void testLoadBrokenSimpleRepositoryWithGoodUpdateSite() {
        File site = MetadataRepositoryManagerTest.getTestData("Repository", "/testData/metadataRepo/badSimpleGoodUpdateSite/");
        URI location = site.toURI();
        PrintStream err = System.err;
        try {
            try {
                System.setErr(new PrintStream(new StringBufferStream()));
                this.manager.loadRepository(location, null);
                MetadataRepositoryManagerTest.fail((String)"1.0");
            }
            catch (ProvisionException e) {
                MetadataRepositoryManagerTest.assertEquals((String)"1.1", (int)4, (int)e.getStatus().getSeverity());
                MetadataRepositoryManagerTest.assertEquals((String)"1.2", (int)1002, (int)e.getStatus().getCode());
                System.setErr(err);
            }
        }
        finally {
            System.setErr(err);
        }
    }

    public void testMetadataCachingLocalRepo() throws ProvisionException {
        File repoLocation = this.getTempLocation();
        IAgentLocation agentLocation = (IAgentLocation)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IAgentLocation.class);
        URI dataArea = agentLocation.getDataArea("org.eclipse.equinox.p2.metadata.repository/cache/");
        File dataAreaFile = URIUtil.toFile((URI)dataArea);
        File cacheFileXML = new File(dataAreaFile, "content" + repoLocation.hashCode() + ".xml");
        File cacheFileJAR = new File(dataAreaFile, "content" + repoLocation.hashCode() + ".jar");
        this.manager.createRepository(repoLocation.toURI(), "MetadataRepositoryCachingTest", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        this.manager.loadRepository(repoLocation.toURI(), null);
        MetadataRepositoryManagerTest.assertFalse((String)"Cache file was created.", (cacheFileXML.exists() || cacheFileJAR.exists() ? 1 : 0) != 0);
    }

    public void testMetadataCachingRemoteRepo() throws URISyntaxException, ProvisionException {
        URI repoLocation = new URI("http://download.eclipse.org/eclipse/updates/3.4milestones/");
        if (!this.repoAvailable(repoLocation)) {
            return;
        }
        IAgentLocation agentLocation = (IAgentLocation)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IAgentLocation.class);
        URI dataArea = agentLocation.getDataArea("org.eclipse.equinox.p2.metadata.repository/cache/");
        File dataAreaFile = URIUtil.toFile((URI)dataArea);
        File cacheFileXML = new File(dataAreaFile, "content" + repoLocation.hashCode() + ".xml");
        File cacheFileJAR = new File(dataAreaFile, "content" + repoLocation.hashCode() + ".jar");
        this.manager.loadRepository(repoLocation, null);
        MetadataRepositoryManagerTest.assertTrue((String)"Cache file was not created.", (cacheFileXML.exists() || cacheFileJAR.exists() ? 1 : 0) != 0);
        File cacheFile = cacheFileXML.exists() ? cacheFileXML : cacheFileJAR;
        cacheFile.setLastModified(0L);
        this.manager.removeRepository(repoLocation);
        this.manager.loadRepository(repoLocation, null);
        long lastModified = cacheFile.lastModified();
        MetadataRepositoryManagerTest.assertTrue((0L != lastModified ? 1 : 0) != 0);
        this.manager.loadRepository(repoLocation, null);
        MetadataRepositoryManagerTest.assertEquals((long)lastModified, (long)cacheFile.lastModified());
        cacheFile.delete();
    }

    public void testNickname() throws ProvisionException {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        String nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        MetadataRepositoryManagerTest.assertNull((Object)nick);
        nick = "Nick";
        this.manager.setRepositoryProperty(location, "p2.nickname", nick);
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        MetadataRepositoryManagerTest.assertEquals((String)"Nick", (String)nick);
        this.manager.loadRepository(location, this.getMonitor());
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        MetadataRepositoryManagerTest.assertEquals((String)"Nick", (String)nick);
        this.manager.removeRepository(location);
        this.manager.loadRepository(location, this.getMonitor());
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        MetadataRepositoryManagerTest.assertNull((Object)nick);
    }

    public void testPathWithSpaces() {
        File site = MetadataRepositoryManagerTest.getTestData("Repository", "/testData/metadataRepo/good with spaces/");
        URI location = site.toURI();
        try {
            IMetadataRepository repository = this.manager.loadRepository(location, this.getMonitor());
            IQueryResult result = repository.query(QueryUtil.createIUQuery((String)"test.bundle"), this.getMonitor());
            MetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)1, (int)MetadataRepositoryManagerTest.queryResultSize(result));
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.fail("=.99", e);
        }
    }

    public void testRelativePath() throws URISyntaxException {
        URI location = new URI("test");
        try {
            this.manager.loadRepository(location, this.getMonitor());
            MetadataRepositoryManagerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.fail("4.99", e);
        }
    }

    public void testRefresh() throws ProvisionException {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        this.manager.refreshRepository(location, this.getMonitor());
        MetadataRepositoryManagerTest.assertTrue((String)"1.0", (boolean)this.manager.contains(location));
        MetadataRepositoryManagerTest.assertTrue((String)"1.1", (boolean)this.manager.isEnabled(location));
        this.manager.setEnabled(location, false);
        this.manager.setRepositoryProperty(location, "p2.nickname", "MyNick");
        this.manager.refreshRepository(location, this.getMonitor());
        MetadataRepositoryManagerTest.assertTrue((String)"2.0", (boolean)this.manager.contains(location));
        MetadataRepositoryManagerTest.assertFalse((String)"2.1", (boolean)this.manager.isEnabled(location));
        MetadataRepositoryManagerTest.assertEquals((String)"2.2", (String)"MyNick", (String)this.manager.getRepositoryProperty(location, "p2.nickname"));
        this.manager.setRepositoryProperty(location, "p2.nickname", null);
    }

    public void testRepositoryReferenceCompatibility() throws URISyntaxException {
        ArrayList references;
        block5: {
            File site = MetadataRepositoryManagerTest.getTestData("Repository", "/testData/metadataRepo/unencodedreporeferences/");
            URI location = site.toURI();
            references = new ArrayList();
            SynchronousProvisioningListener referenceCollector = o -> {
                if (!(o instanceof RepositoryEvent)) {
                    return;
                }
                RepositoryEvent event = (RepositoryEvent)o;
                if (event.getKind() == 4) {
                    references.add(event.getRepositoryLocation());
                }
            };
            this.getEventBus().addListener((ProvisioningListener)referenceCollector);
            try {
                try {
                    this.manager.loadRepository(location, this.getMonitor());
                }
                catch (ProvisionException e) {
                    MetadataRepositoryManagerTest.fail("=.99", e);
                    this.getEventBus().removeListener((ProvisioningListener)referenceCollector);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.getEventBus().removeListener((ProvisioningListener)referenceCollector);
                throw throwable;
            }
            this.getEventBus().removeListener((ProvisioningListener)referenceCollector);
        }
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (int)4, (int)references.size());
        MetadataRepositoryManagerTest.assertTrue((String)"1.1", (boolean)references.contains(new URI("http://download.eclipse.org/url/with/spaces/a%20b")));
        MetadataRepositoryManagerTest.assertTrue((String)"1.2", (boolean)references.contains(new URI("file:/c:/tmp/url%20with%20spaces/")));
        MetadataRepositoryManagerTest.assertTrue((String)"1.3", (boolean)references.contains(new URI("http://download.eclipse.org/uri/with/spaces/a%20b")));
        MetadataRepositoryManagerTest.assertTrue((String)"1.4", (boolean)references.contains(new URI("file:/c:/tmp/uri%20with%20spaces/")));
    }

    public void testSetRepositoryProperty() {
        File site = MetadataRepositoryManagerTest.getTestData("Repositoy", "/testData/metadataRepo/good/");
        URI location = site.toURI();
        this.manager.removeRepository(location);
        this.manager.addRepository(location);
        this.manager.setRepositoryProperty(location, "name", "TestName");
        this.manager.setRepositoryProperty(location, "description", "TestDescription");
        this.manager.setRepositoryProperty(location, "p2.system", "false");
        MetadataRepositoryManagerTest.assertEquals((String)"1.0", (String)"TestName", (String)this.manager.getRepositoryProperty(location, "name"));
        MetadataRepositoryManagerTest.assertEquals((String)"1.1", (String)"TestDescription", (String)this.manager.getRepositoryProperty(location, "description"));
        MetadataRepositoryManagerTest.assertEquals((String)"1.2", (String)"false", (String)this.manager.getRepositoryProperty(location, "p2.system"));
        try {
            this.manager.loadRepository(location, this.getMonitor());
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.fail("1.99", e);
        }
        MetadataRepositoryManagerTest.assertEquals((String)"2.0", (String)"Good Test Repository", (String)this.manager.getRepositoryProperty(location, "name"));
        MetadataRepositoryManagerTest.assertEquals((String)"2.1", (String)"Good test repository description", (String)this.manager.getRepositoryProperty(location, "description"));
        MetadataRepositoryManagerTest.assertEquals((String)"2.2", (String)"true", (String)this.manager.getRepositoryProperty(location, "p2.system"));
    }

    public void testTrailingSlashes() {
        URI locationNoSlash;
        URI locationSlash;
        File site = MetadataRepositoryManagerTest.getTestData("Repository", "/testData/metadataRepo/good/");
        try {
            locationSlash = site.toURI();
            String locationString = locationSlash.toString();
            locationString = locationString.substring(0, locationString.length() - 1);
            locationNoSlash = new URI(locationString);
        }
        catch (URISyntaxException e) {
            MetadataRepositoryManagerTest.fail("0.99", e);
            return;
        }
        this.manager.addRepository(locationNoSlash);
        try {
            IMetadataRepository repoSlash = this.manager.loadRepository(locationSlash, null);
            IMetadataRepository repoNoSlash = this.manager.loadRepository(locationNoSlash, null);
            MetadataRepositoryManagerTest.assertTrue((String)"1.0", (repoNoSlash == repoSlash ? 1 : 0) != 0);
        }
        catch (ProvisionException e) {
            MetadataRepositoryManagerTest.fail("1.99", e);
        }
    }

    public void testReadableFilter() throws ProvisionException {
        File site = MetadataRepositoryManagerTest.getTestData("readable", "/testData/metadataRepo/badFilter/readable");
        IMetadataRepository loadRepository = this.manager.loadRepository(site.toURI(), null);
        MetadataRepositoryManagerTest.assertEquals((int)1, (int)loadRepository.query(QueryUtil.createIUAnyQuery(), null).toSet().size());
    }

    public void testUnreadableFailingFilter() {
        File site = MetadataRepositoryManagerTest.getTestData("unreadable", "/testData/metadataRepo/badFilter/unreadable");
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                this.manager.loadRepository(site.toURI(), null);
            }
            catch (ProvisionException provisionException) {
                System.setOut(out);
                return;
            }
        }
        finally {
            System.setOut(out);
        }
        MetadataRepositoryManagerTest.fail((String)"Unexpected code path, the unreadable repo should not have loaded");
    }

    private boolean repoAvailable(URI repoLocation) {
        try {
            repoLocation.toURL().openStream().close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private File getTempLocation() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, "MetadataRepositoryManagerTest");
        MetadataRepositoryManagerTest.delete(tempFile);
        MetadataRepositoryManagerTest.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        this.toDelete.add(tempFile);
        return tempFile;
    }

    public void testFailureAddRemove() {
        try {
            this.manager.addRepository(null);
            MetadataRepositoryManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {}
        try {
            this.manager.removeRepository(null);
            MetadataRepositoryManagerTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    private boolean managerContains(URI location) {
        URI[] locations;
        URI[] uRIArray = locations = this.manager.getKnownRepositories(0);
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location2 = uRIArray[n2];
            if (location2.equals(location)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

