/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.io.IUDeserializer;
import org.eclipse.equinox.p2.metadata.io.IUSerializer;

public class StandaloneSerializationTest
extends TestCase {
    public void testNothingToWrite() {
        try {
            File f = File.createTempFile(this.getName(), "iu");
            Throwable throwable = null;
            Object var3_7 = null;
            try (FileOutputStream os = new FileOutputStream(f);){
                new IUSerializer((OutputStream)os).write((Collection)Collections.EMPTY_LIST);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            StandaloneSerializationTest.assertTrue((f.length() > 0L ? 1 : 0) != 0);
            f.delete();
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
    }

    public void testNoContent() {
        Throwable throwable;
        File f = null;
        try {
            f = File.createTempFile(this.getName(), "iu");
            Throwable throwable2 = null;
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(f);){
                new IUSerializer((OutputStream)os).write((Collection)Collections.EMPTY_LIST);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        boolean exceptionRaised = false;
        try {
            throwable = null;
            Object var4_13 = null;
            try (FileInputStream is = new FileInputStream(f);){
                Collection ius = new IUDeserializer().read((InputStream)is);
                StandaloneSerializationTest.assertEquals((int)0, (int)ius.size());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException iOException) {
            exceptionRaised = true;
        }
        StandaloneSerializationTest.assertTrue((boolean)exceptionRaised);
        f.delete();
    }

    /*
     * Loose catch block
     */
    public void testWritingThenLoading() {
        Object var6_14;
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId("foo");
        iu.setVersion(Version.create((String)"1.0.0"));
        MetadataFactory.InstallableUnitDescription iu2 = new MetadataFactory.InstallableUnitDescription();
        iu2.setId("bar");
        iu2.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu));
        ius.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu2));
        File f = null;
        try {
            f = File.createTempFile(this.getName(), "iu");
            Throwable throwable = null;
            var6_14 = null;
            try (FileOutputStream os = new FileOutputStream(f);){
                new IUSerializer((OutputStream)os).write(ius);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        catch (IOException e) {
            StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
        }
        try {
            try {
                Throwable e = null;
                var6_14 = null;
                try (FileInputStream is = new FileInputStream(f);){
                    StandaloneSerializationTest.assertEquals((int)2, (int)new IUDeserializer().read((InputStream)is).size());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                f.delete();
            }
            catch (UnsupportedEncodingException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                f.delete();
            }
            catch (IOException e) {
                StandaloneSerializationTest.fail((String)("problem writing: " + e.getCause().getMessage()));
                f.delete();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            f.delete();
        }
    }
}

