/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.comparator.MD5ArtifactComparator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.util.NLS;
import org.junit.Assert;
import org.osgi.framework.BundleContext;

public class ArtifactMirrorApplicationTest
extends AbstractProvisioningTest {
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File sourceRepo2Location;
    protected File sourceRepo3Location;
    protected File sourceRepo4Location;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = ArtifactMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.sourceRepo2Location = ArtifactMirrorApplicationTest.getTestData("0.1", "/testData/mirror/mirrorSourceRepo2");
        this.sourceRepo3Location = ArtifactMirrorApplicationTest.getTestData("0.2", "/testData/mirror/mirrorSourceRepo3");
        this.sourceRepo4Location = ArtifactMirrorApplicationTest.getTestData("0.3", "/testData/mirror/mirrorSourceRepo4");
        this.destRepoLocation = this.getTestFolder(this.getName());
        ArtifactMirrorApplicationTest.delete(this.destRepoLocation);
    }

    @Override
    protected void tearDown() throws Exception {
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo2Location.toURI());
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo3Location.toURI());
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo4Location.toURI());
        ArtifactMirrorApplicationTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private StringBuffer runMirrorApplication(String message, String[] args) throws Exception {
        StringBuffer buffer = new StringBuffer();
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            PrintStream stream = new PrintStream(new StringBufferStream(buffer));
            System.setOut(stream);
            System.setErr(stream);
            MirrorApplication application = new MirrorApplication();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("metadataOrArtifacts", "artifacts");
            application.setInitializationData(null, null, map);
            application.initializeFromArguments(args);
            application.run(null);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
        return buffer;
    }

    private void basicRunMirrorApplication(String message, URL source, URL destination, boolean append) throws Exception {
        String[] args = new String[]{"-source", source.toExternalForm(), "-destination", destination.toExternalForm(), "-writeMode", append ? "" : "clean"};
        this.runMirrorApplication(message, args);
    }

    private void runMirrorApplication(String message, File source, File destination, boolean append) {
        try {
            this.basicRunMirrorApplication(message, source.toURL(), destination.toURL(), append);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail(message, e);
        }
    }

    private void artifactMirrorToEmpty(String message, boolean append) {
        this.runMirrorApplication(message, this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private void artifactMirrorToPopulatedWithFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo3Location, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToPopulatedWithPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, true);
        try {
            ArtifactMirrorApplicationTest.assertContains(String.valueOf(message) + ".5", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains(String.valueOf(message) + ".6", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".7", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".9", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private File artifactMirrorEmpty(String message, boolean append) {
        File emptyRepository = new File(this.getTempFolder(), ArtifactMirrorApplicationTest.getUniqueString());
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        ArtifactMirrorApplicationTest.delete(emptyRepository);
        try {
            ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(emptyRepository.toURI(), "Empty Repository", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail(String.valueOf(message) + ".1", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".0", emptyRepository, this.destRepoLocation, append);
        return emptyRepository;
    }

    private File artifactMirrorEmptyToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        return this.artifactMirrorEmpty(String.valueOf(message) + ".1", append);
    }

    private void mirrorWithError(boolean verbose) {
        File errorSourceLocation = ArtifactMirrorApplicationTest.getTestData("loading error data", "testData/mirror/mirrorErrorSourceRepo");
        try {
            String[] args = new String[]{"-source", errorSourceLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-ignoreErrors", verbose ? "-verbose" : ""};
            this.runMirrorApplication("Running with errored source", args);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Running mirror application with errored source failed", e);
        }
    }

    public void testArtifactMirrorToEmpty() {
        this.artifactMirrorToEmpty("1.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("1.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("1.2", e);
        }
    }

    public void testArtifactMirrorToEmptyWithClean() {
        this.artifactMirrorToEmpty("2.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("2.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("2.2", e);
        }
    }

    public void testArtifactMirrorToFullDuplicate() {
        this.artifactMirrorToFullDuplicate("3.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("3.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("3.2", e);
        }
    }

    public void testArtifactMirrorToFullDuplicateWithClean() {
        this.artifactMirrorToFullDuplicate("4.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("4.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("4.2", e);
        }
    }

    public void testArtifactMirrorToPopulated() {
        this.artifactMirrorToPopulated("5.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContains("5.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains("5.2", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertEquals((String)"5.3", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo2Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("5.4", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithClean() {
        this.artifactMirrorToPopulated("6.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("6.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("6.2", e);
        }
    }

    public void testArtifactMirrorToPartialDuplicate() {
        this.artifactMirrorToPartialDuplicate("7.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("7.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("7.2", e);
        }
    }

    public void testArtifactMirrorToPartialDuplicateWithClean() {
        this.artifactMirrorToPartialDuplicate("8.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("8.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("8.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithFullDuplicate() {
        this.artifactMirrorToPopulatedWithFullDuplicate("9.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("9.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("9.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithFullDuplicateWithClean() {
        this.artifactMirrorToPopulatedWithFullDuplicate("10.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("10.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("10.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithPartialDuplicate() {
        this.artifactMirrorToPopulatedWithPartialDuplicate("11.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContains("11.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains("11.2", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertEquals((String)"11.3", (int)(this.getArtifactKeyCount(this.sourceRepo2Location.toURI()) + this.getArtifactKeyCount(this.sourceRepo3Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("11.4", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithPartialDuplicateWithClean() {
        this.artifactMirrorToPopulatedWithPartialDuplicate("12.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("12.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("12.2", e);
        }
    }

    public void testArtifactMirrorFromInvalid() {
        File invalidRepository = new File(this.getTempFolder(), ArtifactMirrorApplicationTest.getUniqueString());
        ArtifactMirrorApplicationTest.delete(invalidRepository);
        try {
            this.basicRunMirrorApplication("13.1", invalidRepository.toURL(), this.destRepoLocation.toURL(), true);
            ArtifactMirrorApplicationTest.fail((String)"13.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("13.2", e);
        }
    }

    public void testArtifactMirrorToInvalid() {
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("14.1", this.sourceRepoLocation.toURL(), invalidDestRepository.toURL(), true);
            ArtifactMirrorApplicationTest.fail((String)"14.0 UnsupportedOperationException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("14.2", e);
        }
    }

    public void testArtifactMirrorBothInvalid() {
        File invalidRepository = new File(this.getTempFolder(), ArtifactMirrorApplicationTest.getUniqueString());
        ArtifactMirrorApplicationTest.delete(invalidRepository);
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("15.1", invalidRepository.toURL(), invalidDestRepository.toURL(), true);
            ArtifactMirrorApplicationTest.fail((String)"15.0 ProvisionException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("15.2", e);
        }
    }

    public void testArtifactMirrorEmptyToEmpty() {
        File emptyRepository = this.artifactMirrorEmpty("16.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("16.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("16.2", e);
        }
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        ArtifactMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulated() {
        File emptyRepository = this.artifactMirrorEmptyToPopulated("17.0", true);
        try {
            ArtifactMirrorApplicationTest.assertContains("17.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContentEquals("17.2", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("17.3", e);
        }
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        ArtifactMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulatedWithClean() {
        File emptyRepository = this.artifactMirrorEmptyToPopulated("18.0", false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("18.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("18.2", e);
        }
        ArtifactMirrorApplicationTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        ArtifactMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorSourceIsDestination() {
        this.runMirrorApplication("19.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("19.1", this.destRepoLocation, this.destRepoLocation, true);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("19.2", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("19.3", e);
        }
    }

    public void testArtifactMirrorDifferentVersions() {
        this.runMirrorApplication("20.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("20.1", this.sourceRepo4Location, this.destRepoLocation, true);
        try {
            ArtifactMirrorApplicationTest.assertContains("20.2", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains("20.3", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertEquals((String)"20.4", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo4Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("20.5", e);
        }
    }

    public void testArtifactMirrorNullSource() {
        String[] args = null;
        args = new String[]{"-destination", "file:" + this.destRepoLocation.getAbsolutePath()};
        try {
            this.runMirrorApplication("21.1", args);
            ArtifactMirrorApplicationTest.fail((String)"21.3 IllegalStateException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("21.2", e);
        }
    }

    public void testArtifactMirrorNullDestination() {
        String[] args = null;
        args = new String[]{"-source", "file:" + this.sourceRepoLocation.getAbsolutePath()};
        try {
            this.runMirrorApplication("22.1", args);
            ArtifactMirrorApplicationTest.fail((String)"22.3 IllegalStateException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("22.2", e);
        }
    }

    public void testArtifactMirrorNullBoth() {
        String[] args = new String[]{};
        try {
            this.runMirrorApplication("23.0", args);
            ArtifactMirrorApplicationTest.fail((String)"23.2 IllegalStateException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("23.1", e);
        }
    }

    public void testNewArtifactRepoProperties() {
        this.artifactMirrorToEmpty("24.0", true);
        try {
            IArtifactRepository sourceRepository = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
            IArtifactRepository destinationRepository = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            ArtifactMirrorApplicationTest.assertEquals((String)"24.1", (String)sourceRepository.getName(), (String)destinationRepository.getName());
            ArtifactMirrorApplicationTest.assertRepositoryProperties("24.2", sourceRepository.getProperties(), destinationRepository.getProperties());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("24.3", e);
        }
    }

    public void testExistingArtifactRepoProperties() {
        String name = "Destination Name";
        Map properties = null;
        try {
            properties = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties).getProperties();
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("25.0", e);
        }
        this.artifactMirrorToEmpty("25.2", true);
        try {
            IArtifactRepository repository = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            ArtifactMirrorApplicationTest.assertEquals((String)"25.3", (String)name, (String)repository.getName());
            ArtifactMirrorApplicationTest.assertRepositoryProperties("25.4", properties, repository.getProperties());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("25.5", e);
        }
    }

    public void testNewArtifactRepoWithNewName() {
        String name = "Bug 256909 test - new";
        try {
            String[] args = new String[]{"-source", this.sourceRepoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-destinationName", name};
            this.runMirrorApplication("Bug 256909 Test", args);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error running mirror application", e);
        }
        try {
            ArtifactMirrorApplicationTest.assertEquals((String)"Assert name was set correct", (String)name, (String)ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Cannot obtain destination", e);
        }
    }

    public void testExistingArtifactRepoWithNewName() {
        String oldName = "The original naem for Bug 256909 test - existing";
        String newName = "Bug 256909 test - existing";
        IArtifactRepository destinationRepo = null;
        try {
            destinationRepo = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), oldName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error creating repo at destination", e);
        }
        ArtifactMirrorApplicationTest.assertEquals((String)"Assert name is set correctly before mirror", (String)oldName, (String)destinationRepo.getName());
        try {
            String[] args = new String[]{"-source", this.sourceRepoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-destinationName", newName};
            this.runMirrorApplication("Bug 256909 Test", args);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error running mirror application", e);
        }
        try {
            ArtifactMirrorApplicationTest.assertEquals((String)"Assert name is set correctly after mirror", (String)newName, (String)ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error loading destination", e);
        }
    }

    public void testArtifactFileCopying() {
        File packedRepoLocation = ArtifactMirrorApplicationTest.getTestData("26.0", "/testData/mirror/mirrorPackedRepo");
        try {
            this.basicRunMirrorApplication("26.1", packedRepoLocation.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("26.3", e);
        }
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("26.4", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            this.assertEqualArtifacts("26.5", (SimpleArtifactRepository)ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null), (SimpleArtifactRepository)ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("26.6", e);
        }
    }

    public void testArtifactProcessingSteps() {
        File packedRepoLocation = ArtifactMirrorApplicationTest.getTestData("27.0", "/testData/mirror/mirrorPackedRepo");
        IArtifactRepository packedRepo = null;
        IArtifactRepository destinationRepo = null;
        try {
            packedRepo = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null);
            destinationRepo = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), "Test Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException provisionException) {
            ArtifactMirrorApplicationTest.fail((String)"");
        }
        IQueryResult keys = packedRepo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] srcDescriptors = packedRepo.getArtifactDescriptors(key);
            int j = 0;
            while (j < srcDescriptors.length) {
                if (srcDescriptors[j].getProperty("format") != null && srcDescriptors[j].getProperty("format").equals("packed")) {
                    ArtifactDescriptor newDescriptor = new ArtifactDescriptor(key);
                    OrderedProperties properties = new OrderedProperties();
                    properties.putAll(srcDescriptors[j].getProperties());
                    properties.remove("format");
                    newDescriptor.addProperties((Map)properties);
                    try {
                        Throwable throwable = null;
                        Object var12_16 = null;
                        try (OutputStream repositoryStream = destinationRepo.getOutputStream((IArtifactDescriptor)newDescriptor);){
                            if (repositoryStream == null) {
                                return;
                            }
                            packedRepo.getArtifact(srcDescriptors[j], repositoryStream, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (ProvisionException e) {
                        ArtifactMirrorApplicationTest.fail("27.1", e);
                    }
                    catch (IOException e) {
                        ArtifactMirrorApplicationTest.fail("27.2", e);
                    }
                    IArtifactDescriptor[] destDescriptors = destinationRepo.getArtifactDescriptors(key);
                    boolean canonicalFound = false;
                    int l = 0;
                    while (!canonicalFound && l < destDescriptors.length) {
                        if (destDescriptors[l].getProcessingSteps().length == 0) {
                            canonicalFound = true;
                        }
                        ++l;
                    }
                    if (!canonicalFound) {
                        ArtifactMirrorApplicationTest.fail((String)("27.3 no canonical found for " + key.toString()));
                    }
                    this.assertEqualArtifacts("27.3", (SimpleArtifactRepository)destinationRepo, (SimpleArtifactRepository)packedRepo);
                }
                ++j;
            }
        }
    }

    public void testMirrorCompressedSource() {
        File compressedSource = ArtifactMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedArtifactsXML = new File(compressedSource.getAbsoluteFile() + "/artifacts.jar");
        ArtifactMirrorApplicationTest.assertTrue((String)"1", (boolean)compressedArtifactsXML.exists());
        try {
            this.basicRunMirrorApplication("2", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("3", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("4", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        ArtifactMirrorApplicationTest.assertTrue((String)"5", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorCompressedSourcetoUncompressedDestination() {
        File compressedSource = ArtifactMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedArtifactsXML = new File(compressedSource.getAbsoluteFile() + "/artifacts.jar");
        ArtifactMirrorApplicationTest.assertTrue((String)"1", (boolean)compressedArtifactsXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("2", e);
        }
        ArtifactMirrorApplicationTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "artifacts.xml").exists());
        try {
            this.basicRunMirrorApplication("3", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("4", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("5", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        ArtifactMirrorApplicationTest.assertFalse((String)"6", (boolean)destArtifactsXML.exists());
        destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.xml");
        ArtifactMirrorApplicationTest.assertTrue((String)"7", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorUncompressedSourceToCompressedDestination() {
        File uncompressedSource = ArtifactMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorPackedRepo");
        File artifactsXML = new File(uncompressedSource.getAbsoluteFile() + "/artifacts.xml");
        ArtifactMirrorApplicationTest.assertTrue((String)"1", (boolean)artifactsXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("p2.compressed", "true");
            ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", property);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("2", e);
        }
        ArtifactMirrorApplicationTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "artifacts.jar").exists());
        try {
            this.basicRunMirrorApplication("3", uncompressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("4", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("5", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        ArtifactMirrorApplicationTest.assertTrue((String)"6", (boolean)destArtifactsXML.exists());
        destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.xml");
        ArtifactMirrorApplicationTest.assertFalse((String)"7", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorApplicationWithCompositeSource() {
        File repoLocation = new File(this.getTempFolder(), "CompositeArtifactMirrorTest");
        AbstractProvisioningTest.delete(repoLocation);
        IArtifactRepository repo = null;
        try {
            repo = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(repoLocation.toURI(), "artifact name", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException provisionException) {
            ArtifactMirrorApplicationTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeArtifactRepository)) {
            ArtifactMirrorApplicationTest.fail((String)"Repository is not a CompositeArtifactRepository");
        }
        File child1 = ArtifactMirrorApplicationTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        File child2 = ArtifactMirrorApplicationTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        ((CompositeArtifactRepository)repo).addChild(child1.toURI());
        ((CompositeArtifactRepository)repo).addChild(child2.toURI());
        this.runMirrorApplication("Mirroring from Composite Source", repoLocation, this.destRepoLocation, false);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("Verifying contents", repo, ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains("3", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertContains("4", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            ArtifactMirrorApplicationTest.assertEquals((String)"5", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo2Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Could not load destination", e);
        }
    }

    public void testIgnoreErrorsArguement() {
        this.destRepoLocation.mkdir();
        this.mirrorWithError(false);
        ArtifactMirrorApplicationTest.assertEquals((String)"Verifying correct number of Keys", (int)1, (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
    }

    public void testCompareUsingMD5Comparator() {
        ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        File artifact1 = ArtifactMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/artifacts.xml");
        File artifact2 = ArtifactMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/artifacts.xml");
        IArtifactDescriptor descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
        IArtifactDescriptor descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact2);
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
        Assert.assertNotEquals((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
        File repo1Location = this.getTestFolder(ArtifactMirrorApplicationTest.getUniqueString());
        File repo2Location = this.getTestFolder(ArtifactMirrorApplicationTest.getUniqueString());
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        try {
            repo1 = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo1.addDescriptor(descriptor1, (IProgressMonitor)new NullProgressMonitor());
            repo2 = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo2.addDescriptor(descriptor2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error creating repositories", e);
        }
        try {
            String[] args = new String[]{"-source", repo1Location.toURL().toExternalForm(), "-destination", repo2Location.toURL().toExternalForm(), "-verbose", "-compare", "-comparator", MD5ArtifactComparator.MD5_COMPARATOR_ID};
            this.runMirrorApplication("Running with duplicate descriptors with different md5 values", args);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Running mirror application with duplicate descriptors with different md5 values failed", e);
        }
        IArtifactDescriptor[] destDescriptors = repo2.getArtifactDescriptors(descriptor2.getArtifactKey());
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring destination has correct number of descriptors", (int)1, (int)destDescriptors.length);
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring proper descriptor exists in destination", (String)descriptor2.getProperty("download.md5"), (String)destDescriptors[0].getProperty("download.md5"));
        String msg = NLS.bind((String)Messages.warning_differentMD5, (Object[])new Object[]{URIUtil.toUnencodedString((URI)repo1.getLocation()), URIUtil.toUnencodedString((URI)repo2.getLocation()), descriptor1});
        try {
            ArtifactMirrorApplicationTest.assertLogContainsLine(TestActivator.getLogFile(), msg);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("error verifying output", e);
        }
    }

    public void testBaselineCompareUsingMD5Comparator() {
        ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        File artifact1 = ArtifactMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/content.xml");
        File artifact2 = ArtifactMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/content.xml");
        File repoLocation = this.getTestFolder(ArtifactMirrorApplicationTest.getUniqueString());
        File baselineLocation = this.getTestFolder(ArtifactMirrorApplicationTest.getUniqueString());
        File baselineBinaryDirectory = new File(baselineLocation, "binary");
        baselineBinaryDirectory.mkdir();
        File baselineContentLocation = new File(baselineBinaryDirectory, "testKeyId_1.2.3");
        AbstractProvisioningTest.copy("Copying File to baseline", artifact2, baselineContentLocation);
        IArtifactDescriptor descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
        IArtifactDescriptor descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)baselineContentLocation);
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
        Assert.assertNotEquals((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
        IArtifactRepository repo = null;
        IArtifactRepository baseline = null;
        try {
            repo = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(repoLocation.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo.addDescriptor(descriptor1, (IProgressMonitor)new NullProgressMonitor());
            baseline = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().createRepository(baselineLocation.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            baseline.addDescriptor(descriptor2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error creating repositories", e);
        }
        try {
            String[] args = new String[]{"-source", repoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-compareAgainst", baselineLocation.toURL().toExternalForm(), "-verbose", "-compare", "-comparator", MD5ArtifactComparator.MD5_COMPARATOR_ID};
            this.runMirrorApplication("Running with baseline compare", args);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Running mirror application with baseline compare", e);
        }
        IArtifactRepository destination = null;
        try {
            destination = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error loading destination", e);
        }
        IArtifactDescriptor[] destDescriptors = destination.getArtifactDescriptors(descriptor2.getArtifactKey());
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring destination has correct number of descriptors", (int)1, (int)destDescriptors.length);
        ArtifactMirrorApplicationTest.assertEquals((String)"Ensuring destination contains the descriptor from the baseline", (String)descriptor2.getProperty("download.md5"), (String)destDescriptors[0].getProperty("download.md5"));
        String msg = NLS.bind((String)Messages.warning_differentMD5, (Object[])new Object[]{URIUtil.toUnencodedString((URI)baseline.getLocation()), URIUtil.toUnencodedString((URI)repo.getLocation()), descriptor1});
        try {
            ArtifactMirrorApplicationTest.assertLogContainsLine(TestActivator.getLogFile(), msg);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("error verifying output", e);
        }
    }

    public void testDownloadRetry() {
        File retryRepoLoaction = new File(this.getTempFolder(), "259111 Repo");
        class TestRetryArtifactRepository
        extends SimpleArtifactRepository {
            public boolean firstAttempt;
            IArtifactRepository source;

            public TestRetryArtifactRepository(String repositoryName, URI location, URI srcLocation, Map<String, String> properties, IArtifactRepositoryManager manager) {
                super(ArtifactMirrorApplicationTest.getAgent(), repositoryName, location, properties);
                this.firstAttempt = true;
                try {
                    this.source = manager.loadRepository(srcLocation, null);
                }
                catch (ProvisionException e) {
                    ArtifactMirrorApplicationTest.fail("Unable to load source for wrapping", e);
                }
                manager.removeRepository(srcLocation);
            }

            public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
                return this.source.getArtifactDescriptors(key);
            }

            public Iterator<IArtifactKey> everything() {
                return ((SimpleArtifactRepository)this.source).everything();
            }

            public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
                if (this.firstAttempt) {
                    this.firstAttempt = false;
                    return new Status(4, "org.eclipse.equinox.p2.artifact.repository", 13, "Forcing Retry", (Throwable)new ProvisionException("Forcing retry"));
                }
                return this.source.getRawArtifact(descriptor, destination, monitor);
            }

            public synchronized boolean contains(IArtifactDescriptor descriptor) {
                return this.source.contains(descriptor);
            }

            public synchronized IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
                return this.source.query(query, monitor);
            }
        }
        TestRetryArtifactRepository retryRepo = new TestRetryArtifactRepository("Test Repo", retryRepoLoaction.toURI(), this.sourceRepoLocation.toURI(), null, ArtifactMirrorApplicationTest.getArtifactRepositoryManager());
        ((ArtifactRepositoryManager)ArtifactMirrorApplicationTest.getArtifactRepositoryManager()).addRepository((IArtifactRepository)retryRepo);
        try {
            String[] args = new String[]{"-source", URIUtil.toUnencodedString((URI)retryRepo.getLocation()), "-destination", this.destRepoLocation.toURL().toExternalForm()};
            this.runMirrorApplication("Forcing Retry", args);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("Error creating arguments", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error while running Mirror Application and forcing retry", e);
        }
        ArtifactMirrorApplicationTest.assertFalse((boolean)retryRepo.firstAttempt);
        try {
            ArtifactMirrorApplicationTest.assertContentEquals("Verifying content", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Failure while verifying destination", e);
        }
    }

    public void testErrorLoggingNoVerbose() {
        FrameworkLog log = (FrameworkLog)ServiceHelper.getService((BundleContext)Activator.getContext(), FrameworkLog.class);
        ArtifactMirrorApplicationTest.assertNotNull((String)"Assert log file is not null", (Object)log);
        ArtifactMirrorApplicationTest.assertTrue((String)"Clearing log file", (boolean)log.getFile().delete());
        this.mirrorWithError(false);
        try {
            String[] parts = new String[]{"java.io.FileNotFoundException: ", "helloworld_1.0.0.jar"};
            ArtifactMirrorApplicationTest.assertLogContainsLine(log.getFile(), parts);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("error verifying output", e);
        }
        this.artifactMirrorToFullDuplicate("Generating INFO entries", true);
        IArtifactRepository sourceRepository = null;
        try {
            sourceRepository = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error loading source repository for verification", e);
        }
        try {
            IQueryResult descriptors = sourceRepository.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
            IArtifactDescriptor descriptor = (IArtifactDescriptor)descriptors.iterator().next();
            String message = NLS.bind((String)org.eclipse.equinox.internal.p2.artifact.repository.Messages.mirror_alreadyExists, (Object)descriptor, (Object)this.destRepoLocation.toURI());
            ArtifactMirrorApplicationTest.assertLogDoesNotContainLine(log.getFile(), message);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error verifying log", e);
        }
    }

    public void testErrorLoggingWithVerbose() {
        FrameworkLog log = (FrameworkLog)ServiceHelper.getService((BundleContext)Activator.getContext(), FrameworkLog.class);
        ArtifactMirrorApplicationTest.assertNotNull((String)"Assert log file is not null", (Object)log);
        ArtifactMirrorApplicationTest.assertTrue((String)"Clearing log file", (boolean)log.getFile().delete());
        this.mirrorWithError(true);
        try {
            String[] parts = new String[]{"java.io.FileNotFoundException: ", "helloworld_1.0.0.jar"};
            ArtifactMirrorApplicationTest.assertLogContainsLine(log.getFile(), parts);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("error verifying output", e);
        }
        this.runMirrorApplication("Initializing Destiantion", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            String[] args = new String[]{"-source", this.sourceRepoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-verbose"};
            this.runMirrorApplication("Generating INO elements", args);
        }
        catch (MalformedURLException e) {
            ArtifactMirrorApplicationTest.fail("Error creating URLs", e);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error running mirror application to generate INFO items", e);
        }
        IArtifactRepository sourceRepository = null;
        try {
            sourceRepository = ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            ArtifactMirrorApplicationTest.fail("Error loading source repository for verification", e);
        }
        try {
            IQueryResult descriptors = sourceRepository.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
            IArtifactDescriptor descriptor = (IArtifactDescriptor)descriptors.iterator().next();
            String message = NLS.bind((String)org.eclipse.equinox.internal.p2.artifact.repository.Messages.mirror_alreadyExists, (Object)descriptor, (Object)this.destRepoLocation.toURI());
            ArtifactMirrorApplicationTest.assertLogContainsLine(log.getFile(), message);
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error verifying log", e);
        }
    }

    public void testArtifactMirrorNonURIDest() {
        String[] args = new String[]{"-destination", this.destRepoLocation.toString(), "-source", this.sourceRepoLocation.toString()};
        try {
            this.runMirrorApplication("Mirroring", args);
            ArtifactMirrorApplicationTest.assertContentEquals("2.1", ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), ArtifactMirrorApplicationTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (Exception e) {
            ArtifactMirrorApplicationTest.fail("Error mirroring", e);
        }
    }
}

