/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MetadataMirrorApplicationTest
extends AbstractProvisioningTest {
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File sourceRepo2Location;
    protected File sourceRepo3Location;
    protected File sourceRepo4Location;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = MetadataMirrorApplicationTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.sourceRepo2Location = MetadataMirrorApplicationTest.getTestData("0.1", "/testData/mirror/mirrorSourceRepo2");
        this.sourceRepo3Location = MetadataMirrorApplicationTest.getTestData("0.2", "/testData/mirror/mirrorSourceRepo3");
        this.sourceRepo4Location = MetadataMirrorApplicationTest.getTestData("0.3", "/testData/mirror/mirrorSourceRepo4");
        this.destRepoLocation = new File(this.getTempFolder(), "BasicMirrorApplicationTest");
        AbstractProvisioningTest.delete(this.destRepoLocation);
    }

    @Override
    protected void tearDown() throws Exception {
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo2Location.toURI());
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo3Location.toURI());
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(this.sourceRepo4Location.toURI());
        MetadataMirrorApplicationTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private void runMirrorApplication(String message, String[] args) throws Exception {
        MirrorApplication application = new MirrorApplication();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("metadataOrArtifacts", "metadata");
        application.setInitializationData(null, null, map);
        application.initializeFromArguments(args);
        application.run(null);
    }

    private void basicRunMirrorApplication(String message, URL source, URL destination, boolean append) throws Exception {
        String[] args = new String[]{"-source", source.toExternalForm(), "-destination", destination.toExternalForm(), "-writeMode", append ? "" : "clean"};
        this.runMirrorApplication(message, args);
    }

    private void runMirrorApplication(String message, File source, File destination, boolean append) {
        try {
            this.basicRunMirrorApplication(message, source.toURL(), destination.toURL(), append);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail(message, e);
        }
    }

    private int getNumUnique(IQueryResult<IInstallableUnit> c1, IQueryResult<IInstallableUnit> c2) {
        IInstallableUnit[] repo1 = (IInstallableUnit[])c1.toArray(IInstallableUnit.class);
        IInstallableUnit[] repo2 = (IInstallableUnit[])c2.toArray(IInstallableUnit.class);
        int numKeys = repo1.length + repo2.length;
        int i = 0;
        while (i < repo1.length) {
            int j = 0;
            while (j < repo2.length) {
                if (MetadataMirrorApplicationTest.isEqual(repo1[i], repo2[j])) {
                    --numKeys;
                }
                ++j;
            }
            ++i;
        }
        return numKeys;
    }

    private void metadataMirrorToEmpty(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulatedWithFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo3Location, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void metadataMirrorToPopulatedWithPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals(String.valueOf(message) + ".1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, true);
        try {
            MetadataMirrorApplicationTest.assertContains(String.valueOf(message) + ".5", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains(String.valueOf(message) + ".6", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".7", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".7", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private File metadataMirrorEmpty(String message, boolean append) {
        File emptyRepository = new File(this.getTempFolder(), MetadataMirrorApplicationTest.getUniqueString());
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
        AbstractProvisioningTest.delete(emptyRepository);
        try {
            MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(emptyRepository.toURI(), "Empty Repository", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail(String.valueOf(message) + ".1", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".0", emptyRepository, this.destRepoLocation, append);
        return emptyRepository;
    }

    private File metadataMirrorEmptyToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        return this.metadataMirrorEmpty(String.valueOf(message) + ".1", append);
    }

    public void testMetadataMirrorToEmpty() {
        this.metadataMirrorToEmpty("1.0", true);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("1.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("1.2", e);
        }
    }

    public void testMetadataMirrorToEmptyWithClean() {
        this.metadataMirrorToEmpty("2.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("2.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("2.2", e);
        }
    }

    public void testMetadataMirrorToFullDuplicate() {
        this.metadataMirrorToFullDuplicate("3.0", true);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("3.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("3.2", e);
        }
    }

    public void testMetadataMirrorToFullDuplicateWithClean() {
        this.metadataMirrorToFullDuplicate("4.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("4.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("4.2", e);
        }
    }

    public void testMetadataMirrorToPopulated() {
        this.metadataMirrorToPopulated("5.0", true);
        try {
            MetadataMirrorApplicationTest.assertContains("5.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains("5.2", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertEquals((String)"5.3", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)MetadataMirrorApplicationTest.queryResultSize(MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("5.4", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithClean() {
        this.metadataMirrorToPopulated("6.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("6.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("6.2", e);
        }
    }

    public void testMetadataMirrorToPartialDuplicate() {
        this.metadataMirrorToPartialDuplicate("7.0", true);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("7.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("7.2", e);
        }
    }

    public void testMetadataMirrorToPartialDuplicateWithClean() {
        this.metadataMirrorToPartialDuplicate("8.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("8.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("8.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithFullDuplicate() {
        this.metadataMirrorToPopulatedWithFullDuplicate("9.0", true);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("9.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("9.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithFullDuplicateWithClean() {
        this.metadataMirrorToPopulatedWithFullDuplicate("10.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("10.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("10.2", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithPartialDuplicate() {
        this.metadataMirrorToPopulatedWithPartialDuplicate("11.0", true);
        try {
            MetadataMirrorApplicationTest.assertContains("11.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains("11.2", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertEquals((String)"11.3", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)MetadataMirrorApplicationTest.queryResultSize(MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("11.4", e);
        }
    }

    public void testMetadataMirrorToPopulatedWithPartialDuplicateWithClean() {
        this.metadataMirrorToPopulatedWithPartialDuplicate("12.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("12.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("12.2", e);
        }
    }

    public void testMetadataMirrorFromInvalid() {
        File invalidRepository = new File(this.getTempFolder(), MetadataMirrorApplicationTest.getUniqueString());
        MetadataMirrorApplicationTest.delete(invalidRepository);
        try {
            this.basicRunMirrorApplication("13.1", invalidRepository.toURL(), this.destRepoLocation.toURL(), true);
            MetadataMirrorApplicationTest.fail((String)"13.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("13.2", e);
        }
    }

    public void testMetadataMirrorToInvalid() {
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("14.1", this.sourceRepoLocation.toURL(), invalidDestRepository.toURL(), true);
            MetadataMirrorApplicationTest.fail((String)"14.0 IllegalStateExpection not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("14.1", e);
        }
    }

    public void testMetadataMirrorBothInvalid() {
        File invalidRepository = new File(this.getTempFolder(), MetadataMirrorApplicationTest.getUniqueString());
        MetadataMirrorApplicationTest.delete(invalidRepository);
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("15.1", invalidRepository.toURL(), invalidDestRepository.toURL(), true);
            MetadataMirrorApplicationTest.fail((String)"15.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("15.2", e);
        }
    }

    public void testMetadataMirrorEmptyToEmpty() {
        File emptyRepository = this.metadataMirrorEmpty("19.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("16.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("16.2", e);
        }
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
        MetadataMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulated() {
        File emptyRepository = this.metadataMirrorEmptyToPopulated("17.0", true);
        try {
            MetadataMirrorApplicationTest.assertContains("17.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContentEquals("17.2", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("17.3", e);
        }
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
        MetadataMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulatedWithClean() {
        File emptyRepository = this.metadataMirrorEmptyToPopulated("18.0", false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("18.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(emptyRepository.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("18.2", e);
        }
        MetadataMirrorApplicationTest.getMetadataRepositoryManager().removeRepository(emptyRepository.toURI());
        MetadataMirrorApplicationTest.delete(emptyRepository);
    }

    public void testArtifactMirrorSourceIsDestination() {
        this.runMirrorApplication("19.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("19.1", this.destRepoLocation, this.destRepoLocation, true);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("19.2", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("19.3", e);
        }
    }

    public void testArtifactMirrorDifferentVersions() {
        this.runMirrorApplication("20.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("20.1", this.sourceRepo4Location, this.destRepoLocation, true);
        try {
            MetadataMirrorApplicationTest.assertContains("20.2", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains("20.3", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertEquals((String)"20.4", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)MetadataMirrorApplicationTest.queryResultSize(MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("20.5", e);
        }
    }

    public void testArtifactMirrorNullSource() {
        String[] args = null;
        args = new String[]{"-destination", this.destRepoLocation.toURI().toString()};
        try {
            this.runMirrorApplication("21.1", args);
            MetadataMirrorApplicationTest.fail((String)"21.3 IllegalStateException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("21.2", e);
        }
    }

    public void testArtifactMirrorNullDestination() {
        String[] args = null;
        args = new String[]{"-source", this.sourceRepoLocation.toURI().toString()};
        try {
            this.runMirrorApplication("22.1", args);
            MetadataMirrorApplicationTest.fail((String)"22.3 IllegalStateException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("22.2", e);
        }
    }

    public void testArtifactMirrorNullBoth() {
        String[] args = new String[]{};
        try {
            this.runMirrorApplication("23.0", args);
            MetadataMirrorApplicationTest.fail((String)"23.2 IllegalStateException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("23.1", e);
        }
    }

    public void testNewArtifactRepoProperties() {
        this.metadataMirrorToEmpty("24.0", true);
        try {
            IMetadataRepository sourceRepository = MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
            IMetadataRepository destinationRepository = MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            MetadataMirrorApplicationTest.assertEquals((String)"24.1", (String)sourceRepository.getName(), (String)destinationRepository.getName());
            MetadataMirrorApplicationTest.assertRepositoryProperties("24.2", sourceRepository.getProperties(), destinationRepository.getProperties());
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("24.3", e);
        }
    }

    public void testExistingArtifactRepoProperties() {
        String name = "Destination Name";
        Map properties = null;
        try {
            properties = MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties).getProperties();
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("25.0", e);
        }
        this.metadataMirrorToEmpty("25.2", true);
        try {
            IMetadataRepository repository = MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            MetadataMirrorApplicationTest.assertEquals((String)"25.3", (String)name, (String)repository.getName());
            MetadataMirrorApplicationTest.assertRepositoryProperties("25.4", properties, repository.getProperties());
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("25.5", e);
        }
    }

    public void testNewArtifactRepoWithNewName() {
        String name = "Bug 256909 test - new";
        try {
            String[] args = new String[]{"-source", this.sourceRepoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-destinationName", name};
            this.runMirrorApplication("Bug 256909 Test", args);
        }
        catch (MalformedURLException e) {
            MetadataMirrorApplicationTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("Error running mirror application", e);
        }
        try {
            MetadataMirrorApplicationTest.assertEquals((String)"Assert name was set correct", (String)name, (String)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("Cannot obtain destination", e);
        }
    }

    public void testExistingArtifactRepoWithNewName() {
        String oldName = "The original naem for Bug 256909 test - existing";
        String newName = "Bug 256909 test - existing";
        IMetadataRepository destinationRepo = null;
        try {
            destinationRepo = MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), oldName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("Error creating repo at destination", e);
        }
        MetadataMirrorApplicationTest.assertEquals((String)"Assert name is set correctly before mirror", (String)oldName, (String)destinationRepo.getName());
        try {
            String[] args = new String[]{"-source", this.sourceRepoLocation.toURL().toExternalForm(), "-destination", this.destRepoLocation.toURL().toExternalForm(), "-destinationName", newName};
            this.runMirrorApplication("Bug 256909 Test", args);
        }
        catch (MalformedURLException e) {
            MetadataMirrorApplicationTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("Error running mirror application", e);
        }
        try {
            MetadataMirrorApplicationTest.assertEquals((String)"Assert name is set correctly after mirror", (String)newName, (String)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("Error loading destination", e);
        }
    }

    public void testMirrorCompressedSource() {
        File compressedSource = MetadataMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedMetadataXML = new File(compressedSource.getAbsoluteFile() + "/content.jar");
        MetadataMirrorApplicationTest.assertTrue((String)"1", (boolean)compressedMetadataXML.exists());
        try {
            this.basicRunMirrorApplication("2", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            MetadataMirrorApplicationTest.fail("3", e);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("4", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        MetadataMirrorApplicationTest.assertTrue((String)"5", (boolean)destMetadataXML.exists());
    }

    public void testMirrorCompressedSourcetoUncompressedDestination() {
        File compressedSource = MetadataMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedMetadataXML = new File(compressedSource.getAbsoluteFile() + "/content.jar");
        MetadataMirrorApplicationTest.assertTrue((String)"1", (boolean)compressedMetadataXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("2", e);
        }
        try {
            this.basicRunMirrorApplication("3", compressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            MetadataMirrorApplicationTest.fail("4", e);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("5", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        MetadataMirrorApplicationTest.assertFalse((String)"6", (boolean)destMetadataXML.exists());
        destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.xml");
        MetadataMirrorApplicationTest.assertTrue((String)"7", (boolean)destMetadataXML.exists());
    }

    public void testMirrorUncompressedSourceToCompressedDestination() {
        File uncompressedSource = MetadataMirrorApplicationTest.getTestData("0", "/testData/mirror/mirrorSourceRepo3");
        File uncompressedContentXML = new File(uncompressedSource.getAbsoluteFile() + "/content.xml");
        MetadataMirrorApplicationTest.assertTrue((String)"1", (boolean)uncompressedContentXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("p2.compressed", "true");
            MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", property);
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("2", e);
        }
        MetadataMirrorApplicationTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "content.jar").exists());
        try {
            this.basicRunMirrorApplication("3", uncompressedSource.toURL(), this.destRepoLocation.toURL(), false);
        }
        catch (MalformedURLException e) {
            MetadataMirrorApplicationTest.fail("4", e);
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("5", e);
        }
        File destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.jar");
        MetadataMirrorApplicationTest.assertTrue((String)"6", (boolean)destMetadataXML.exists());
        destMetadataXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/content.xml");
        MetadataMirrorApplicationTest.assertFalse((String)"7", (boolean)destMetadataXML.exists());
    }

    public void testMirrorApplicationWithCompositeSource() {
        File repoLocation = new File(this.getTempFolder(), "CompositeMetadataMirrorTest");
        AbstractProvisioningTest.delete(repoLocation);
        IMetadataRepository repo = null;
        try {
            repo = MetadataMirrorApplicationTest.getMetadataRepositoryManager().createRepository(repoLocation.toURI(), "metadata name", "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
        }
        catch (ProvisionException provisionException) {
            MetadataMirrorApplicationTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeMetadataRepository)) {
            MetadataMirrorApplicationTest.fail((String)"Repository is not a CompositeMetadataRepository");
        }
        File child1 = MetadataMirrorApplicationTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        File child2 = MetadataMirrorApplicationTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        ((CompositeMetadataRepository)repo).addChild(child1.toURI());
        ((CompositeMetadataRepository)repo).addChild(child2.toURI());
        this.runMirrorApplication("Mirroring from Composite Source", repoLocation, this.destRepoLocation, false);
        try {
            MetadataMirrorApplicationTest.assertContentEquals("Verifying contents", repo, MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains("3", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertContains("4", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            MetadataMirrorApplicationTest.assertEquals((String)"5", (int)this.getNumUnique((IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null), (IQueryResult<IInstallableUnit>)MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)), (int)MetadataMirrorApplicationTest.queryResultSize(MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).query(QueryUtil.createIUAnyQuery(), null)));
        }
        catch (ProvisionException e) {
            MetadataMirrorApplicationTest.fail("Could not load destination", e);
        }
    }

    public void testMetadataMirrorNonURIDest() {
        String[] args = new String[]{"-destination", this.destRepoLocation.toString(), "-source", this.sourceRepoLocation.toString()};
        try {
            this.runMirrorApplication("Mirroring", args);
            MetadataMirrorApplicationTest.assertContentEquals("2.1", MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), MetadataMirrorApplicationTest.getMetadataRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (Exception e) {
            MetadataMirrorApplicationTest.fail("Error mirroring", e);
        }
    }
}

