/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatDTest
extends TestCase {
    private static char[] s_delim = new char[]{' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '{', '|', '}', '~'};

    public void testNumericWithDefaultSet() {
        Version v = null;
        String formatString = "format(ndn):";
        Integer one = 1;
        Integer two = 2;
        int i = 0;
        while (i < s_delim.length) {
            StringBuffer buf = new StringBuffer();
            buf.append(formatString);
            buf.append("1");
            buf.append(s_delim[i]);
            buf.append("2");
            v = Version.parseVersion((String)buf.toString());
            FormatDTest.assertNotNull((Object)v);
            FormatDTest.assertEquals((Object)one, (Object)v.getSegment(0));
            FormatDTest.assertEquals((Object)two, (Object)v.getSegment(1));
            ++i;
        }
    }

    public void testStringWithDefaultSet() {
        Version v = null;
        String formatString = "format(sds):";
        String one = "abc";
        String two = "def";
        int i = 0;
        while (i < s_delim.length) {
            StringBuffer buf = new StringBuffer();
            buf.append(formatString);
            buf.append(one);
            buf.append(s_delim[i]);
            buf.append(two);
            v = Version.parseVersion((String)buf.toString());
            FormatDTest.assertNotNull((Object)v);
            FormatDTest.assertEquals((Object)one, (Object)v.getSegment(0));
            FormatDTest.assertEquals((Object)two, (Object)v.getSegment(1));
            ++i;
        }
    }

    public void testAccepted() {
        Version v = Version.parseVersion((String)"format((d=[A-Z];n){3}):A1B22C333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)1, (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)22, (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[ABZ];S=[^ABZ];){3}):Aa1Bb22Zc333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)"a1", (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)"b22", (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)"c333", (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[A-Za-z];+n)+):Aa1Bb22Zc333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)1, (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)22, (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format((d=[\\\\[\\]];n)+):[1\\22]333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)1, (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)22, (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)333, (Object)v.getSegment(2));
    }

    public void testRejected() {
        Version v = null;
        v = Version.parseVersion((String)"format((d=[^.:];S=[a-z0-9];){3}):/a1;b22=c333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)"a1", (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)"b22", (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)"c333", (Object)v.getSegment(2));
    }

    public void testExplicit() {
        Version v = null;
        v = Version.parseVersion((String)"format('epoch='n';''major='n';''minor='n';'):epoch=1;major=22;minor=333;");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)1, (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)22, (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)333, (Object)v.getSegment(2));
        v = Version.parseVersion((String)"format('epoch='S=[^.];d'major='S=[^.];d'minor='S):epoch=a1ma.major=b22mi.minor=c333");
        FormatDTest.assertNotNull((Object)v);
        FormatDTest.assertEquals((Object)"a1ma", (Object)v.getSegment(0));
        FormatDTest.assertEquals((Object)"b22mi", (Object)v.getSegment(1));
        FormatDTest.assertEquals((Object)"c333", (Object)v.getSegment(2));
    }

    public void testCounted() {
        Version v1 = Version.parseVersion((String)"format(dddn):///1");
        Version v2 = Version.parseVersion((String)"format(d{3}n):///1");
        FormatDTest.assertNotNull((Object)v1);
        FormatDTest.assertNotNull((Object)v2);
        Integer one = 1;
        FormatDTest.assertEquals((Object)one, (Object)v1.getSegment(0));
        FormatDTest.assertEquals((Object)one, (Object)v2.getSegment(0));
    }

    public void testIllegalCharCount() {
        try {
            Version.parseVersion((String)"format(d={3};n):///1");
            FormatDTest.fail((String)"Uncaught error: char count can not be used with 'd'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatDTest.assertTrue((boolean)true);
        }
    }

    public void testIllegalAsPad() {
        try {
            Version.parseVersion((String)"format(nd=pm;n):1.0");
            FormatDTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatDTest.assertTrue((boolean)true);
        }
    }

    public void testIllegalWithDefault() {
        try {
            Version.parseVersion((String)"format(nd='a';n):1.0");
            FormatDTest.fail((String)"Uncaught error: 'd' can not have a default value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatDTest.assertTrue((boolean)true);
        }
    }

    public void testIllegalIgnore() {
        try {
            Version.parseVersion((String)"format(nd=!;n):1.0");
            FormatDTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatDTest.assertTrue((boolean)true);
        }
    }
}

