/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatNTest
extends TestCase {
    public void testNonNegative() {
        Version v = Version.parseVersion((String)"format(n):1");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n):0");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:0"), (Object)v);
        try {
            Version.parseVersion((String)"format(n):-1");
            FormatNTest.fail((String)"Uncaught exception: negative number in 'n' format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
    }

    public void testNegativeValues() {
        Version v = Version.parseVersion((String)"format(N):-1");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
        v = Version.parseVersion((String)"format(N):1");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(N):0");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:0"), (Object)v);
    }

    public void testLeadingZeros() {
        Version v = Version.parseVersion((String)"format(n):000001");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(N):-000001");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
    }

    public void testExact() {
        Version v = Version.parseVersion((String)"format(n={2};n={2};):1122");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:11.22"), (Object)v);
        v = Version.parseVersion((String)"format(N={4};N={1};):-1234");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:-123.4"), (Object)v);
        v = Version.parseVersion((String)"format(N={4};N={3};):-001234");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:-1.234"), (Object)v);
        try {
            v = Version.parseVersion((String)"format(n={2};.;n={2};):1.2");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
        try {
            v = Version.parseVersion((String)"format(n={2};.;n={2};):111.2222");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
    }

    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(n={2,};.n={2,};):111.22222");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:111.22222"), (Object)v);
        try {
            v = Version.parseVersion((String)"format(n={2,};.;n={2};):111.2");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
    }

    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(n={2,3};.n={2,3};):111.22");
        FormatNTest.assertNotNull((Object)v);
        FormatNTest.assertEquals((Object)Version.parseVersion((String)"raw:111.22"), (Object)v);
        try {
            v = Version.parseVersion((String)"format(n={2,3};.n={2,3};):111.2222");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
        try {
            v = Version.parseVersion((String)"format(n={2,3};.n={2,3};):1.222");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
    }

    public void testNIsGreedy() {
        try {
            Version.parseVersion((String)"format(nn):1010");
            FormatNTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatNTest.assertTrue((boolean)true);
        }
    }
}

