/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatQTest
extends TestCase {
    public void testQuoteFormatParsing() {
        Version aVer = Version.parseVersion((String)"raw:'a'");
        FormatQTest.assertNotNull((Object)aVer);
        Version v = null;
        v = Version.parseVersion((String)"format(q):'a'");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):\"a\"");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):=a=");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):#a#");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):!a!");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):|a|");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
    }

    public void testQUnbalancedQuoteR() {
        try {
            Version.parseVersion((String)"format(q):'a");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQUnbalancedQuoteL() {
        try {
            Version.parseVersion((String)"format(q):a'");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQuotedFormatPairsParsing() {
        Version aVer = Version.parseVersion((String)"raw:'a'");
        FormatQTest.assertNotNull((Object)aVer);
        Version v = null;
        v = Version.parseVersion((String)"format(q):(a)");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):<a>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):[a]");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
        v = Version.parseVersion((String)"format(q):{a}");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)aVer, (Object)v);
    }

    public void testQUnbalancedPair1() {
        try {
            Version.parseVersion((String)"format(q):(a");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):a)");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):(a(");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):)a)");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQUnbalancedPair2() {
        try {
            Version.parseVersion((String)"format(q):[a");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):a]");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):[a[");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):]a]");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQUnbalancedPair3() {
        try {
            Version.parseVersion((String)"format(q):<a");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):a>");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):<a<");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):>a>");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQUnbalancedPair4() {
        try {
            Version.parseVersion((String)"format(q):{a");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):a}");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):{a{");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):}a}");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testQUnbalancedPair5() {
        try {
            Version.parseVersion((String)"format(q):(a}");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):[a}");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):{a]");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q):<a)");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testExact() {
        Version v = Version.parseVersion((String)"format(q={4};q):<123a>\"bc456'def'\"");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2};q):<ab><c>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'ab'.'c'"), (Object)v);
        v = Version.parseVersion((String)"format(q={2};S):'12'3");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'"), (Object)v);
        v = Version.parseVersion((String)"format(q={4};q={1};q={3};):<123a>'b'(c45)");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.'b'.'c45'"), (Object)v);
        v = Version.parseVersion((String)"format(q={2};.q={1};qq={3};):<12>.<3>'456'<abc>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'12'.'3'.'456'.'abc'"), (Object)v);
        try {
            Version.parseVersion((String)"format(q={4};.q):123.(abc456)'def'");
            FormatQTest.fail((String)"Uncaught error: quoted string is longer than 4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q={4};q):<123>(abc456'def')");
            FormatQTest.fail((String)"Uncaught error: quoted string is shorter than 4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testAtLeast() {
        Version v = Version.parseVersion((String)"format(q={2,};):(123abc456'def')");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};):<123abc456'def'>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:\"123abc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};.q):(123a).(bc456'def')");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={2,};q):<123a>(bc456'def')");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123a'.\"bc456'def'\""), (Object)v);
        try {
            Version.parseVersion((String)"format(q={2,};.q):1.abc456'def'");
            FormatQTest.fail((String)"Uncaught error: first segment is shorter than 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q={2,};q):<1>(abc456'def')");
            FormatQTest.fail((String)"Uncaught error: firt segment is shorter than 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q={2,};.q={10,};):(12).(abc456'd')");
            FormatQTest.fail((String)"Uncaught error: last segment is shorter than 10");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q={2,};.q={10,};):<12>.abc456'd'");
            FormatQTest.fail((String)"Uncaught error: second segment is not quoted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }

    public void testAtMost() {
        Version v = Version.parseVersion((String)"format(q={1,3};q={1,2};q):<123><ab><c456'def'>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'ab'.\"c456'def'\""), (Object)v);
        v = Version.parseVersion((String)"format(q={1,4};q={1,4};q):<123><abc4><56'def'>");
        FormatQTest.assertNotNull((Object)v);
        FormatQTest.assertEquals((Object)Version.parseVersion((String)"raw:'123'.'abc4'.\"56'def'\""), (Object)v);
        try {
            Version.parseVersion((String)"format(q={2,3};q):<1><abc456'def'>");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(q={2,3};q={2,3};):<12><abc456'd'>");
            FormatQTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatQTest.assertTrue((boolean)true);
        }
    }
}

