/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class MultiplicityTest
extends TestCase {
    public void test01() {
        Version v = Version.parseVersion((String)"format(n?):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n[.n]):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(n.?n?):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n?):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n?):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        v = Version.parseVersion((String)"format([n]):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(s[n]):a");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n[.][n]):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format([n]):a");
            MultiplicityTest.fail((String)"Uncaught error: format([n]):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        v = Version.parseVersion((String)"format(n{0,1}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn{0,1}):a");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(n.?n{0,}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{0,1}):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n{0,1}):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void test1M() {
        Version v = Version.parseVersion((String)"format((nd?)+):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n+):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n+):");
            MultiplicityTest.fail((String)"Uncaught error: format(n+):");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n+):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n+):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        v = Version.parseVersion((String)"format((nd?){1,}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1,}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{1,}):");
            MultiplicityTest.fail((String)"Uncaught error: format(n{1,}):");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n{1,}):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n{1,}):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void test0M() {
        Version v = Version.parseVersion((String)"format((nd?)*):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n*):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn*):a");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        try {
            Version.parseVersion((String)"format(n*):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n*):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        v = Version.parseVersion((String)"format((nd?){0,}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{0,}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        v = Version.parseVersion((String)"format(sn{0,}):a");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{0,}):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n{0,}):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testExact() {
        Version v = Version.parseVersion((String)"format((nd?){3}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{1}):");
            MultiplicityTest.fail((String)"Uncaught error: format(n{1}):");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((nd?){3}):1.2");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){3}):1.2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n{1}):a");
            MultiplicityTest.fail((String)"Uncaught error: format(n{1}):a");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testAtLeast() {
        Version v = null;
        v = Version.parseVersion((String)"format((nd?){2,}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format((nd?){3,}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format(n{1,}):1");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{2,}):1");
            MultiplicityTest.fail((String)"Uncaught error: format(n{1,}):1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((nd?){3,}):1.2");
            MultiplicityTest.fail((String)"Uncaught error: format(n{3,1}):1.2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testAtMost() {
        Version v = null;
        v = Version.parseVersion((String)"format((nd?){2,3}):1.2.3");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2.3"), (Object)v);
        v = Version.parseVersion((String)"format((nd?){2,3}):1.2");
        MultiplicityTest.assertNotNull((Object)v);
        MultiplicityTest.assertEquals((Object)Version.parseVersion((String)"raw:1.2"), (Object)v);
        try {
            Version.parseVersion((String)"format(n{2,3}):1");
            MultiplicityTest.fail((String)"Uncaught error: format(n{2,3}):1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n{2,3}):1.2.3.4");
            MultiplicityTest.fail((String)"Uncaught error: format(n{2,3}):1.2.3.4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testZeroExact() {
        try {
            Version.parseVersion((String)"format(n{0}):");
            MultiplicityTest.fail((String)"Uncaught error: format(n{0}):");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(n{0,0}):");
            MultiplicityTest.fail((String)"Uncaught error: format(n{0,0}):");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testMinGreaterThanMax() {
        try {
            Version.parseVersion((String)"format((nd?){3,2}):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){3,2}):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedBraceR() {
        try {
            Version.parseVersion((String)"format((nd?){3,2):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){3,2):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testNegativeRange() {
        try {
            Version.parseVersion((String)"format((nd?){-1,2}):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){-1,2}):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((nd?){1,-2}):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){1,-2}):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }

    public void testStringRange() {
        try {
            Version.parseVersion((String)"format((nd?){a,2}):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){a,2}):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format((nd?){1,a}):1.2.3");
            MultiplicityTest.fail((String)"Uncaught error: format((nd?){1,a}):1.2.3");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MultiplicityTest.assertTrue((boolean)true);
        }
    }
}

