/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class OSGiRangeTest
extends VersionTesting {
    public void testSingleVersionRange() {
        VersionRange range = new VersionRange("[1.0.0, 1.0.0.-)");
        OSGiRangeTest.assertEquals((String)"0.1", (Object)Version.parseVersion((String)"1.0"), (Object)range.getMinimum());
        OSGiRangeTest.assertTrue((String)"0.9", (!range.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"1.0", (boolean)range.isIncluded(Version.parseVersion((String)"1")));
        OSGiRangeTest.assertTrue((String)"1.1", (boolean)range.isIncluded(Version.parseVersion((String)"1.0")));
        OSGiRangeTest.assertTrue((String)"1.2", (boolean)range.isIncluded(Version.parseVersion((String)"1.0.0")));
        OSGiRangeTest.assertTrue((String)"2.1", (!range.isIncluded(Version.parseVersion((String)"1.0.0.0")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"2.2", (!range.isIncluded(Version.parseVersion((String)"1.0.1")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"2.3", (!range.isIncluded(Version.parseVersion((String)"1.1")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"2.4", (!range.isIncluded(Version.parseVersion((String)"2")) ? 1 : 0) != 0);
    }

    public void testInvertedRange() {
        try {
            new VersionRange("[2.0.0, 1.0.0]");
            OSGiRangeTest.fail((String)"Inverted range is not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSGiRangeTest.assertTrue((boolean)true);
        }
    }

    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("1.0.0");
        OSGiRangeTest.assertTrue((String)"1.0", (!lowerBound.isIncluded(Version.parseVersion((String)"0.9")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"1.1", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.0")));
        OSGiRangeTest.assertTrue((String)"1.2", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        OSGiRangeTest.assertTrue((String)"1.3", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"999.999.999.foo")));
        OSGiRangeTest.assertTrue((String)"2.0", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"raw:M")));
        OSGiRangeTest.assertTrue((String)"2.1", (boolean)lowerBound.isIncluded(Version.parseVersion((String)"raw:2147483647.2147483647.2147483647.0")));
    }

    public void testLowerThan() {
        VersionRange upperBound = new VersionRange("[0,2.0)");
        OSGiRangeTest.assertTrue((String)"1.0", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.0")));
        OSGiRangeTest.assertTrue((String)"1.1", (boolean)upperBound.isIncluded(Version.parseVersion((String)"0.9")));
        OSGiRangeTest.assertTrue((String)"1.2", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.0")));
        OSGiRangeTest.assertTrue((String)"1.3", (boolean)upperBound.isIncluded(Version.parseVersion((String)"1.9.9.x")));
        OSGiRangeTest.assertTrue((String)"1.4", (!upperBound.isIncluded(Version.parseVersion((String)"2.0")) ? 1 : 0) != 0);
        OSGiRangeTest.assertTrue((String)"1.5", (!upperBound.isIncluded(Version.parseVersion((String)"2.1")) ? 1 : 0) != 0);
    }

    public void testRangeStrings() {
        VersionRange v = null;
        v = new VersionRange("1.0.0");
        OSGiRangeTest.assertEquals((String)"1.0.0", (String)v.toString());
        v = new VersionRange("[1.0.0,2.0.0]");
        OSGiRangeTest.assertEquals((String)"[1.0.0,2.0.0]", (String)v.toString());
        v = new VersionRange("(1.0.0,2.0.0]");
        OSGiRangeTest.assertEquals((String)"(1.0.0,2.0.0]", (String)v.toString());
        v = new VersionRange("[1.0.0,2.0.0)");
        OSGiRangeTest.assertEquals((String)"[1.0.0,2.0.0)", (String)v.toString());
        v = new VersionRange("(1.0.0,2.0.0)");
        OSGiRangeTest.assertEquals((String)"(1.0.0,2.0.0)", (String)v.toString());
        v = new VersionRange("1.0.0.abcdef");
        OSGiRangeTest.assertEquals((String)"1.0.0.abcdef", (String)v.toString());
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertEquals((String)"[1.0.0.abcdef,2.0.0.abcdef]", (String)v.toString());
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertEquals((String)"(1.0.0.abcdef,2.0.0.abcdef]", (String)v.toString());
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertEquals((String)"[1.0.0.abcdef,2.0.0.abcdef)", (String)v.toString());
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertEquals((String)"(1.0.0.abcdef,2.0.0.abcdef)", (String)v.toString());
    }

    public void testNullConstructor() {
        VersionRange range = new VersionRange(null);
        OSGiRangeTest.assertEquals((String)"1.0", (Object)range.getMinimum(), (Object)Version.emptyVersion);
        OSGiRangeTest.assertEquals((String)"1.1", (Object)range.getMaximum(), (Object)Version.MAX_VERSION);
        range = new VersionRange(null, true, null, true);
        OSGiRangeTest.assertEquals((String)"2.0", (Object)range.getMinimum(), (Object)Version.emptyVersion);
        OSGiRangeTest.assertEquals((String)"2.1", (Object)range.getMaximum(), (Object)Version.MAX_VERSION);
    }

    public void testSerialize() {
        VersionRange v = null;
        v = new VersionRange("1.0.0");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0,2.0.0]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0,2.0.0]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0,2.0.0)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0,2.0.0)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("1.0.0.abcdef");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef]");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("[1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertSerialized(v);
        v = new VersionRange("(1.0.0.abcdef,2.0.0.abcdef)");
        OSGiRangeTest.assertSerialized(v);
    }
}

