/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.internal.p2.metadata.VersionVector;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class RawVersionTest
extends VersionTesting {
    public void testBasicParsing() {
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.0"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.0.9"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.0.'r12345'"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.0.'r12345.hello'"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.m"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.M"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.M"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.0.-M"));
    }

    public void testEnumParsing() {
        try {
            Version.create((String)"raw:{blue,green,yellow}");
            RawVersionTest.fail((String)"Parsing succeeded but enum had no ordinal indicator");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            Version.create((String)"raw:{blue,^green,yellow}");
        }
        catch (IllegalArgumentException e) {
            RawVersionTest.fail((String)e.getMessage());
        }
    }

    public void testEnumCompare() {
        Version v2;
        Version v1 = Version.create((String)"raw:{blue,^green,yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)(v2 = Version.create((String)"raw:{^blue,green,yellow}"))) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{blue,green,^yellow}");
        v2 = Version.create((String)"raw:{blue,green,^yellow}");
        RawVersionTest.assertEquals((Object)v1, (Object)v2);
        v1 = Version.create((String)"raw:{blue,^green}");
        v2 = Version.create((String)"raw:{^blue,green,yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{blue,^green,yelllow}");
        v2 = Version.create((String)"raw:{green,^yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{^blue,green,yellow}");
        v2 = Version.create((String)"raw:{green,^yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{green,^yellow,blue}");
        v2 = Version.create((String)"raw:{^blue,green,yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v1 = Version.create((String)"raw:{green,^yellow,blue}");
        v2 = Version.create((String)"raw:{^blue,green,yellow,purple}");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
    }

    public void testEnumCompareWithOther() {
        Version v2;
        Version v1 = Version.create((String)"raw:{blue,^green,yellow}");
        RawVersionTest.assertTrue((v1.compareTo((Object)(v2 = Version.create((String)"raw:'green'"))) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:m");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:-M");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) > 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) < 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:0");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:<'foo'>");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
        v2 = Version.create((String)"raw:M");
        RawVersionTest.assertTrue((v1.compareTo((Object)v2) < 0 ? 1 : 0) != 0);
        RawVersionTest.assertTrue((v2.compareTo((Object)v1) > 0 ? 1 : 0) != 0);
    }

    public void testSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.'r12345'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.'r12345.hello'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:123456789.-1234567890");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:123456789.-1234567890");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'a'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:\"a\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'ab'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:\"'\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:'\"'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:{green,^blue,yellow}");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0.0.{dev,^alpha,beta}");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    public void testVersionString() {
        Version v = null;
        String s = null;
        s = "raw:1";
        v = Version.create((String)"raw:1");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0";
        v = Version.create((String)"raw:1.0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.0";
        v = Version.create((String)"raw:1.0.0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.0.9";
        v = Version.create((String)"raw:1.0.0.9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.0.'r12345'";
        v = Version.create((String)"raw:1.0.0.'r12345'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.0.'r12345.hello'";
        v = Version.create((String)"raw:1.0.0.'r12345.hello'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.m";
        v = Version.create((String)"raw:1.0.m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.M";
        v = Version.create((String)"raw:1.0.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.M";
        v = Version.create((String)"raw:1.0.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:1.0.-M");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1.0";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:0";
        v = Version.create((String)"raw:0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:0.1.2.3.4.5.6.7.8.9";
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9";
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:123456789.-1234567890";
        v = Version.create((String)"raw:123456789.-1234567890");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:123456789.-1234567890";
        v = Version.create((String)"raw:123456789.-1234567890");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:m";
        v = Version.create((String)"raw:m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:M";
        v = Version.create((String)"raw:M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:-M";
        v = Version.create((String)"raw:-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)"0.0.0", (String)v.toString());
        s = "raw:1.m";
        v = Version.create((String)"raw:1.m");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.M";
        v = Version.create((String)"raw:1.M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:1.-M");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'a'";
        v = Version.create((String)"raw:'a'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:\"a\"";
        v = Version.create((String)"raw:\"a\"");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:'a'";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'ab'";
        v = Version.create((String)"raw:'ab'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'abcdefghijklmnopqrstuvwxyz0123456789'";
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'";
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'-_!\"#$%&/()=?+*;,:.'";
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:\"'\"";
        v = Version.create((String)"raw:\"'\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:'\"'";
        v = Version.create((String)"raw:'\"'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
    }

    public void testIntegerParsing() {
        Version v = Version.create((String)"raw:0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)0);
        v = Version.create((String)"raw:0.1.2.3.4.5.6.7.8.9");
        RawVersionTest.assertNotNull((Object)v);
        int i = 0;
        while (i < 10) {
            RawVersionTest.assertEquals((Object)v.getSegment(i), (Object)i);
            ++i;
        }
        v = Version.create((String)"raw:0.-1.-2.-3.-4.-5.-6.-7.-8.-9");
        RawVersionTest.assertNotNull((Object)v);
        i = 0;
        while (i < 10) {
            RawVersionTest.assertEquals((Object)v.getSegment(i), (Object)(-i));
            ++i;
        }
        v = Version.create((String)"raw:123456789.-1234567890");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)123456789);
        RawVersionTest.assertEquals((Object)v.getSegment(1), (Object)-1234567890);
    }

    public void testWhiteSpaceExceptions() {
        try {
            Version.create((String)"raw: 0 ");
            RawVersionTest.fail((String)"space not allowed 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
        try {
            Version.create((String)"raw:0 .1  . 'a'.   'b c d'. 4. 5. 6.   7. 8 .  9");
            RawVersionTest.fail((String)"space not allowed 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
        try {
            Version.create((String)"raw:< 1.2.3>");
            RawVersionTest.fail((String)"space not allowed in array 1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
        try {
            Version.create((String)"raw:<1.2.3 >");
            RawVersionTest.fail((String)"space not allowed in array 2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
        try {
            Version.create((String)"raw:1.- 1");
            RawVersionTest.fail((String)"Uncaught error: space between minus and number in negative");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testMaxParsing() {
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:m"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:M"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:-M"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.m"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.M"));
        RawVersionTest.assertNotNull((Object)Version.create((String)"raw:1.-M"));
    }

    public void testStringParsing() {
        Version v = Version.create((String)"raw:'a'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"a");
        v = Version.create((String)"raw:\"a\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"a");
        v = Version.create((String)"raw:'ab'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"ab");
        v = Version.create((String)"raw:'abcdefghijklmnopqrstuvwxyz0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"abcdefghijklmnopqrstuvwxyz0123456789");
        v = Version.create((String)"raw:'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        v = Version.create((String)"raw:'-_!\"#$%&/()=?+*;,:.'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"-_!\"#$%&/()=?+*;,:.");
        v = Version.create((String)"raw:\"'\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"'");
        v = Version.create((String)"raw:'\"'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"\"");
    }

    public void testEmptyStringParsing() {
        Version v = Version.create((String)"raw:''");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"");
        v = Version.create((String)"raw:\"\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"");
    }

    public void testStringConcatenation() {
        Version v = Version.create((String)"raw:'ab''cd'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"abcd");
        v = Version.create((String)"raw:'ab'\"cd\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"abcd");
        v = Version.create((String)"raw:\"ab\"\"cd\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"abcd");
    }

    public void testStringToString() {
        RawVersionTest.assertEquals((String)"raw:'abcd'", (String)Version.create((String)"raw:'ab''cd'").toString());
        RawVersionTest.assertEquals((String)"raw:'abcd'", (String)Version.create((String)"raw:'ab'\"cd\"").toString());
        RawVersionTest.assertEquals((String)"raw:'abcd'", (String)Version.create((String)"raw:\"ab\"\"cd\"").toString());
        RawVersionTest.assertEquals((String)"raw:\"'\"", (String)Version.create((String)"raw:\"'\"").toString());
        RawVersionTest.assertEquals((String)"raw:'\"'", (String)Version.create((String)"raw:'\"'").toString());
        RawVersionTest.assertEquals((String)"raw:'abc\"xxx\"and '\"'yyy'\"", (String)Version.create((String)"raw:'abc\"xxx\"'\"and 'yyy'\"").toString());
    }

    public void testArrayParsing() {
        Version v = null;
        v = Version.create((String)"raw:<1>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1)}, null));
        v = Version.create((String)"raw:<1.0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(0)}, null));
        v = Version.create((String)"raw:<'a'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a"}, null));
        v = Version.create((String)"raw:<'a'.'b'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a", "b"}, null));
        v = Version.create((String)"raw:<'a'.'b''c'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{"a", "bc"}, null));
        v = Version.create((String)"raw:<1.2.-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2)}, null));
        v = Version.create((String)"raw:<1.2.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), VersionVector.MAXS_VALUE}, null));
        v = Version.create((String)"raw:<1.2.M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{Integer.valueOf(1), Integer.valueOf(2), VersionVector.MAX_VALUE}, null));
        v = Version.create((String)"raw:<<1>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{new VersionVector(new Comparable[]{Integer.valueOf(1)}, null)}, null));
        v = Version.create((String)"raw:<<1.<2>>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)new VersionVector(new Comparable[]{new VersionVector(new Comparable[]{Integer.valueOf(1), new VersionVector(new Comparable[]{Integer.valueOf(2)}, null)}, null)}, null));
    }

    public void testArraySerialize() {
        Version v = null;
        v = Version.create((String)"raw:<1>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'.'b'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<'a'.'b''c'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<1.2.M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<<1>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:<<1.<2>>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    public void testArraytoString() {
        Version v = null;
        String s = null;
        s = "raw:<1>";
        v = Version.create((String)"raw:<1>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<1.0>";
        v = Version.create((String)"raw:<1.0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<'a'>";
        v = Version.create((String)"raw:<'a'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<'a'.'b'>";
        v = Version.create((String)"raw:<'a'.'b'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<'a'.'bc'>";
        v = Version.create((String)"raw:<'a'.'bc'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:<1.2.-M>");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:<1.2>";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<1.2.m>";
        v = Version.create((String)"raw:<1.2.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<1.2.M>";
        v = Version.create((String)"raw:<1.2.M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<<1>>";
        v = Version.create((String)"raw:<<1>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:<<1.<2>>>";
        v = Version.create((String)"raw:<<1.<2>>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
    }

    public void testArrayOrder() {
        Version v1 = Version.create((String)"raw:<1.0.0>");
        Version v2 = Version.create((String)"raw:<1.1.0>");
        Version v3 = Version.create((String)"raw:<1.0.0>.<1.0.0>");
        Version v4 = Version.create((String)"raw:<1.0.0>.<1.0.0>.'a'");
        Version v5 = Version.create((String)"raw:<1.0.0>.<1.0.1>");
        Version v6 = Version.create((String)"raw:<2.0.0>");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
    }

    public void testPadParsing1() {
        Version v = null;
        v = Version.create((String)"raw:1.0p0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:0");
        v = Version.create((String)"raw:1.0p'foo'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:'foo'");
        v = Version.create((String)"raw:1.0p<0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0>");
        v = Version.create((String)"raw:1.0p<'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<'foo'>");
        v = Version.create((String)"raw:1.0pm");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:m");
        v = Version.create((String)"raw:1.0pM");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getPad(), null);
        v = Version.create((String)"raw:1.0p<m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<m>");
        v = Version.create((String)"raw:1.0p<M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<M>");
        v = Version.create((String)"raw:1.0p<-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<-M>");
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<1.0.0.'r12345'.m>");
    }

    public void testPadSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1.0p0");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p'foo'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0pm");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0pM");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p-M");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    public void testPadtoString() {
        Version v = null;
        String s = null;
        v = Version.create((String)"raw:1.0p0");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1p0";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p'foo'";
        v = Version.create((String)"raw:1.0p'foo'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0>";
        v = Version.create((String)"raw:1.0p<0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<'foo'>";
        v = Version.create((String)"raw:1.0p<'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0pm";
        v = Version.create((String)"raw:1.0pm");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0pM";
        v = Version.create((String)"raw:1.0pM");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:1.0p-M");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1.0";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<m>";
        v = Version.create((String)"raw:1.0p<m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<M>";
        v = Version.create((String)"raw:1.0p<M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<-M>";
        v = Version.create((String)"raw:1.0p<-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<1.0.0.'r12345'.m>";
        v = Version.create((String)"raw:1.0p<1.0.0.'r12345'.m>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
    }

    public void testNestedPadParsing() {
        Version v = null;
        v = Version.create((String)"raw:1.0p<0p0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p0>");
        this.assertPadPad(v, "raw:0");
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p'foo'>");
        this.assertPadPad(v, "raw:'foo'");
        v = Version.create((String)"raw:1.0p<0p<0>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<0>>");
        this.assertPadPad(v, "raw:<0>");
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<'foo'>>");
        this.assertPadPad(v, "raw:<'foo'>");
        v = Version.create((String)"raw:1.0p<0pm>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pm>");
        this.assertPadPad(v, "raw:m");
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pM>");
        this.assertPadPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p-M>");
        this.assertPadPad(v, null);
        RawVersionTest.assertEquals((Object)((VersionVector)v.getPad()).getPad(), null);
        v = Version.create((String)"raw:1.0p<0p<m>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p<m>>");
        this.assertPadPad(v, "raw:<m>");
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0pM>");
        this.assertPadPad(v, "raw:M");
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertPad(v, "raw:<0p-M>");
        this.assertPadPad(v, null);
    }

    public void testNestedPadSerialize() {
        Version v = null;
        v = Version.create((String)"raw:1.0p<0p0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<0>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pm>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p<m>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertSerialized(v);
    }

    public void testNestedPadtoString() {
        Version v = null;
        String s = null;
        s = "raw:1.0p<0p0>";
        v = Version.create((String)"raw:1.0p<0p0>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0p'foo'>";
        v = Version.create((String)"raw:1.0p<0p'foo'>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0p<0>>";
        v = Version.create((String)"raw:1.0p<0p<0>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0p<'foo'>>";
        v = Version.create((String)"raw:1.0p<0p<'foo'>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0pm>";
        v = Version.create((String)"raw:1.0p<0pm>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0pM>";
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1.0p<0>";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0p<m>>";
        v = Version.create((String)"raw:1.0p<0p<m>>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0p<0pM>";
        v = Version.create((String)"raw:1.0p<0pM>");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((String)s, (String)v.toString());
        v = Version.create((String)"raw:1.0p<0p-M>");
        RawVersionTest.assertNotNull((Object)v);
        s = "raw:1.0p<0>";
        RawVersionTest.assertEquals((String)s, (String)v.toString());
    }

    public void testPadOrder() {
        Version v1 = Version.create((String)"raw:1p-M");
        Version v2 = Version.create((String)"raw:1.0.0");
        Version v3 = Version.create((String)"raw:1.0.0p0");
        Version v4 = Version.create((String)"raw:1p0");
        Version v5 = Version.create((String)"raw:1.1");
        Version v6 = Version.create((String)"raw:1.1.1");
        Version v7 = Version.create((String)"raw:1p1");
        Version v8 = Version.create((String)"raw:1.1p1");
        Version v9 = Version.create((String)"raw:1pM");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertEquals((Object)v3, (Object)v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
        RawVersionTest.assertEquals((Object)v7, (Object)v8);
        RawVersionTest.assertOrder(v8, v9);
    }

    public void testPadTypeOrder() {
        Version v0 = Version.create((String)"raw:1p-M");
        Version v1 = Version.create((String)"raw:1p'a'");
        Version v2 = Version.create((String)"raw:1p<0>");
        Version v3 = Version.create((String)"raw:1.0.0");
        Version v4 = Version.create((String)"raw:1p0");
        Version v5 = Version.create((String)"raw:1p1");
        Version v6 = Version.create((String)"raw:1pM");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
    }

    public void testOriginalTerminator() {
        Version v = Version.create((String)"raw:'/'");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"/");
        v = Version.create((String)"raw:\"/\"");
        RawVersionTest.assertNotNull((Object)v);
        RawVersionTest.assertEquals((Object)v.getSegment(0), (Object)"/");
    }

    public void testEmptyInput() {
        try {
            Version.create((String)"raw:");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testNewLine() {
        try {
            Version.create((String)"raw:1.'\n'.2");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testSpaceInInt() {
        try {
            Version.create((String)"raw:1 2.2");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testFloatingPointl() {
        try {
            Version.create((String)"raw:1,2.2");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testScientific() {
        try {
            Version.create((String)"raw:1E3");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testHex() {
        try {
            Version.create((String)"raw:0xABCD");
            RawVersionTest.fail((String)"Uncaught error: hexadecimal not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedSingleQuoteRight() {
        try {
            Version.create((String)"raw:'unbalanced");
            RawVersionTest.fail((String)"Uncaught error: unbalanced sngle quote");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testMixedQuotes1() {
        try {
            Version.create((String)"raw:1.\"unbalanced'.10");
            RawVersionTest.fail((String)"Uncaught error: mixed quotes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testMixedQuotes2() {
        try {
            Version.create((String)"raw:1.'unbalanced\".10");
            RawVersionTest.fail((String)"Uncaught error: mixed quotes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedDoubleQuoteRight() {
        try {
            Version.create((String)"raw:\"unbalanced");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedArrayRight() {
        try {
            Version.create((String)"raw:<1.2.3");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedArrayLeft() {
        try {
            Version.create((String)"raw:1.2.3>");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testBadDecimalInteger() {
        try {
            Version.create((String)"raw:12af");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnquotedStringFirstValue() {
        try {
            Version.create((String)"raw:a");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnquotedStringSecondValue() {
        try {
            Version.create((String)"raw:1.a");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testSinglePeriod() {
        try {
            Version.create((String)"raw:.");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testTwoPeriods() {
        try {
            Version.create((String)"raw:..");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testThreePeriods() {
        try {
            Version.create((String)"raw:...");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testPadNotLast() {
        try {
            Version.create((String)"raw:p10.10");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testEmptyPad() {
        try {
            Version.create((String)"raw:10p");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testPadWithNull() {
        try {
            Version.create((String)"raw:10p.");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testWrongPadSeparator() {
        try {
            Version.create((String)"raw:10.p0");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testMultiplePadElements() {
        try {
            Version.create((String)"raw:10p1.2");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedPadElementsSQ() {
        try {
            Version.create((String)"raw:10p'abc");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedPadElementsDQ() {
        try {
            Version.create((String)"raw:10p\"abc");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedPadArrayElementsRight() {
        try {
            Version.create((String)"raw:10p<10");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testUnbalancedPadArrayElementsLeft() {
        try {
            Version.create((String)"raw:10p10>");
            RawVersionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawVersionTest.assertTrue((boolean)true);
        }
    }

    public void testOrder() {
        Version v1 = Version.create((String)"raw:1");
        Version v2 = Version.create((String)"raw:1.0");
        Version v3 = Version.create((String)"raw:1.0.0");
        Version v4 = Version.create((String)"raw:1.0.0.'9'");
        Version v5 = Version.create((String)"raw:1.0.0.'r12345'");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
    }

    public void testTypeOrder() {
        Version v0 = Version.create((String)"raw:-M");
        Version v1 = Version.create((String)"raw:''");
        Version v2 = Version.create((String)"raw:'z'");
        Version v3 = Version.create((String)"raw:m");
        Version v4 = Version.create((String)"raw:<0>");
        Version v5 = Version.create((String)"raw:<M>");
        Version v6 = Version.create((String)"raw:0");
        Version v7 = Version.create((String)"raw:M");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
    }

    public void testTypeOrder2() {
        Version v0 = Version.create((String)"raw:0.-M");
        Version v1 = Version.create((String)"raw:0.''");
        Version v2 = Version.create((String)"raw:0.'z'");
        Version v3 = Version.create((String)"raw:0.m");
        Version v4 = Version.create((String)"raw:0.<0>");
        Version v5 = Version.create((String)"raw:0.<M>");
        Version v6 = Version.create((String)"raw:0.0");
        Version v7 = Version.create((String)"raw:0.M");
        RawVersionTest.assertOrder(v0, v1);
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
    }

    public void testShorterIsOlder() {
        Version v1 = Version.create((String)"raw:1.0");
        Version v2 = Version.create((String)"raw:1.0.0");
        Version v3 = Version.create((String)"raw:1.0.0.0");
        Version v4 = Version.create((String)"raw:'a'");
        Version v5 = Version.create((String)"raw:'a'.'b'.'b'");
        Version v6 = Version.create((String)"raw:'a'.'b'.'b'.'b'");
        Version v7 = Version.create((String)"raw:<1>");
        Version v8 = Version.create((String)"raw:<1>.<0>.<0>");
        Version v9 = Version.create((String)"raw:<1>.<0>.<0>.<0>");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v7, v8);
        RawVersionTest.assertOrder(v8, v9);
    }

    public void testNumericVersionOrder() {
        Version v1 = Version.create((String)"1");
        Version v2 = Version.create((String)"1.0.1");
        Version v3 = Version.create((String)"1.1");
        Version v4 = Version.create((String)"1.1.1");
        Version v5 = Version.create((String)"1.1.1.-");
        Version v6 = Version.create((String)"1.2");
        Version v7 = Version.create((String)"2");
        Version v8 = Version.create((String)"10.0");
        RawVersionTest.assertOrder(v1, v2);
        RawVersionTest.assertOrder(v2, v3);
        RawVersionTest.assertOrder(v3, v4);
        RawVersionTest.assertOrder(v4, v5);
        RawVersionTest.assertOrder(v5, v6);
        RawVersionTest.assertOrder(v6, v7);
        RawVersionTest.assertOrder(v7, v8);
    }
}

