/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class RawWithOriginalTest
extends VersionTesting {
    public void testRawWithUnknownFormat() {
        Version v = Version.parseVersion((String)"raw:1.0/:silver.moon");
        RawWithOriginalTest.assertNotNull((Object)v);
        RawWithOriginalTest.assertEquals((Object)v, (Object)Version.parseVersion((String)"raw:1.0"));
    }

    public void testRawWithUnknownFormatToString() {
        RawWithOriginalTest.assertEquals((String)"raw:1.0/:silver.moon", (String)Version.parseVersion((String)"raw:1.0/:silver.moon").toString());
    }

    public void testRawWithUnknownFormatSerialized() {
        RawWithOriginalTest.assertSerialized(Version.parseVersion((String)"raw:1.0/:silver.moon"));
        RawWithOriginalTest.assertEquals((String)"raw:1.0/:silver.moon", (String)RawWithOriginalTest.getSerialized(Version.create((String)"raw:1.0/:silver.moon")).toString());
    }

    public void testRawWithSimpleFormat() {
        Version v = Version.parseVersion((String)"raw:1.0/format(n.n):1.0");
        RawWithOriginalTest.assertNotNull((Object)v);
        RawWithOriginalTest.assertEquals((Object)v, (Object)Version.parseVersion((String)"raw:1.0"));
    }

    public void testRawWithSimpleFormatToString() {
        RawWithOriginalTest.assertEquals((String)"raw:1.0/format(n.n):1.0", (String)Version.parseVersion((String)"raw:1.0/format(n.n):1.0").toString());
    }

    public void testRawWithSimpleFormatSerialized() {
        RawWithOriginalTest.assertSerialized(Version.parseVersion((String)"raw:1.0/format(n.n):1.0"));
        RawWithOriginalTest.assertEquals((String)"raw:1.0/format(n.n):1.0", (String)RawWithOriginalTest.getSerialized(Version.create((String)"raw:1.0/format(n.n):1.0")).toString());
    }

    public void testOriginalStatedButMissing() {
        try {
            Version.parseVersion((String)"raw:1.0/");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalAndUnknownStatedButMissing() {
        try {
            Version.parseVersion((String)"raw:1.0/:");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat() {
        try {
            Version.parseVersion((String)"raw:1.0/foo:");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat2() {
        try {
            Version.parseVersion((String)"raw:1.0/100:");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat3() {
        try {
            Version.parseVersion((String)"raw:1.0/'format':");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat4() {
        try {
            Version.parseVersion((String)"raw:1.0//1.0");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat5() {
        try {
            Version.parseVersion((String)"raw:1.0/format:");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatUnbalancedLeft() {
        try {
            Version.parseVersion((String)"raw:1.0/formatn.n):");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatUnbalancedRight() {
        try {
            Version.parseVersion((String)"raw:1.0/format(n.n:1.0");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatOriginalMissing() {
        try {
            Version.parseVersion((String)"raw:1.0/format(n.n):");
            RawWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawWithOriginalTest.assertTrue((boolean)true);
        }
    }
}

