/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.metadata.VersionVector;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class VersionTesting
extends TestCase {
    public void assertIncludedInRange(String message, VersionRange range, String versionString) {
        VersionTesting.assertTrue((String)message, (boolean)range.isIncluded(Version.parseVersion((String)versionString)));
    }

    public void assertNotIncludedInRange(String message, VersionRange range, String versionString) {
        VersionTesting.assertFalse((String)message, (boolean)range.isIncluded(Version.parseVersion((String)versionString)));
    }

    public static void assertOrder(Object a, Object b) {
        if (!(a instanceof Comparable) || !(b instanceof Comparable)) {
            VersionTesting.fail((String)"can not assert order on non Comparable instances");
        }
        if (((Comparable)a).compareTo(b) > 0) {
            VersionTesting.fail((String)"a > b");
        } else if (((Comparable)b).compareTo(a) < 0) {
            VersionTesting.fail((String)"b < a");
        } else if (((Comparable)b).compareTo(a) == 0) {
            VersionTesting.fail((String)"b == a");
        } else if (((Comparable)a).compareTo(b) == 0) {
            VersionTesting.fail((String)"a == b");
        }
        VersionTesting.assertTrue((boolean)true);
    }

    public static void assertPad(Version v, String rawVersionString) {
        VersionTesting.assertNotNull((Object)v);
        Comparable cmp = null;
        if (rawVersionString != null) {
            Version v2 = Version.create((String)rawVersionString);
            VersionTesting.assertNotNull((Object)v2);
            VersionTesting.assertTrue((v2.getSegmentCount() == 1 ? 1 : 0) != 0);
            cmp = v2.getSegment(0);
        }
        VersionTesting.assertEquals((Object)v.getPad(), cmp);
    }

    public void assertPadPad(Version v, String rawVersionString) {
        VersionTesting.assertNotNull((Object)v);
        Comparable pad = v.getPad();
        VersionTesting.assertTrue((boolean)(pad instanceof VersionVector));
        Comparable cmp = null;
        if (rawVersionString != null) {
            Version v2 = Version.create((String)rawVersionString);
            VersionTesting.assertNotNull((Object)v2);
            VersionTesting.assertTrue((v2.getSegmentCount() == 1 ? 1 : 0) != 0);
            cmp = v2.getSegment(0);
        }
        VersionTesting.assertEquals((Object)((VersionVector)pad).getPad(), cmp);
    }

    public static void assertSerialized(VersionRange range) {
        VersionRange serialized = VersionTesting.getSerialized(range);
        VersionTesting.assertEquals((Object)range, (Object)serialized);
        VersionTesting.assertEquals((String)range.toString(), (String)serialized.toString());
    }

    public static VersionRange getSerialized(VersionRange range) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                os.writeObject(range);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"close of output stream failed");
        }
        ObjectInputStream is = null;
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            is = new ObjectInputStream(in);
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"Can not create object input stream");
        }
        VersionRange range2 = null;
        try {
            range2 = (VersionRange)is.readObject();
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"IO failure reading version range");
        }
        catch (ClassNotFoundException classNotFoundException) {
            VersionTesting.fail((String)"ClassNotFountException");
        }
        return range2;
    }

    public static void assertSerialized(Version v) {
        Version serialized = VersionTesting.getSerialized(v);
        VersionTesting.assertEquals((Object)v, (Object)serialized);
        VersionTesting.assertEquals((String)v.toString(), (String)serialized.toString());
    }

    public static Version getSerialized(Version v) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                os.writeObject(v);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"close of output stream failed");
        }
        ObjectInputStream is = null;
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            is = new ObjectInputStream(in);
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"Can not create object input stream");
        }
        Version v2 = null;
        try {
            v2 = (Version)is.readObject();
        }
        catch (IOException iOException) {
            VersionTesting.fail((String)"IO failure reading version range");
        }
        catch (ClassNotFoundException classNotFoundException) {
            VersionTesting.fail((String)"ClassNotFountException");
        }
        return v2;
    }
}

