/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.perf;

import junit.framework.TestCase;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.perf.ProvisioningPerformanceTest;

public class PublisherPerformanceTest
extends ProvisioningPerformanceTest {
    private static final int REPEATS = 5;

    public void testQueryPublisherResult() {
        new PerformanceTestRunner(){
            IQuery<IInstallableUnit>[] queries = new IQuery[3000];
            PublisherResult result;

            protected void setUp() {
                IInstallableUnit[] ius = new IInstallableUnit[3000];
                this.result = new PublisherResult();
                int i = 0;
                while (i < ius.length) {
                    ius[i] = PublisherPerformanceTest.this.generateIU(i);
                    this.result.addIU(ius[i], "root");
                    this.queries[i] = QueryUtil.createIUQuery((String)ius[i].getId(), (Version)ius[i].getVersion());
                    ++i;
                }
            }

            protected void test() {
                int i = 0;
                while (i < this.queries.length) {
                    this.result.query(this.queries[i], null);
                    ++i;
                }
            }
        }.run((TestCase)this, "Test query PublisherResult for 3000 ius", 5, 10);
    }

    public void testLimitQueryPublisherResult() {
        new PerformanceTestRunner(){
            IQuery<IInstallableUnit>[] queries = new IQuery[3000];
            PublisherResult result;

            protected void setUp() {
                IInstallableUnit[] ius = new IInstallableUnit[3000];
                this.result = new PublisherResult();
                int i = 0;
                while (i < ius.length) {
                    ius[i] = PublisherPerformanceTest.this.generateIU(i);
                    this.result.addIU(ius[i], "root");
                    this.queries[i] = QueryUtil.createLimitQuery((IQuery)QueryUtil.createIUQuery((String)ius[i].getId(), (Version)ius[i].getVersion()), (int)1);
                    ++i;
                }
            }

            protected void test() {
                int i = 0;
                while (i < this.queries.length) {
                    this.result.query(this.queries[i], null);
                    ++i;
                }
            }
        }.run((TestCase)this, "Test query PublisherResult for 3000 ius", 5, 10);
    }
}

