/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Arrays;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AdditionalConstraints
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnit x1;
    IProfile profile;
    IPlanner planner;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = AdditionalConstraints.createIU("A", Version.create((String)"1.0.0"), AdditionalConstraints.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[1.0.0, 4.0.0)")));
        this.b1 = AdditionalConstraints.createIU("B", Version.create((String)"1.0.0"), true);
        this.b2 = AdditionalConstraints.createIU("B", Version.create((String)"2.0.0"), true);
        this.b3 = AdditionalConstraints.createIU("B", Version.create((String)"3.0.0"), true);
        this.x1 = AdditionalConstraints.createIU("X", Version.createOSGi((int)2, (int)0, (int)0), AdditionalConstraints.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[2.0.0, 2.0.0]")));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.b3, this.x1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = AdditionalConstraints.createPlanner();
    }

    public void testInstallA1() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        ProvisioningContext ctx = new ProvisioningContext(AdditionalConstraints.getAgent());
        req.addExtraRequirements(Arrays.asList(AdditionalConstraints.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[2.0.0, 2.0.0]"))[0]));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, ctx, null);
        AdditionalConstraints.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AdditionalConstraints.assertInstallOperand(plan, this.a1);
        AdditionalConstraints.assertInstallOperand(plan, this.b2);
        AdditionalConstraints.assertNoOperand(plan, this.x1);
    }

    public void testExtraRequirement() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        ProvisioningContext ctx = new ProvisioningContext(AdditionalConstraints.getAgent());
        req.addExtraRequirements(Arrays.asList(AdditionalConstraints.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[1.0.0, 4.0.0]"))[0]));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, ctx, null);
        AdditionalConstraints.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AdditionalConstraints.assertInstallOperand(plan, this.b3);
        AdditionalConstraints.assertNoOperand(plan, this.x1);
    }
}

