/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug255984
extends AbstractProvisioningTest {
    IInstallableUnit a;
    IInstallableUnit b;
    IInstallableUnit c;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a = Bug255984.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)}, NO_PROPERTIES, true);
        this.b = Bug255984.createIU("B", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a, this.b});
        this.planner = Bug255984.createPlanner();
        this.engine = Bug255984.createEngine();
    }

    public void testProperties() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile1);
        req.addInstallableUnits(new IInstallableUnit[]{this.b});
        req.setInstallableUnitInclusionRules(this.b, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.b));
        req.setInstallableUnitProfileProperty(this.b, "foo", "bar");
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        Bug255984.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        Bug255984.assertProfileContainsAll("B is missing", this.profile1, new IInstallableUnit[]{this.b});
        Bug255984.assertEquals((int)1, (int)Bug255984.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.a});
        req2.setInstallableUnitInclusionRules(this.a, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.a));
        req2.setInstallableUnitProfileProperty(this.a, "foo", "bar");
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        Bug255984.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        this.engine.perform(plan2, null);
        Bug255984.assertProfileContainsAll("A is missing", this.profile1, new IInstallableUnit[]{this.a, this.b});
        Bug255984.assertEquals((int)2, (int)Bug255984.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)));
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.removeInstallableUnits(new IInstallableUnit[]{this.b});
        req3.removeInstallableUnitProfileProperty(this.b, "foo");
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        Bug255984.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        this.engine.perform(plan3, null);
        Bug255984.assertProfileContainsAll("A is missing", this.profile1, new IInstallableUnit[]{this.a, this.b});
        Bug255984.assertEquals((int)1, (int)Bug255984.queryResultSize(this.profile1.query((IQuery)new IUProfilePropertyQuery("foo", "bar"), (IProgressMonitor)new NullProgressMonitor())));
        Bug255984.assertEquals((int)2, (int)Bug255984.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)));
    }
}

