/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug271954
extends AbstractProvisioningTest {
    private static final String profileLoadedId = "SDKProfile";
    private IProfile profile;
    private File previousStoreValue = null;
    private Object previousSelfProfile = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug271954.getTestData("test data bug 271954", "testData/bug271954");
        File tempFolder = this.getTempFolder();
        Bug271954.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, tempFolder);
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
        selfField.setAccessible(true);
        this.previousSelfProfile = selfField.get(realProfileRegistry);
        selfField.set(realProfileRegistry, profileLoadedId);
        this.profile = realProfileRegistry.getProfile(profileLoadedId);
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        Field selfField = SimpleProfileRegistry.class.getDeclaredField("self");
        selfField.setAccessible(true);
        selfField.set(realProfileRegistry, this.previousSelfProfile);
        super.tearDown();
    }

    public void testUninstallMyBundle() {
        IQueryResult c = this.profile.available(QueryUtil.createIUQuery((String)"A"), (IProgressMonitor)new NullProgressMonitor());
        Bug271954.assertEquals((int)1, (int)Bug271954.queryResultSize(c));
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.removeInstallableUnits((IInstallableUnit[])c.toArray(IInstallableUnit.class));
        ProvisioningContext ctx = new ProvisioningContext(Bug271954.getAgent());
        ctx.setMetadataRepositories(new URI[0]);
        ctx.setArtifactRepositories(new URI[0]);
        IProvisioningPlan plan = Bug271954.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, ctx, (IProgressMonitor)new NullProgressMonitor());
        Bug271954.assertOK("Uninstall plan for myBundle", plan.getStatus());
        Bug271954.assertNotNull((Object)plan.getInstallerPlan().getFutureState());
        Bug271954.assertEquals((int)0, (int)Bug271954.queryResultSize(plan.getInstallerPlan().getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        Bug271954.assertEquals((int)0, (int)Bug271954.queryResultSize(plan.getInstallerPlan().getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        Bug271954.assertUninstallOperand(plan, (IInstallableUnit)c.iterator().next());
        Bug271954.assertEquals((int)2, (int)Bug271954.queryResultSize(plan.getRemovals().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        Bug271954.assertEquals((int)1, (int)Bug271954.queryResultSize(plan.getRemovals().query(QueryUtil.createIUQuery((String)"A", (Version)Version.createOSGi((int)1, (int)0, (int)0)), (IProgressMonitor)new NullProgressMonitor())));
        Bug271954.assertEquals((int)1, (int)Bug271954.queryResultSize(plan.getRemovals().query(QueryUtil.createIUQuery((String)"Action1", (Version)Version.createOSGi((int)1, (int)0, (int)0)), (IProgressMonitor)new NullProgressMonitor())));
    }
}

