/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug300572
extends AbstractProvisioningTest {
    public void testInstallSecondPatch() throws ProvisionException {
        IProvisioningAgentProvider provider = Bug300572.getAgentProvider();
        IProvisioningAgent agent = provider.createAgent(Bug300572.getTestData("Bug300572 data", "testData/bug300572/p2").toURI());
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repo = repoMgr.loadRepository(Bug300572.getTestData("bug300572 data", "testData/bug300572/repo/").toURI(), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] ius = (IInstallableUnit[])repo.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group"), null).toArray(IInstallableUnit.class);
        System.out.println(ius);
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        IProfile sdkProfile = ((IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)).getProfile("SDKProfile");
        Bug300572.assertFalse((boolean)sdkProfile.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group"), null).isEmpty());
        Bug300572.assertFalse((boolean)sdkProfile.query(QueryUtil.createIUQuery((String)"hellofeature.feature.group"), null).isEmpty());
        IProfileChangeRequest request = planner.createChangeRequest(sdkProfile);
        IQueryResult allIUs = repo.query(QueryUtil.ALL_UNITS, null);
        request.addAll((Collection)allIUs.toUnmodifiableSet());
        for (IInstallableUnit iu : allIUs) {
            request.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
        }
        ProvisioningContext pc = new ProvisioningContext(agent);
        IProvisioningPlan plan = planner.getProvisioningPlan(request, pc, (IProgressMonitor)new NullProgressMonitor());
        Bug300572.assertOK("plan is not ok", plan.getStatus());
        Bug300572.assertFalse((String)"hellopatch.feature.group not found", (boolean)plan.getAdditions().query(QueryUtil.createIUQuery((String)"hellopatch.feature.group", (Version)Version.create((String)"1.0.2.201001211536")), null).isEmpty());
    }
}

